/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.refresh;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreeFactory;
import org.eclipse.sirius.tree.TreeItemStyle;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.business.internal.internal.color.TreeStyleColorUpdater;
import org.eclipse.sirius.tree.description.ConditionalTreeItemStyleDescription;
import org.eclipse.sirius.tree.description.DescriptionPackage;
import org.eclipse.sirius.tree.description.StyleUpdater;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreeItemStyleDescription;
import org.eclipse.sirius.tree.description.TreeMapping;
import org.eclipse.sirius.tree.impl.DTreeElementSynchronizerImpl;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.FontFormat;

public class DTreeElementSynchronizerSpec
extends DTreeElementSynchronizerImpl {
    private final IInterpreter interpreter;
    private ModelAccessor modelAccessor;

    public DTreeElementSynchronizerSpec(IInterpreter interpreter, ModelAccessor modelAccessor) {
        this.interpreter = interpreter;
        this.modelAccessor = modelAccessor;
    }

    public void refreshSemanticElements(DTreeElement treeElement) {
        this.refreshSemanticElements(treeElement, treeElement.getTreeElementMapping());
    }

    public void refreshSemanticElements(DTreeElement treeElement, TreeMapping mapping) {
        if (this.modelAccessor.getPermissionAuthority().canEditInstance((EObject)treeElement)) {
            if (mapping.getSemanticElements() != null && !StringUtil.isEmpty((String)mapping.getSemanticElements())) {
                Collection<Object> elements;
                if (treeElement.eContainer() != null) {
                    this.interpreter.setVariable("containerView", (Object)treeElement.eContainer());
                    if (treeElement.eContainer() instanceof DSemanticDecorator) {
                        this.interpreter.setVariable("container", (Object)((DSemanticDecorator)treeElement.eContainer()).getTarget());
                    }
                }
                this.interpreter.setVariable("view", (Object)treeElement);
                if (mapping instanceof TreeItemMapping) {
                    elements = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateCollection(treeElement.getTarget(), (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getTreeMapping_SemanticElements());
                } else {
                    try {
                        elements = this.interpreter.evaluateCollection(treeElement.getTarget(), mapping.getSemanticElements());
                    }
                    catch (EvaluationException evaluationException) {
                        elements = Collections.emptyList();
                    }
                }
                this.synchronizeLists((EList<EObject>)treeElement.getSemanticElements(), elements);
                if (treeElement.eContainer() != null) {
                    this.interpreter.unSetVariable("containerView");
                    if (treeElement.eContainer() instanceof DSemanticDecorator) {
                        this.interpreter.unSetVariable("container");
                    }
                }
                this.interpreter.unSetVariable("view");
            } else if (treeElement.getTarget() != null) {
                this.synchronizeLists((EList<EObject>)treeElement.getSemanticElements(), Collections.singletonList(treeElement.getTarget()));
            } else {
                List<EObject> elements = Collections.emptyList();
                this.synchronizeLists((EList<EObject>)treeElement.getSemanticElements(), elements);
            }
        }
    }

    private void synchronizeLists(EList<EObject> semanticElements, Collection<EObject> newElements) {
        if (!semanticElements.containsAll(newElements) || !newElements.containsAll((Collection<?>)semanticElements)) {
            Iterator it = semanticElements.iterator();
            while (it.hasNext()) {
                EObject cur = (EObject)it.next();
                if (newElements.contains(cur)) continue;
                it.remove();
            }
            semanticElements.addAll(newElements);
        }
    }

    @Override
    public void refresh(DTreeItem treeItem) {
        if (this.modelAccessor.getPermissionAuthority().canEditInstance((EObject)treeItem)) {
            this.refreshStyle(treeItem);
            this.refreshSemanticElements(treeItem);
        }
    }

    public void refreshItemAndChildren(DTreeItem treeItem) {
        this.refresh(treeItem);
        for (DTreeItem item : treeItem.getOwnedTreeItems()) {
            if (!treeItem.isExpanded()) continue;
            this.refreshItemAndChildren(item);
        }
    }

    private void refreshStyle(DTreeItem treeItem) {
        if (treeItem.getOwnedStyle() == null) {
            treeItem.setOwnedStyle(TreeFactory.eINSTANCE.createTreeItemStyle());
        }
        TreeItemStyle style = treeItem.getOwnedStyle();
        this.doUpdateStyle(treeItem, style);
    }

    private void doUpdateStyle(DTreeItem treeItem, TreeItemStyle style) {
        TreeStyleColorUpdater colorUpdater = new TreeStyleColorUpdater();
        TreeItemStyleDescription bestTreeItemStyle = this.getBestTreeItemStyle(treeItem);
        if (bestTreeItemStyle != null) {
            colorUpdater.updateBackgroundColor(style, bestTreeItemStyle.getBackgroundColor(), treeItem.getTarget());
            colorUpdater.updateLabelColor(style, bestTreeItemStyle.getLabelColor(), treeItem.getTarget());
            if (bestTreeItemStyle.getLabelFormat() != null && !this.isEqual((List<FontFormat>)style.getLabelFormat(), (List<FontFormat>)bestTreeItemStyle.getLabelFormat())) {
                FontFormatHelper.setFontFormat((List)style.getLabelFormat(), (Collection)bestTreeItemStyle.getLabelFormat());
            }
            if (bestTreeItemStyle.getLabelSize() != -1 && style.getLabelSize() != bestTreeItemStyle.getLabelSize()) {
                style.setLabelSize(bestTreeItemStyle.getLabelSize());
            }
            if (bestTreeItemStyle.getLabelAlignment() != null && style.getLabelAlignment() != bestTreeItemStyle.getLabelAlignment()) {
                style.setLabelAlignment(bestTreeItemStyle.getLabelAlignment());
            }
            this.refreshLabel(treeItem, bestTreeItemStyle, style);
            if (style.isShowIcon() != bestTreeItemStyle.isShowIcon()) {
                style.setShowIcon(bestTreeItemStyle.isShowIcon());
            }
            if (style.getIconPath() != null && !style.getIconPath().equals(bestTreeItemStyle.getIconPath())) {
                style.setIconPath(bestTreeItemStyle.getIconPath());
            }
        }
    }

    private void refreshLabel(DTreeItem treeItem, TreeItemStyleDescription bestTreeItemStyle, TreeItemStyle style) {
        String labelExpression = bestTreeItemStyle.getLabelExpression();
        if (!StringUtil.isEmpty((String)labelExpression) && treeItem.getTarget() != null) {
            try {
                try {
                    DTree tree;
                    if (treeItem != null) {
                        this.interpreter.setVariable("treeitem", (Object)treeItem);
                        this.interpreter.setVariable("treeitemSemantic", (Object)treeItem.getTarget());
                        this.interpreter.setVariable("container", (Object)treeItem.getTarget());
                    }
                    if ((tree = TreeHelper.getTree((EObject)treeItem)) != null) {
                        this.interpreter.setVariable("root", (Object)tree.getTarget());
                    }
                    String label = this.interpreter.evaluateString(treeItem.getTarget(), labelExpression);
                    treeItem.setName(label);
                }
                catch (EvaluationException evaluationException) {
                    if (treeItem != null) {
                        this.interpreter.unSetVariable("container");
                        this.interpreter.unSetVariable("treeitem");
                        this.interpreter.unSetVariable("treeitemSemantic");
                    }
                    this.interpreter.unSetVariable("root");
                }
            }
            finally {
                if (treeItem != null) {
                    this.interpreter.unSetVariable("container");
                    this.interpreter.unSetVariable("treeitem");
                    this.interpreter.unSetVariable("treeitemSemantic");
                }
                this.interpreter.unSetVariable("root");
            }
        }
    }

    private boolean isEqual(List<FontFormat> labelFormat, List<FontFormat> labelFormat2) {
        if (labelFormat != null && labelFormat2 != null) {
            return labelFormat.equals(labelFormat2);
        }
        return false;
    }

    private TreeItemStyleDescription getBestTreeItemStyle(DTreeItem item) {
        TreeItemStyleDescription bestForegroundStyleDescription = null;
        boolean bestStyleIsConditonalStyle = false;
        StyleUpdater updater = item.getStyleUpdater();
        if (!bestStyleIsConditonalStyle && updater.getDefaultStyle() != null) {
            bestForegroundStyleDescription = updater.getDefaultStyle();
        }
        for (ConditionalTreeItemStyleDescription condStyle : updater.getConditionalStyles()) {
            if (condStyle.getStyle() == null || item.getTarget() == null) continue;
            boolean predicate = false;
            try {
                predicate = this.interpreter.evaluateBoolean(item.getTarget(), condStyle.getPredicateExpression());
            }
            catch (EvaluationException evaluationException) {}
            if (!predicate) continue;
            bestForegroundStyleDescription = condStyle.getStyle();
            bestStyleIsConditonalStyle = true;
        }
        return bestForegroundStyleDescription;
    }
}

