/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.analysis;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.semantic.RemoveSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class RemoveSemanticResourceAction
extends Action {
    private Session session;
    private Collection<Resource> toRemove;

    public RemoveSemanticResourceAction(Collection<Resource> selection, Session session) {
        super("Remove Model");
        this.session = session;
        this.toRemove = new ArrayList<Resource>(selection);
    }

    public boolean isEnabled() {
        boolean res = super.isEnabled();
        res = res && this.session != null;
        res = res && !this.toRemove.isEmpty();
        res = res && this.checkResources();
        return res;
    }

    public void run() {
        if (!this.isEnabled() || !this.checkResources()) {
            return;
        }
        TransactionalEditingDomain transDomain = this.session.getTransactionalEditingDomain();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (Resource semanticResourceToRemove : this.toRemove) {
            compoundCommand.append((Command)new RemoveSemanticResourceCommand(this.session, semanticResourceToRemove, (IProgressMonitor)new NullProgressMonitor(), true));
        }
        transDomain.getCommandStack().execute((Command)compoundCommand);
    }

    private boolean checkResources() {
        boolean okForRemove = true;
        if (this.session instanceof DAnalysisSessionEObject) {
            boolean bl = okForRemove = !Iterables.removeAll(this.toRemove, (Collection)((DAnalysisSessionEObject)this.session).getControlledResources());
        }
        if (okForRemove) {
            for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(this.session)) {
                DSemanticDecorator decorator;
                if (!(representation instanceof DSemanticDecorator) || (decorator = (DSemanticDecorator)representation).getTarget() == null || !this.toRemove.contains(decorator.getTarget().eResource())) continue;
                okForRemove = false;
                break;
            }
        }
        return okForRemove;
    }
}

