/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ext.emf.ui.ICellEditorProvider;
import org.eclipse.sirius.ext.emf.ui.properties.CellEditorProviderCollector;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class SiriusCellEditorProviderCollector
implements CellEditorProviderCollector {
    public static final String EXTENSION_POINT_ID = "org.eclipse.sirius.ui.siriuspropertiescelleditor";
    private static SiriusCellEditorProviderCollector instance;
    private Set<ICellEditorProvider> cache;

    private SiriusCellEditorProviderCollector() {
    }

    public static SiriusCellEditorProviderCollector getInstance() {
        if (instance == null) {
            instance = new SiriusCellEditorProviderCollector();
        }
        return instance;
    }

    private void loadCache() {
        IConfigurationElement[] config;
        this.cache = new HashSet<ICellEditorProvider>();
        IConfigurationElement[] iConfigurationElementArray = config = EclipseUtil.getConfigurationElementsFor((String)EXTENSION_POINT_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object contribution = configurationElement.createExecutableExtension("class");
                if (contribution instanceof ICellEditorProvider) {
                    this.cache.add((ICellEditorProvider)contribution);
                }
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", "Cannot instantiate the Cell Editor Provider contributions", (Throwable)e));
            }
            ++n2;
        }
    }

    public List<ICellEditorProvider> getCellEditorProviders(EObject eObject, IItemPropertyDescriptor itemPropertyDescriptor) {
        if (this.cache == null) {
            this.loadCache();
        }
        ArrayList<ICellEditorProvider> cellEditorProviders = new ArrayList<ICellEditorProvider>();
        for (ICellEditorProvider currentCellEditorProvider : this.cache) {
            if (!currentCellEditorProvider.provides(eObject, itemPropertyDescriptor)) continue;
            cellEditorProviders.add(currentCellEditorProvider);
        }
        return cellEditorProviders;
    }
}

