/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.dialect.DialectServices;
import org.eclipse.sirius.business.api.dialect.RepresentationNotification;
import org.eclipse.sirius.business.api.dialect.identifier.RepresentationElementIdentifier;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public abstract class AbstractRepresentationDialectServices
implements DialectServices {
    protected static final Set<EReference> REPRESENTATION_ELEMENTS_INVERSE_REFERENCES = Sets.newHashSet();

    static {
        REPRESENTATION_ELEMENTS_INVERSE_REFERENCES.add(ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
        REPRESENTATION_ELEMENTS_INVERSE_REFERENCES.add(ViewpointPackage.eINSTANCE.getDRepresentationElement_SemanticElements());
    }

    protected abstract boolean isSupported(DRepresentation var1);

    protected abstract boolean isSupported(RepresentationDescription var1);

    @Override
    public void notify(RepresentationNotification notification) {
    }

    @Override
    public boolean canCreateIdentifier(EObject representationElement) {
        return false;
    }

    @Override
    public RepresentationElementIdentifier createIdentifier(EObject representationElement, Map<EObject, RepresentationElementIdentifier> elementToIdentifier) {
        return null;
    }

    @Override
    public void updateRepresentationsExtendedBy(Session session, Viewpoint viewpoint, boolean activated) {
    }

    @Override
    public void refreshEffectiveRepresentationDescription(DRepresentation representation, IProgressMonitor monitor) {
    }

    @Override
    public void refresh(DRepresentation representation, IProgressMonitor monitor) {
        this.refresh(representation, false, monitor);
    }

    @Override
    public void refreshImpactedElements(DRepresentation representation, Collection<Notification> notifications, IProgressMonitor monitor) {
    }

    @Override
    public Collection<DRepresentation> getRepresentations(EObject semantic, Session session) {
        return this.getRepresentations(session, "DREPRESENTATION", semantic);
    }

    @Override
    public Collection<DRepresentation> getAllRepresentations(Session session) {
        return this.getRepresentations(session, "DREPRESENTATION", null);
    }

    @Override
    public Collection<DRepresentation> getRepresentations(RepresentationDescription representationDescription, Session session) {
        return this.getRepresentations(session, "DREPRESENTATION_FROM_DESCRIPTION", representationDescription);
    }

    @Override
    public boolean canRefresh(DRepresentation representation) {
        return this.isSupported(representation);
    }

    @Override
    public DRepresentation copyRepresentation(DRepresentation representation, String name, Session session, IProgressMonitor monitor) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        DRepresentation newRepresentation = (DRepresentation)copier.copy((EObject)representation);
        copier.copyReferences();
        newRepresentation.setName(name);
        return newRepresentation;
    }

    @Override
    public boolean deleteRepresentation(DRepresentation representation, Session session) {
        if (this.isSupported(representation)) {
            SiriusUtil.delete(representation, session);
            return true;
        }
        return false;
    }

    @Override
    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        DRepresentation representation = null;
        try {
            monitor.beginTask("Create representation : " + name, 2);
            representation = this.createRepresentation(name, semantic, description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (representation != null) {
                session.getServices().putCustomData("DREPRESENTATION", semantic, representation);
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return representation;
    }

    protected abstract DRepresentation createRepresentation(String var1, EObject var2, RepresentationDescription var3, IProgressMonitor var4);

    @Override
    public Collection<RepresentationDescription> getAvailableRepresentationDescriptions(Collection<Viewpoint> vps, EObject semantic) {
        ArrayList result = Lists.newArrayList();
        for (Viewpoint vp : vps) {
            Iterables.addAll((Collection)result, this.getAvailableRepresentationDescriptions(vp, semantic));
        }
        return result;
    }

    protected Collection<DRepresentation> getRepresentations(Session session, String key, EObject value) {
        ArrayList reps = Lists.newArrayList();
        for (EObject representation : session.getServices().getCustomData(key, value)) {
            if (!(representation instanceof DRepresentation) || !this.isSupported((DRepresentation)representation)) continue;
            reps.add((DRepresentation)representation);
        }
        return reps;
    }

    protected Iterable<RepresentationDescription> getAvailableRepresentationDescriptions(Viewpoint vp, final EObject semantic) {
        Iterable<RepresentationDescription> candidates = new ViewpointQuery(vp).getAllRepresentationDescriptions();
        return Iterables.filter(candidates, (Predicate)new Predicate<RepresentationDescription>(){

            public boolean apply(RepresentationDescription input) {
                return AbstractRepresentationDialectServices.this.canCreate(semantic, input);
            }
        });
    }

    protected boolean checkPrecondition(EObject semantic, String condition) {
        boolean canCreate;
        if (StringUtil.isEmpty((String)condition)) {
            canCreate = true;
        } else {
            try {
                IInterpreter interpreter = InterpreterUtil.getInterpreter(semantic);
                canCreate = interpreter.evaluateBoolean(semantic, condition);
            }
            catch (EvaluationException evaluationException) {
                canCreate = false;
            }
        }
        return canCreate;
    }

    protected boolean checkDomainClass(ModelAccessor accessor, EObject semantic, String domainClass) {
        return !StringUtil.isEmpty((String)domainClass) && accessor.eInstanceOf(semantic, domainClass);
    }

    protected boolean checkSemanticElementCanBeFilled(ModelAccessor accessor, EObject semantic) {
        return accessor.getPermissionAuthority().canCreateIn(semantic);
    }

    protected void initRepresentations(EObject semantic, Viewpoint vp, Class<? extends RepresentationDescription> representationDescriptionType) {
        this.initRepresentations(semantic, vp, representationDescriptionType, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initRepresentations(EObject semantic, Viewpoint vp, Class<? extends RepresentationDescription> representationDescriptionType, IProgressMonitor monitor) {
        Collection<? extends RepresentationDescription> descriptions = this.collectRepresentationDescriptions(vp, representationDescriptionType);
        this.initRepresentations(descriptions, semantic, monitor);
    }

    private <T extends RepresentationDescription> Collection<T> collectRepresentationDescriptions(Viewpoint viewpoint, Class<T> expectedRepresentationDescriptionType) {
        ArrayList<RepresentationDescription> descriptions = new ArrayList<RepresentationDescription>();
        for (RepresentationDescription representationDescription : new ViewpointQuery(viewpoint).getAllRepresentationDescriptions()) {
            if (!expectedRepresentationDescriptionType.isAssignableFrom(representationDescription.getClass()) || !representationDescription.isInitialisation()) continue;
            descriptions.add(representationDescription);
        }
        return descriptions;
    }

    private void initRepresentations(Collection<? extends RepresentationDescription> descriptions, EObject rootSemanticElement, IProgressMonitor monitor) {
        if (descriptions.isEmpty()) {
            return;
        }
        try {
            monitor.beginTask("Representations initialization : ", descriptions.size());
            for (RepresentationDescription representationDescription : descriptions) {
                this.initRepresentationForElement(representationDescription, rootSemanticElement, monitor);
            }
            TreeIterator treeIterator = rootSemanticElement.eAllContents();
            while (treeIterator.hasNext()) {
                EObject currentSemanticElement = (EObject)treeIterator.next();
                for (RepresentationDescription representationDescription : descriptions) {
                    this.initRepresentationForElement(representationDescription, currentSemanticElement, monitor);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract <T extends RepresentationDescription> void initRepresentationForElement(T var1, EObject var2, IProgressMonitor var3);

    protected boolean shouldInitializeRepresentation(EObject semanticElement, RepresentationDescription description, String domainClass) {
        boolean shouldInitializeRepresentation = !StringUtil.isEmpty((String)domainClass) && description.isInitialisation();
        return shouldInitializeRepresentation;
    }

    @Override
    public void invalidateMappingCache() {
    }

    @Override
    public Option<? extends AbstractCommandTask> createTask(CommandContext context, ModelAccessor extPackage, ModelOperation op, Session session, UICallBack uiCallback) {
        return Options.newNone();
    }

    @Override
    public boolean allowsEStructuralFeatureCustomization(EObject choice) {
        return false;
    }
}

