/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.scxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExmodeDatatype implements Enumerator
{
    LAX(0, "lax", "lax"),
    STRICT(1, "strict", "strict");

    public static final int LAX_VALUE = 0;
    public static final int STRICT_VALUE = 1;
    private static final ExmodeDatatype[] VALUES_ARRAY;
    public static final List<ExmodeDatatype> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExmodeDatatype[]{LAX, STRICT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExmodeDatatype get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExmodeDatatype result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExmodeDatatype getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExmodeDatatype result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExmodeDatatype get(int value) {
        switch (value) {
            case 0: {
                return LAX;
            }
            case 1: {
                return STRICT;
            }
        }
        return null;
    }

    private ExmodeDatatype(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

