/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.api.interaction;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.interaction.DTreeItemUserInteraction;
import org.eclipse.sirius.tree.business.api.query.TreeDescriptionQuery;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.DTreeRefresh;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;

public class DTreeUserInteraction {
    private DTree tree;
    private GlobalContext ctx;

    public DTreeUserInteraction(DTree tree, GlobalContext ctx) {
        this.tree = tree;
        this.ctx = ctx;
    }

    public DTreeUserInteraction refreshContent(IProgressMonitor monitor) {
        return this.refreshContent(false, monitor);
    }

    public DTreeUserInteraction refreshContent(boolean fullRefresh, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refresh tree", 1);
            DslCommonPlugin.PROFILER.startWork("Refresh a tree");
            SemanticPartitionInvalidator invalidator = new SemanticPartitionInvalidator();
            DTreeRefresh refresher = new DTreeRefresh(this.tree, new TreeDescriptionQuery(this.tree.getDescription()).getAllDescendantMappings(), invalidator, this.ctx);
            refresher.refresh(fullRefresh, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            DslCommonPlugin.PROFILER.stopWork("Refresh a tree");
        }
        finally {
            monitor.done();
        }
        return this;
    }

    public DTreeUserInteraction expandAll() {
        return this.expand((IProgressMonitor)new NullProgressMonitor());
    }

    public DTreeUserInteraction expandAll(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Tree item expandion", this.tree.getOwnedTreeItems().size());
            for (DTreeItem child : this.tree.getOwnedTreeItems()) {
                new DTreeItemUserInteraction(child, this.ctx).expandAll((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
        return this;
    }

    public DTreeUserInteraction expand() {
        return this.expand((IProgressMonitor)new NullProgressMonitor());
    }

    public DTreeUserInteraction expand(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Tree item expanding", this.tree.getOwnedTreeItems().size());
            for (DTreeItem child : this.tree.getOwnedTreeItems()) {
                if (!child.isExpanded()) {
                    new DTreeItemUserInteraction(child, this.ctx).expand((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return this;
    }
}

