/*******************************************************************************
 * Copyright (c) 2007-2013 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.sirius.diagram.sequence.template;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>TAbstract Mapping</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 * <li>
 * {@link org.eclipse.sirius.diagram.sequence.template.TAbstractMapping#getName
 * <em>Name</em>}</li>
 * <li>
 * {@link org.eclipse.sirius.diagram.sequence.template.TAbstractMapping#getDomainClass
 * <em>Domain Class</em>}</li>
 * <li>
 * {@link org.eclipse.sirius.diagram.sequence.template.TAbstractMapping#getSemanticCandidatesExpression
 * <em>Semantic Candidates Expression</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.sirius.diagram.sequence.template.TemplatePackage#getTAbstractMapping()
 * @model
 * @generated
 */
public interface TAbstractMapping extends TTransformer {
    /**
     * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
     * begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
     * should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     *
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     * @see org.eclipse.sirius.diagram.sequence.template.TemplatePackage#getTAbstractMapping_Name()
     * @model required="true"
     * @generated
     */
    String getName();

    /**
     * Sets the value of the '
     * {@link org.eclipse.sirius.diagram.sequence.template.TAbstractMapping#getName
     * <em>Name</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @param value
     *            the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     * @generated
     */
    void setName(String value);

    /**
     * Returns the value of the '<em><b>Domain Class</b></em>' attribute. <!--
     * begin-user-doc --> <!-- end-user-doc --> <!-- begin-model-doc --> The
     * domain class of the mapping. <!-- end-model-doc -->
     *
     * @return the value of the '<em>Domain Class</em>' attribute.
     * @see #setDomainClass(String)
     * @see org.eclipse.sirius.diagram.sequence.template.TemplatePackage#getTAbstractMapping_DomainClass()
     * @model dataType="org.eclipse.sirius.description.TypeName" required="true"
     * @generated
     */
    String getDomainClass();

    /**
     * Sets the value of the '
     * {@link org.eclipse.sirius.diagram.sequence.template.TAbstractMapping#getDomainClass
     * <em>Domain Class</em>}' attribute. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @param value
     *            the new value of the '<em>Domain Class</em>' attribute.
     * @see #getDomainClass()
     * @generated
     */
    void setDomainClass(String value);

    /**
     * Returns the value of the '<em><b>Semantic Candidates Expression</b></em>'
     * attribute. <!-- begin-user-doc --> <!-- end-user-doc --> <!--
     * begin-model-doc --> In the default case, candidates of a mapping are all
     * EObjet owned by the semantic element of the view container. The
     * semanticCandidatesExpression is an expression that returns the list of
     * EObject that are candidates of the mapping instead of the candidates of
     * the default case. The context of the expression is the semantic element
     * of the view container. <!-- end-model-doc -->
     *
     * @return the value of the '<em>Semantic Candidates Expression</em>'
     *         attribute.
     * @see #setSemanticCandidatesExpression(String)
     * @see org.eclipse.sirius.diagram.sequence.template.TemplatePackage#getTAbstractMapping_SemanticCandidatesExpression()
     * @model dataType="org.eclipse.sirius.description.InterpretedExpression"
     *        annotation
     *        ="http://www.eclipse.org/emf/2002/GenModel contentassist=''"
     * @generated
     */
    String getSemanticCandidatesExpression();

    /**
     * Sets the value of the '
     * {@link org.eclipse.sirius.diagram.sequence.template.TAbstractMapping#getSemanticCandidatesExpression
     * <em>Semantic Candidates Expression</em>}' attribute. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @param value
     *            the new value of the '<em>Semantic Candidates Expression</em>'
     *            attribute.
     * @see #getSemanticCandidatesExpression()
     * @generated
     */
    void setSemanticCandidatesExpression(String value);

} // TAbstractMapping
