/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.swtbot.support.api.business.AbstractUIRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusHelper;
import org.eclipse.sirius.tests.swtbot.support.api.view.DesignerViews;
import org.eclipse.sirius.tests.swtbot.support.api.view.SiriusOutlineView;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.hamcrest.Matcher;

public class UIDiagramRepresentation
extends AbstractUIRepresentation<SWTBotSiriusDiagramEditor> {
    public static final ZoomLevel ZOOM_DEFAULT = ZoomLevel.ZOOM_100;

    public UIDiagramRepresentation(SWTBotTreeItem treeItem, String representationName) {
        super(treeItem, representationName);
    }

    public UIDiagramRepresentation open() {
        super.doOpen();
        return this;
    }

    public UIDiagramRepresentation save() {
        super.doSave();
        return this;
    }

    public UIDiagramRepresentation zoomDefault() {
        return this.zoom(ZOOM_DEFAULT);
    }

    public UIDiagramRepresentation zoom(ZoomLevel zoomLevel) {
        this.getEditor().zoom(zoomLevel);
        return this;
    }

    public UIDiagramRepresentation changeLayerActivation(String layerName) {
        if (this.useTabbar()) {
            SWTBotToolbarDropDownButton button = this.designerBot.toolbarDropDownButtonWithTooltip("Layers");
            Matcher withLayerName = WidgetMatcherFactory.withText((String)layerName);
            SWTBotMenu layerButton = button.menuItem(withLayerName);
            layerButton.click();
        } else {
            DesignerViews designerViews = new DesignerViews(this.designerBot);
            SiriusOutlineView outlineView = designerViews.getOutlineView().layers();
            outlineView.activateLayer(layerName);
        }
        return this;
    }

    private boolean useTabbar() {
        IPreferencesService prefs = Platform.getPreferencesService();
        return !prefs.getBoolean("org.eclipse.sirius.diagram.ui", SiriusDiagramUiPreferencesKeys.PREF_OLD_UI.name(), false, null);
    }

    @Override
    public SWTBotSiriusDiagramEditor getEditor() {
        String expectedTitle = this.getRepresentationName();
        if (TestsUtil.isLunaPlatform()) {
            expectedTitle = ((String)Objects.firstNonNull((Object)this.getRepresentationName(), (Object)"")).trim();
        }
        return SWTBotSiriusHelper.getDesignerEditorContainingName(expectedTitle);
    }

    public static enum ZoomLevel {
        ZOOM_50("50%", 0.5),
        ZOOM_100("100%", 1.0),
        ZOOM_125("125%", 1.25),
        ZOOM_200("200%", 2.0),
        ZOOM_400("400%", 4.0);

        private final String level;
        private final double amount;

        private ZoomLevel(String level, double amount) {
            this.level = level;
            this.amount = amount;
        }

        public String getLevel() {
            return this.level;
        }

        public double getAmount() {
            return this.amount;
        }

        public static ZoomLevel createNextZoomInLevel(double currentZoomLevel) {
            ZoomLevel nextZoomInLevel = ZOOM_100;
            if (currentZoomLevel >= 2.0) {
                nextZoomInLevel = ZOOM_400;
            }
            if (currentZoomLevel >= 1.25) {
                nextZoomInLevel = ZOOM_200;
            } else if (currentZoomLevel >= 1.0) {
                nextZoomInLevel = ZOOM_125;
            }
            return nextZoomInLevel;
        }

        public static ZoomLevel createNextZoomOutLevel(double currentZoomLevel) {
            ZoomLevel nextZoomOutLevel = ZOOM_200;
            if (currentZoomLevel <= 1.0) {
                nextZoomOutLevel = ZOOM_50;
            } else if (currentZoomLevel <= 1.25) {
                nextZoomOutLevel = ZOOM_100;
            } else if (currentZoomLevel <= 2.0) {
                nextZoomOutLevel = ZOOM_125;
            }
            return nextZoomOutLevel;
        }
    }
}

