/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.common.ui.tools.api.resource.WorkspaceResourceDialogWithFilter;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WorkspaceImagePathSelector
extends SelectionAdapter {
    private static final List<String> IMAGE_FILE_EXTENSIONS = new ArrayList<String>();
    private Text workspacePathText;

    static {
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.VALUES;
        int n = ImageFileFormat.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat imageFileFormat = imageFileFormatArray[n2];
            IMAGE_FILE_EXTENSIONS.add(imageFileFormat.getName().toLowerCase());
            ++n2;
        }
    }

    public WorkspaceImagePathSelector(Text workspacePathText) {
        this.workspacePathText = workspacePathText;
    }

    public void widgetSelected(SelectionEvent e) {
        IFile[] selectedResources;
        ArrayList filters = Lists.newArrayList();
        if (IMAGE_FILE_EXTENSIONS != null) {
            filters.add(new FileExtensionFilter(IMAGE_FILE_EXTENSIONS));
        }
        if ((selectedResources = WorkspaceResourceDialogWithFilter.openFileSelection((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.WorkspaceImagePathSelector_dialogTitle, (String)Messages.WorkspaceImagePathSelector_dialogMessage, (boolean)false, null, (List)filters)) != null && selectedResources.length == 1) {
            this.workspacePathText.setText(selectedResources[0].getFullPath().makeRelative().toString());
        }
    }

    private static class FileExtensionFilter
    extends ViewerFilter {
        private List<String> extensions;

        public FileExtensionFilter(List<String> extensions) {
            this.extensions = extensions;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean isValid = true;
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                String fileExtension = file.getFileExtension();
                isValid = fileExtension != null && this.extensions.contains(fileExtension.toLowerCase());
            } else if (element instanceof IContainer) {
                isValid = false;
                IContainer container = (IContainer)element;
                if (!container.isDerived()) {
                    try {
                        IResource[] members;
                        IResource[] iResourceArray = members = container.members();
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            isValid = this.select(viewer, parentElement, member);
                            if (!isValid) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
            return isValid;
        }
    }
}

