/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarFiller;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarFillerWithContributions;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarFillerWithoutContributions;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarToolBarManager;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class Tabbar
extends Composite
implements ISelectionListener,
IAuthorityListener {
    public static final String TABBAR_ID = "org.eclipse.sirius.diagram.ui.tabbar";
    private IDiagramWorkbenchPart part;
    private IWorkbenchPage page;
    private ToolBar toolBar;
    private ToolBarManager manager;
    private TabbarFiller diagramFiller;
    private IPermissionAuthority permissionAuthority;

    public Tabbar(Composite parent, IDiagramWorkbenchPart part) {
        super(parent, 0);
        this.setLayoutData(new GridData(768));
        this.part = part;
        this.page = part.getSite().getPage();
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createToolBar();
        this.fillForDiagram();
    }

    public IToolBarManager getToolBarManager() {
        return this.manager;
    }

    private void createToolBar() {
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.toolBar.setBackgroundMode(1);
        this.toolBar.setLayoutData((Object)new GridData(768));
        this.manager = new TabbarToolBarManager(this.toolBar, (IWorkbenchPart)this.part);
        this.setPermissionAuthorityListener();
    }

    private void setPermissionAuthorityListener() {
        if (this.part instanceof DDiagramEditor) {
            DDiagramEditor editor = (DDiagramEditor)this.part;
            this.permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editor.getSession().getSessionResource().getResourceSet());
            if (this.permissionAuthority != null) {
                this.permissionAuthority.addAuthorityListener((IAuthorityListener)this);
            }
        }
    }

    private void fillForDiagram() {
        this.diagramFiller = Tabbar.canBeDynamic() ? new TabbarFillerWithContributions(this.manager, this.page) : new TabbarFillerWithoutContributions(this.manager, this.page);
        this.diagramFiller.setPart(this.part);
        this.diagramFiller.fill();
    }

    public static boolean canBeDynamic() {
        boolean canBeDynamic = false;
        Bundle uiWorkbenchBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
        if (uiWorkbenchBundle != null) {
            Version junoStart = Version.parseVersion((String)"3.103");
            Version lunaStart = Version.parseVersion((String)"3.106");
            Version currentVersion = uiWorkbenchBundle.getVersion();
            canBeDynamic = currentVersion.compareTo(junoStart) < 0 || currentVersion.compareTo(lunaStart) >= 0;
        }
        return canBeDynamic;
    }

    public void selectionChanged(IWorkbenchPart partSelected, ISelection selection) {
    }

    public void reinitToolBar(ISelection iSelection) {
        this.updateAllItems();
    }

    public void dispose() {
        this.unSetPermissionAuthorityListener();
        if (this.diagramFiller != null) {
            this.diagramFiller.dispose();
            this.diagramFiller = null;
        }
        this.manager.dispose();
        this.manager.removeAll();
        this.part = null;
        this.page = null;
        this.toolBar.dispose();
        this.toolBar = null;
    }

    private void unSetPermissionAuthorityListener() {
        this.permissionAuthority.removeAuthorityListener((IAuthorityListener)this);
        this.permissionAuthority = null;
    }

    private void updateAllItems() {
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                List<IContributionItem> items = Arrays.asList(Tabbar.this.manager.getItems());
                for (IContributionItem item : items) {
                    item.update();
                }
            }
        });
    }

    public void notifyIsLocked(EObject instance) {
        this.updateAllItems();
    }

    public void notifyIsReleased(EObject instance) {
        this.updateAllItems();
    }

    public void notifyIsLocked(Collection<EObject> instances) {
        this.updateAllItems();
    }

    public void notifyIsReleased(Collection<EObject> instances) {
        this.updateAllItems();
    }

    public boolean setFocus() {
        return false;
    }
}

