/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions;

import org.eclipse.core.expressions.Expression;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.TabbarZoomAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.TabbarZoomInAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.TabbarZoomOutAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.SiriusTabbarExtensionContributionFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.expressions.DDiagramTabbarExpression;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class ZoomExtensionContributionFactory
extends SiriusTabbarExtensionContributionFactory {
    @Override
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        super.createContributionItems(serviceLocator, additions);
        this.addZoomInZoomOut(additions);
        ZoomComboContributionItem zoomItem = new ZoomComboContributionItem((IPartService)this.getPage()){

            public void fill(ToolBar parent, int index) {
                super.fill(parent, index);
                ToolItem addedItem = parent.getItem(index);
                addedItem.setToolTipText(DiagramUIMessages.ZoomActionMenu_ZoomLabel);
            }
        };
        additions.addContributionItem((IContributionItem)zoomItem, (Expression)new DDiagramTabbarExpression());
    }

    private void addZoomInZoomOut(IContributionRoot additions) {
        TabbarZoomInAction zoomIn = new TabbarZoomInAction();
        zoomIn.setImageDescriptor(DiagramUIPluginImages.DESC_ZOOM_IN);
        zoomIn.setText(DiagramUIMessages.ZoomAction_ZoomIn);
        TabbarZoomOutAction zoomOut = new TabbarZoomOutAction();
        zoomOut.setImageDescriptor(DiagramUIPluginImages.DESC_ZOOM_OUT);
        zoomIn.setText(DiagramUIMessages.ZoomAction_ZoomOut);
        additions.addContributionItem((IContributionItem)new ZoomContributionItem((IAction)zoomIn, this.getPage()), (Expression)new DDiagramTabbarExpression());
        additions.addContributionItem((IContributionItem)new ZoomContributionItem((IAction)zoomOut, this.getPage()), (Expression)new DDiagramTabbarExpression());
    }

    public static class ZoomContributionItem
    extends ActionContributionItem {
        private IPartListener listener;
        private IWorkbenchPage page;

        public ZoomContributionItem(final IAction action, IWorkbenchPage page) {
            super(action);
            this.page = page;
            this.listener = new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                    if (part instanceof DDiagramEditor) {
                        ZoomManager zoomManager = (ZoomManager)part.getAdapter(ZoomManager.class);
                        if (action instanceof TabbarZoomAction) {
                            ((TabbarZoomAction)action).setZoomManager(zoomManager);
                        }
                    }
                }

                public void partBroughtToTop(IWorkbenchPart p) {
                }

                public void partClosed(IWorkbenchPart p) {
                }

                public void partDeactivated(IWorkbenchPart p) {
                }

                public void partOpened(IWorkbenchPart p) {
                }
            };
            page.addPartListener(this.listener);
        }

        public void dispose() {
            super.dispose();
            if (this.page != null) {
                this.page.removePartListener(this.listener);
                this.page = null;
            }
            this.listener = null;
        }
    }
}

