/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.Tabbar;
import org.eclipse.sirius.tests.support.api.ICondition;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class TestsUtil {
    private static final String UI_WORKBENCH_JUNO_START = "3.103";
    private static final String UI_WORKBENCH_KEPLER_START = "3.105";
    private static final String UI_WORKBENCH_LUNA_START = "3.106";

    protected TestsUtil() {
    }

    public static void emptyEventsFromUIThread() {
        boolean shouldRetry = false;
        do {
            try {
                TestsUtil.synchronizationWithUIThread();
                shouldRetry = false;
            }
            catch (Exception exception) {
                shouldRetry = true;
            }
        } while (shouldRetry);
    }

    public static void synchronizationWithUIThread() {
        while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
        }
    }

    public static boolean shouldSkipLongTests() {
        return "true".equals(System.getProperty("org.eclipse.sirius.tests.skipLongTests"));
    }

    public static boolean shouldRunUnreliableTests() {
        return !TestsUtil.shouldSkipUnreliableTests();
    }

    public static boolean shouldSkipUnreliableTests() {
        return "true".equals(System.getProperty("org.eclipse.sirius.tests.skipUnreliableTests"));
    }

    public static boolean shouldRunLongTests() {
        return !TestsUtil.shouldSkipLongTests();
    }

    public static boolean isJuno3Platform() {
        boolean isJuno3Platform = false;
        String platformVersion = (String)Platform.getBundle((String)"org.eclipse.core.runtime").getHeaders().get("Bundle-Version");
        if (platformVersion.startsWith("3.8")) {
            isJuno3Platform = true;
        }
        return isJuno3Platform && !TestsUtil.isJuno4Platform();
    }

    public static boolean isEclipse4xPlatform() {
        Version junoStart = Version.parseVersion((String)UI_WORKBENCH_JUNO_START);
        return TestsUtil.checkUiWorkbenchVersion(junoStart, null);
    }

    public static boolean isJuno4Platform() {
        Version junoStart = Version.parseVersion((String)UI_WORKBENCH_JUNO_START);
        Version keplerStart = Version.parseVersion((String)UI_WORKBENCH_KEPLER_START);
        return TestsUtil.checkUiWorkbenchVersion(junoStart, keplerStart);
    }

    private static boolean checkUiWorkbenchVersion(Version versiontStart, Version versionEnd) {
        Bundle uiWorkbenchBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
        if (uiWorkbenchBundle != null) {
            return uiWorkbenchBundle.getVersion().compareTo(versiontStart) >= 0 && (versionEnd == null || uiWorkbenchBundle.getVersion().compareTo(versionEnd) < 0);
        }
        return false;
    }

    public static boolean isKeplerPlatform() {
        Version keplerStart = Version.parseVersion((String)UI_WORKBENCH_KEPLER_START);
        Version lunaStart = Version.parseVersion((String)UI_WORKBENCH_LUNA_START);
        return TestsUtil.checkUiWorkbenchVersion(keplerStart, lunaStart);
    }

    public static boolean isLunaPlatform() {
        Version keplerStart = Version.parseVersion((String)UI_WORKBENCH_LUNA_START);
        return TestsUtil.checkUiWorkbenchVersion(keplerStart, null);
    }

    public static void waitUntil(ICondition condition, long timeout, long interval) {
        Assert.assertTrue((String)"interval value is negative", (interval >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"timeout value is negative", (timeout >= 0L ? 1 : 0) != 0);
        long limit = System.currentTimeMillis() + timeout;
        while (true) {
            try {
                if (condition.test()) {
                    return;
                }
            }
            catch (Throwable throwable) {}
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            if (System.currentTimeMillis() <= limit) continue;
            Assert.fail((String)("Timeout after: " + timeout + " ms.: " + condition.getFailureMessage()));
        }
    }

    public static void waitUntil(ICondition condition, long timeout) {
        TestsUtil.waitUntil(condition, timeout, 500L);
    }

    public static void waitUntil(ICondition condition) {
        TestsUtil.waitUntil(condition, 5000L, 500L);
    }

    public static boolean isDynamicTabbar() {
        return Tabbar.canBeDynamic();
    }
}

