/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.modelingproject;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.modelingproject.AbstractRepresentationsFileJob;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.modelingproject.manager.InitializeModelingProjectJob;
import org.eclipse.sirius.common.tools.api.util.MarkerUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionHelper;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenRepresentationsFileJob
extends AbstractRepresentationsFileJob {
    public static final String JOB_LABEL = Messages.OpenRepresentationsFileJob_label;
    private static final String QUOTE = "\"";
    List<URI> representationsFilesURIs = Lists.newArrayList();
    List<ModelingProject> modelingProjects = Lists.newArrayList();

    public OpenRepresentationsFileJob(URI representationsFileURI) {
        super(JOB_LABEL);
        this.representationsFilesURIs.add(representationsFileURI);
    }

    public OpenRepresentationsFileJob(List<? extends Object> elements) {
        super(JOB_LABEL);
        if (!Iterators.all(elements.iterator(), (Predicate)Predicates.instanceOf(URI.class)) && !Iterators.all(elements.iterator(), (Predicate)Predicates.instanceOf(ModelingProject.class))) {
            throw new IllegalArgumentException(Messages.OpenRepresentationsFileJob_errorInvalidInputList);
        }
        Iterators.addAll(this.representationsFilesURIs, (Iterator)Iterators.filter(elements.iterator(), URI.class));
        Iterators.addAll(this.modelingProjects, (Iterator)Iterators.filter(elements.iterator(), ModelingProject.class));
    }

    public static void scheduleNewWhenPossible(URI representationsFileURI, boolean user) {
        OpenRepresentationsFileJob.waitOtherJobs();
        OpenRepresentationsFileJob job = new OpenRepresentationsFileJob(representationsFileURI);
        job.setUser(user);
        job.setPriority(20);
        job.schedule();
    }

    public static void scheduleNewWhenPossible(List<? extends Object> elements, boolean user) {
        if (!Iterators.all(elements.iterator(), (Predicate)Predicates.instanceOf(URI.class)) && !Iterators.all(elements.iterator(), (Predicate)Predicates.instanceOf(ModelingProject.class))) {
            throw new IllegalArgumentException(Messages.OpenRepresentationsFileJob_errorInvalidInputList);
        }
        OpenRepresentationsFileJob.waitOtherJobs();
        OpenRepresentationsFileJob job = new OpenRepresentationsFileJob(elements);
        job.setUser(user);
        job.setPriority(20);
        job.schedule();
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        IStatus initializationStatus = Status.OK_STATUS;
        ArrayList openingStatuses = Lists.newArrayList();
        try {
            monitor.beginTask(Messages.OpenRepresentationsFileJob_loadingModelsTask, 11);
            monitor.subTask(Messages.OpenRepresentationsFileJob_initModelingProjectsTask);
            if (!this.modelingProjects.isEmpty()) {
                ArrayList projects = Lists.newArrayList();
                for (ModelingProject modelingProject : this.modelingProjects) {
                    projects.add(modelingProject.getProject());
                }
                initializationStatus = InitializeModelingProjectJob.initializeModelingProjects((List)projects, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                SubProgressMonitor getRepresentationsFilesMonitor = new SubProgressMonitor(monitor, 1);
                try {
                    getRepresentationsFilesMonitor.beginTask("", this.modelingProjects.size());
                    for (ModelingProject modelingProject : this.modelingProjects) {
                        Option optionalMainSessionFileURI = modelingProject.getMainRepresentationsFileURI((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)getRepresentationsFilesMonitor, 1), false, false);
                        if (!optionalMainSessionFileURI.some()) continue;
                        this.representationsFilesURIs.add((URI)optionalMainSessionFileURI.get());
                    }
                }
                finally {
                    getRepresentationsFilesMonitor.done();
                }
            } else {
                monitor.worked(3);
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 8);
            try {
                subMonitor.beginTask("", 100 * this.representationsFilesURIs.size());
                for (URI representationsFileURI : this.representationsFilesURIs) {
                    IProject project = null;
                    if (representationsFileURI.isPlatform()) {
                        String projectName = URI.decode((String)representationsFileURI.segment(1));
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    }
                    try {
                        if (project != null) {
                            project.deleteMarkers("org.eclipse.sirius.modelingMarker", false, 0);
                        }
                    }
                    catch (CoreException e) {
                        SiriusPlugin.getDefault().getLog().log(e.getStatus());
                    }
                    subMonitor.subTask(MessageFormat.format(Messages.OpenRepresentationsFileJob_loadingRepresentationFileTask, representationsFileURI.lastSegment()));
                    Set<Session> sessions = this.performOpenSession(representationsFileURI, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 90));
                    if (sessions.isEmpty()) {
                        subMonitor.worked(10);
                        String errorMessage = this.logLoadingProblem(project, representationsFileURI, null);
                        openingStatuses.add(new Status(4, "org.eclipse.sirius.ui", 0, errorMessage, null));
                        continue;
                    }
                    subMonitor.subTask(MessageFormat.format(Messages.OpenRepresentationsFileJob_openingStartRepresentationTask, representationsFileURI.lastSegment()));
                    for (Session session : sessions) {
                        SessionHelper.openStartupRepresentations(session, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10 / sessions.size()));
                    }
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
        ArrayList allStatuses = Lists.newArrayList((Iterable)openingStatuses);
        if (!initializationStatus.isOK()) {
            if (initializationStatus instanceof MultiStatus) {
                allStatuses.addAll(0, Lists.newArrayList((Object[])((MultiStatus)initializationStatus).getChildren()));
            } else {
                allStatuses.add(0, initializationStatus);
            }
        }
        IStatus result = Status.OK_STATUS;
        if (allStatuses.size() == 1) {
            result = (IStatus)allStatuses.get(0);
        } else if (allStatuses.size() > 1) {
            result = new MultiStatus("org.eclipse.sirius.ui", 4, allStatuses.toArray(new IStatus[0]), Messages.OpenRepresentationsFileJob_invalidModelingProjectsError, null);
        }
        return result;
    }

    protected String logLoadingProblem(IProject project, URI representationsFileURI, Exception exception) {
        String message = "";
        if (project != null) {
            Option optionalModelingProject;
            boolean isModelingProject = ModelingProject.hasModelingProjectNature((IProject)project);
            String errorDetail = exception != null ? (exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()) : Messages.OpenRepresentationsFileJob_loadingProblem_defaultErrorDetail;
            message = isModelingProject ? MessageFormat.format(Messages.OpenRepresentationsFileJob_loadingProblem_modelingProject, project.getName(), errorDetail) : MessageFormat.format(Messages.OpenRepresentationsFileJob_loadingProblem_representationFile, representationsFileURI.toPlatformString(true), errorDetail);
            Option optionalMarker = MarkerUtil.addMarkerFor((IResource)project, (String)message, (int)2, (String)"org.eclipse.sirius.modelingMarker");
            if (optionalMarker.some() && exception instanceof Resource.Diagnostic) {
                MarkerUtil.setAttribute((IMarker)((IMarker)optionalMarker.get()), (String)"location", (Object)((Resource.Diagnostic)exception).getLocation());
            }
            if ((optionalModelingProject = ModelingProject.asModelingProject((IProject)project)).some()) {
                ((ModelingProject)optionalModelingProject.get()).setValid(false);
            }
        }
        ModelingProjectManager.INSTANCE.clearCache(representationsFileURI);
        return message;
    }

    public Set<Session> performOpenSession(URI representationsFileURI, IProgressMonitor monitor) {
        monitor.beginTask(Messages.OpenRepresentationsFileJob_loadRepresentationsTask, 16);
        HashSet<Session> openedSessions = new HashSet<Session>();
        if ("aird".equals(representationsFileURI.fileExtension())) {
            monitor.worked(1);
            Session session = SessionManager.INSTANCE.getSession(representationsFileURI, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            monitor.subTask(MessageFormat.format(Messages.OpenRepresentationsFileJob_loadReferencedModelsTask, representationsFileURI.lastSegment()));
            if (session != null) {
                IEditingSession editingSession;
                if (!session.isOpen()) {
                    session.open((IProgressMonitor)new SubProgressMonitor(monitor, 4));
                }
                if (!(editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(session)).isOpen()) {
                    editingSession.open();
                }
                if (openedSessions != null) {
                    openedSessions.add(session);
                }
            }
            monitor.worked(1);
        }
        monitor.done();
        return openedSessions;
    }

    public static void waitOtherJobs() {
        if (OpenRepresentationsFileJob.shouldWaitOtherJobs()) {
            try {
                if (Display.getCurrent() != null) {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InterruptedException {
                            Job.getJobManager().join((Object)"org.eclipse.sirius.representationsFile", monitor);
                        }
                    });
                } else {
                    Job.getJobManager().join((Object)"org.eclipse.sirius.representationsFile", (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (InvocationTargetException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.sirius.ui", 0, OpenRepresentationsFileJob.getLocalizedMessage(e), OpenRepresentationsFileJob.getCause(e)));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean shouldWaitOtherJobs() {
        Job[] jobs = Job.getJobManager().find((Object)"org.eclipse.sirius.representationsFile");
        return jobs != null && jobs.length > 0;
    }

    protected static String getLocalizedMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                return ce.getStatus().getMessage();
            }
            message = Messages.OpenRepresentationsFileJob_unexpectedException;
        }
        return message;
    }

    protected static Throwable getCause(Throwable exception) {
        Throwable cause = null;
        if (exception != null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                cause = ce.getStatus().getException();
            } else {
                try {
                    Method causeMethod = exception.getClass().getMethod("getCause", new Class[0]);
                    Object o = causeMethod.invoke((Object)exception, new Object[0]);
                    if (o instanceof Throwable) {
                        cause = (Throwable)o;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if (cause == null) {
                cause = exception;
            }
        }
        return cause;
    }
}

