/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.viewpoint.DAnalysis;

public class ResourceQuery {
    protected final Resource resource;

    public ResourceQuery(Resource resource) {
        this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
    }

    public Collection<URI> getResolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        for (EObject root : this.resource.getContents()) {
            dependencies.addAll(new EObjectQuery(root).getResolvedDependencies());
        }
        return dependencies;
    }

    public Collection<URI> getUnresolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        for (EObject root : this.resource.getContents()) {
            dependencies.addAll(new EObjectQuery(root).getUnresolvedDependencies());
        }
        return dependencies;
    }

    public boolean isRepresentationsResource() {
        boolean isRepresentationsResource = false;
        try {
            isRepresentationsResource = this.resource.getURI() != null;
        }
        catch (IllegalStateException illegalStateException) {}
        isRepresentationsResource = isRepresentationsResource && new FileQuery(this.resource.getURI().fileExtension()).isSessionResourceFile();
        boolean bl = isRepresentationsResource = isRepresentationsResource || this.resource instanceof AirdResource;
        if (!isRepresentationsResource && !this.resource.getContents().isEmpty()) {
            for (EObject contentEObject : this.resource.getContents()) {
                if (!(contentEObject instanceof DAnalysis)) continue;
                isRepresentationsResource = true;
                break;
            }
        }
        return isRepresentationsResource;
    }

    public boolean isModelerResource() {
        if (this.resource.getURI() != null) {
            return new FileQuery(this.resource.getURI().fileExtension()).isVSMFile();
        }
        return false;
    }
}

