/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Objects;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SequenceMessageRangeHelper;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class SetMessageRangeOperation
extends AbstractModelChangeOperation<Void> {
    private Edge message;
    private final Range range;
    private View source;
    private Rectangle sourceBounds;
    private View target;
    private Rectangle targetBounds;

    public SetMessageRangeOperation(Edge message, Range range) {
        this(message, range, false);
    }

    public SetMessageRangeOperation(Edge message, Range range, boolean copyEdge) {
        super(Messages.SetMessageRangeOperation_operationName);
        this.message = message;
        this.range = range;
    }

    public void setSource(View src, Rectangle srcBounds) {
        this.source = src;
        this.sourceBounds = srcBounds.getCopy();
    }

    public void setTarget(View tgt, Rectangle tgtBounds) {
        this.target = tgt;
        this.targetBounds = tgtBounds.getCopy();
    }

    public Void execute() {
        if (this.message.getElement() != null && this.message.getElement().eContainer() != null) {
            Edge currentMessage = this.message;
            currentMessage.setSource(this.source);
            if (currentMessage.getElement() instanceof DEdge && this.source.getElement() instanceof EdgeTarget) {
                ((DEdge)currentMessage.getElement()).setSourceNode((EdgeTarget)this.source.getElement());
            }
            currentMessage.setTarget(this.target);
            if (currentMessage.getElement() instanceof DEdge && this.target.getElement() instanceof EdgeTarget) {
                ((DEdge)currentMessage.getElement()).setTargetNode((EdgeTarget)this.target.getElement());
            }
            int srcTop = this.sourceBounds.getTop().y;
            int tgtTop = this.targetBounds.getTop().y;
            SequenceMessageRangeHelper helper = new SequenceMessageRangeHelper();
            if (this.isMessageToSelf(currentMessage)) {
                helper.setMessageRangeForMessageToSelf(currentMessage, this.range, srcTop, tgtTop);
            } else {
                helper.setMessageRangeForNormalMessage(currentMessage, this.range, srcTop, tgtTop);
            }
        }
        return null;
    }

    private boolean isMessageToSelf(Edge msg) {
        View tgt;
        View src = msg.getSource();
        return Objects.equal((Object)src, (Object)(tgt = msg.getTarget())) || Objects.equal((Object)src.eContainer(), (Object)tgt) || Objects.equal((Object)src, (Object)tgt.eContainer());
    }
}

