/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;

public class ValidationFixResolution
implements IMarkerResolution {
    private ValidationFix fix;

    public ValidationFixResolution(ValidationFix fix) {
        this.fix = fix;
    }

    public String getLabel() {
        return this.fix.getName();
    }

    public void run(IMarker marker) {
        IResource airdFile = marker.getResource();
        if (airdFile instanceof IFile) {
            try {
                this.tryToOpenEditor(airdFile, marker);
            }
            catch (PartInitException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ValidationFixResolution_editorOpeningError, airdFile), (Throwable)e);
            }
        }
    }

    private void tryToOpenEditor(IResource airdFile, IMarker marker) throws PartInitException {
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)airdFile));
        if (editor instanceof IGotoMarker) {
            ((IGotoMarker)editor).gotoMarker(marker);
            EObject fixTarget = this.getFixTarget(editor, marker, airdFile);
            if (fixTarget != null) {
                this.executeFix(editor, fixTarget);
                this.revalidate(editor);
            }
        }
    }

    private void revalidate(IEditorPart editor) {
        if (editor instanceof DialectEditor) {
            ((DialectEditor)editor).validateRepresentation();
        }
    }

    private EObject getFixTarget(IEditorPart editor, IMarker marker, IResource airdFile) {
        String elementID = marker.getAttribute("elementId", null);
        URI airdEMFResourceURI = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
        airdEMFResourceURI = airdEMFResourceURI.appendFragment(elementID);
        ResourceSet set = ((EditingDomain)editor.getAdapter(EditingDomain.class)).getResourceSet();
        EObject markerTarget = set.getEObject(airdEMFResourceURI, false);
        if (markerTarget instanceof View && (markerTarget = ((View)markerTarget).getElement()) instanceof DSemanticDecorator && !this.isViewValidationRule()) {
            markerTarget = ((DSemanticDecorator)markerTarget).getTarget();
        }
        return markerTarget;
    }

    private DDiagram getDiagram(IEditorPart editor) {
        if (editor instanceof DialectEditor) {
            return (DDiagram)((DialectEditor)editor).getRepresentation();
        }
        return null;
    }

    private boolean isViewValidationRule() {
        return this.fix.eContainer() instanceof ViewValidationRule;
    }

    private void executeFix(IEditorPart editor, EObject fixTarget) {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)editor.getAdapter(TransactionalEditingDomain.class);
        IDiagramCommandFactory commandFactory = this.getDiagramCommandFactory(editor, domain);
        if (commandFactory != null && fixTarget != null) {
            Command fixCommand = commandFactory.buildQuickFixOperation(this.fix, fixTarget, this.getDiagram(editor));
            EObject semanticTarget = this.getSemanticTarget(fixTarget);
            Session session = SessionManager.INSTANCE.getSession(semanticTarget);
            if (session != null) {
                session.getRefreshEditorsListener().setForceRefresh(true);
            }
            domain.getCommandStack().execute(fixCommand);
        }
    }

    private EObject getSemanticTarget(EObject fixTarget) {
        EObject semanticTarget = fixTarget;
        if (semanticTarget instanceof DSemanticDecorator) {
            semanticTarget = ((DSemanticDecorator)semanticTarget).getTarget();
        }
        return semanticTarget;
    }

    private IDiagramCommandFactory getDiagramCommandFactory(IEditorPart editor, TransactionalEditingDomain domain) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider diagramCmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        return diagramCmdFactoryProvider.getCommandFactory(domain);
    }
}

