/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration.description;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.diagram.description.ConditionalContainerStyleDescription;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.osgi.framework.Version;

public class BorderSizeComputationExpressionMigrationParticipant
extends AbstractVSMMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("10.1.0.201507101000");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(Group group, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            for (Viewpoint viewpoint : group.getOwnedViewpoints()) {
                for (DiagramDescription diagramDescription : Iterables.filter((Iterable)viewpoint.getOwnedRepresentations(), DiagramDescription.class)) {
                    this.migrateStyleOfContainerMappingInLayer((List<? extends Layer>)diagramDescription.getAllLayers());
                    this.migrateStyleOfContainerMapping((List<ContainerMapping>)diagramDescription.getAllContainerMappings());
                }
                for (DiagramExtensionDescription diagramExtensionDescription : Iterables.filter((Iterable)viewpoint.getOwnedRepresentationExtensions(), DiagramExtensionDescription.class)) {
                    this.migrateStyleOfContainerMappingInLayer((List<? extends Layer>)diagramExtensionDescription.getLayers());
                }
            }
        }
    }

    private void migrateStyleOfContainerMappingInLayer(List<? extends Layer> layers) {
        for (Layer layer : layers) {
            this.migrateStyleOfContainerMapping((List<ContainerMapping>)layer.getContainerMappings());
        }
    }

    private void migrateStyleOfContainerMapping(List<ContainerMapping> containerMappings) {
        for (ContainerMapping containerMapping : containerMappings) {
            this.migrateStyleOfContainerMapping(containerMapping.getStyle());
            for (ConditionalContainerStyleDescription conditionalStyleDescription : containerMapping.getConditionnalStyles()) {
                this.migrateStyleOfContainerMapping(conditionalStyleDescription.getStyle());
            }
        }
    }

    private void migrateStyleOfContainerMapping(ContainerStyleDescription styleDescription) {
        if (styleDescription != null && "0".equals(styleDescription.getBorderSizeComputationExpression())) {
            styleDescription.setBorderSizeComputationExpression("1");
        }
    }
}

