/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.BackgroundStyle;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.LineStyle;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientRoundedRectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.OneLineMarginBorder;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerParallelogram;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerRectangleFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.RegionRoundedGradientRectangle;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.RoundedCornerMarginBorder;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;

public final class DiagramContainerEditPartOperation {
    private DiagramContainerEditPartOperation() {
    }

    public static void refreshForegroundColor(AbstractDiagramElementContainerEditPart self) {
        RGBValues rgb;
        DDiagramElementContainer container;
        ContainerStyle style;
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DDiagramElementContainer && (style = (container = (DDiagramElementContainer)eObj).getOwnedStyle()) != null && (rgb = style.getBorderColor()) != null) {
            self.getFigure().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
        }
    }

    public static void refreshBackgroundColor(AbstractDiagramElementContainerEditPart self) {
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DDiagramElementContainer) {
            DDiagramElementContainer container = (DDiagramElementContainer)eObj;
            RGBValues rgb = null;
            ContainerStyle style = container.getOwnedStyle();
            if (style instanceof FlatContainerStyle) {
                rgb = ((FlatContainerStyle)style).getBackgroundColor();
            } else if (style instanceof ShapeContainerStyle) {
                rgb = ((ShapeContainerStyle)style).getBackgroundColor();
            }
            if (rgb != null) {
                self.getFigure().setBackgroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
            }
        }
    }

    public static void refreshFont(AbstractDiagramElementContainerEditPart self) {
        Object firstChild;
        if (!self.getChildren().isEmpty() && (firstChild = self.getChildren().get(0)) instanceof IDiagramNameEditPart) {
            DiagramNameEditPartOperation.refreshFont((IDiagramNameEditPart)firstChild);
        }
    }

    public static void refreshVisuals(AbstractDiagramElementContainerEditPart self) {
        DDiagramElement diagElement = self.resolveDiagramElement();
        if (diagElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)diagElement;
            ContainerStyle style = ddec.getOwnedStyle();
            DiagramContainerEditPartOperation.refreshBackgroundFigure(self, style);
            ViewNodeContainerFigureDesc primaryShape = self.getPrimaryShape();
            DiagramContainerEditPartOperation.refreshBorder(self, primaryShape, style);
            if (primaryShape instanceof GradientRoundedRectangle) {
                DiagramContainerEditPartOperation.refreshGradient(style, (GradientRoundedRectangle)primaryShape);
            }
            DiagramContainerEditPartOperation.refreshCorners(self, diagElement, primaryShape);
            DiagramElementEditPartOperation.refreshLabelAlignment(self.getContentPane(), (LabelStyle)style);
        }
        if (diagElement != null) {
            self.setTooltipText(diagElement.getTooltipText());
        }
    }

    private static void refreshBackgroundFigure(AbstractDiagramElementContainerEditPart self, ContainerStyle style) {
        ViewNodeContainerFigureDesc primaryShape;
        if (self.getBackgroundFigure() instanceof IWorkspaceImageFigure && style != null) {
            ((IWorkspaceImageFigure)self.getBackgroundFigure()).refreshFigure(style);
        }
        if ((primaryShape = self.getPrimaryShape()) instanceof GradientRoundedRectangle && style instanceof FlatContainerStyle && ((GradientRoundedRectangle)primaryShape).getBackgroundStyle() != ((FlatContainerStyle)style).getBackgroundStyle()) {
            self.reInitFigure();
        }
        if (DiagramContainerEditPartOperation.isPrimaryShapeChanging(self, (Style)style)) {
            self.reInitFigure();
        }
    }

    private static void refreshGradient(ContainerStyle style, GradientRoundedRectangle gradientRoundedShape) {
        RGBValues rgb;
        if (style instanceof FlatContainerStyle && (rgb = ((FlatContainerStyle)style).getForegroundColor()) != null) {
            gradientRoundedShape.setGradientColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
        }
    }

    private static void refreshCorners(AbstractDiagramElementContainerEditPart self, DDiagramElement diagElement, ViewNodeContainerFigureDesc primaryShape) {
        DNodeContainer regionContainer;
        Dimension regionContainerCornerDimension;
        Dimension cornerDimension;
        Dimension specificDimension = cornerDimension = DiagramContainerEditPartOperation.getCornerDimension(self);
        BitSet specificCornerPosition = new BitSet(29);
        if (self.isRegion() && !(regionContainerCornerDimension = DiagramContainerEditPartOperation.getCornerDimension((EObject)(regionContainer = (DNodeContainer)diagElement.eContainer()))).getShrinked(cornerDimension).isEmpty()) {
            int parentStackDirection = self.getParentStackDirection();
            boolean firstRegionPart = DiagramContainerEditPartOperation.isFirstRegionPart(self);
            boolean lastRegionPart = DiagramContainerEditPartOperation.isLastRegionPart(self);
            if (parentStackDirection == 5 && lastRegionPart) {
                if (specificDimension != (cornerDimension = Dimension.max((Dimension)cornerDimension, (Dimension)regionContainerCornerDimension))) {
                    specificCornerPosition.set(9);
                    specificCornerPosition.set(17);
                }
                DiagramContainerEditPartOperation.updatePrecedingSiblingCorner(self, 12, 20);
            } else if (parentStackDirection == 24 && (firstRegionPart || lastRegionPart)) {
                cornerDimension = Dimension.max((Dimension)cornerDimension, (Dimension)regionContainerCornerDimension);
                specificCornerPosition.set(9);
                specificCornerPosition.set(17);
                if (firstRegionPart && !lastRegionPart) {
                    specificCornerPosition.set(20);
                } else if (!firstRegionPart && lastRegionPart) {
                    specificCornerPosition.set(12);
                }
                if (lastRegionPart && !firstRegionPart) {
                    DiagramContainerEditPartOperation.updatePrecedingSiblingCorner(self, 20);
                }
            }
        }
        if (primaryShape instanceof RoundedRectangle) {
            ((RoundedRectangle)primaryShape).setCornerDimensions(cornerDimension);
            if (primaryShape instanceof RegionRoundedGradientRectangle) {
                ((RegionRoundedGradientRectangle)primaryShape).setAdditionalCornerDimensions(specificDimension, specificCornerPosition);
            }
        }
    }

    private static void updatePrecedingSiblingCorner(AbstractDiagramElementContainerEditPart self, int ... cornerToCorrect) {
        AbstractDiagramElementContainerEditPart previous;
        ArrayList siblings = Lists.newArrayList((Iterable)Iterables.filter((Iterable)self.getParent().getChildren(), AbstractDiagramElementContainerEditPart.class));
        siblings.remove(self);
        AbstractDiagramElementContainerEditPart abstractDiagramElementContainerEditPart = previous = siblings.isEmpty() ? null : (AbstractDiagramElementContainerEditPart)Iterables.getLast((Iterable)siblings);
        if (previous != null && previous.getPrimaryShape() instanceof RegionRoundedGradientRectangle) {
            RegionRoundedGradientRectangle gradientRoundedRectangle = (RegionRoundedGradientRectangle)previous.getPrimaryShape();
            if (!gradientRoundedRectangle.getAdditionalCornerDimensions().equals((Object)gradientRoundedRectangle.getCornerDimensions())) {
                int[] nArray = cornerToCorrect;
                int n = cornerToCorrect.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    gradientRoundedRectangle.getAdditionalDimensionCorners().set(i);
                    ++n2;
                }
            }
            if (gradientRoundedRectangle.getAdditionalDimensionCorners().cardinality() == 4) {
                gradientRoundedRectangle.getAdditionalDimensionCorners().clear();
                gradientRoundedRectangle.setCornerDimensions(gradientRoundedRectangle.getAdditionalCornerDimensions());
            }
        }
    }

    private static ViewNodeContainerFigureDesc refreshBorder(AbstractDiagramElementContainerEditPart self, ViewNodeContainerFigureDesc primaryShape, ContainerStyle style) {
        int parentStackDirection = self.getParentStackDirection();
        LineStyle borderLineStyle = LineStyle.SOLID_LITERAL;
        int borderSize = 0;
        if (style != null) {
            borderLineStyle = style.getBorderLineStyle();
            if (style.getBorderSize() != null) {
                borderSize = style.getBorderSize();
            }
        }
        if (primaryShape instanceof Shape) {
            Shape shape = (Shape)primaryShape;
            shape.setLineWidth(borderSize);
            shape.setOutline(borderSize > 0 && parentStackDirection == 0);
            DiagramElementEditPartOperation.setLineStyle(shape, borderLineStyle, false);
        } else if (primaryShape instanceof NodeFigure) {
            NodeFigure nodeFigure = (NodeFigure)primaryShape;
            nodeFigure.setLineWidth(borderSize);
            DiagramElementEditPartOperation.setLineStyle(nodeFigure, borderLineStyle);
        }
        if (primaryShape != null) {
            DiagramContainerEditPartOperation.configureBorder(self, primaryShape, borderSize != 0);
            int labelOffset = 5;
            if (primaryShape.getLabelFigure() == null || !primaryShape.getLabelFigure().isVisible()) {
                labelOffset = 0;
            }
            if (primaryShape.getBorder() instanceof LineBorder) {
                LineBorder lineBorder = (LineBorder)primaryShape.getBorder();
                lineBorder.setWidth(borderSize);
                DiagramElementEditPartOperation.setLineStyle(lineBorder, borderLineStyle);
                if (lineBorder instanceof OneLineMarginBorder) {
                    OneLineMarginBorder oneLineBorder = (OneLineMarginBorder)lineBorder;
                    oneLineBorder.setMargin(labelOffset, 0, 0, 0);
                    if (parentStackDirection == 5) {
                        oneLineBorder.setPosition(8);
                    } else if (parentStackDirection == 24) {
                        oneLineBorder.setPosition(1);
                    }
                    if (self.isRegion() && lineBorder instanceof RoundedCornerMarginBorder) {
                        ((RoundedCornerMarginBorder)lineBorder).setCornerDimensions(DiagramContainerEditPartOperation.getCornerDimension(self));
                    }
                }
            } else if (primaryShape.getBorder() instanceof MarginBorder) {
                MarginBorder margin = null;
                int borderMagin = borderSize;
                switch (parentStackDirection) {
                    case 5: {
                        borderMagin = DiagramContainerEditPartOperation.isFirstRegionPart(self) ? 0 : Math.max(0, borderSize - 1);
                        margin = new MarginBorder(borderMagin + labelOffset, 0, 0, 0);
                        break;
                    }
                    case 24: {
                        borderMagin = DiagramContainerEditPartOperation.isFirstRegionPart(self) ? 0 : borderSize;
                        margin = new MarginBorder(labelOffset, borderMagin, 0, 0);
                        break;
                    }
                    default: {
                        margin = new MarginBorder(borderMagin + labelOffset - 1, borderMagin, borderMagin, borderMagin);
                    }
                }
                primaryShape.setBorder((Border)margin);
            }
        }
        return primaryShape;
    }

    private static boolean isFirstRegionPart(AbstractDiagramElementContainerEditPart self) {
        EditPart parent = self.getParent();
        if (parent instanceof AbstractDNodeContainerCompartmentEditPart) {
            Iterable regionParts = Iterables.filter((Iterable)parent.getChildren(), AbstractDiagramElementContainerEditPart.class);
            return !Iterables.isEmpty((Iterable)regionParts) && regionParts.iterator().next() == self;
        }
        return false;
    }

    private static boolean isLastRegionPart(AbstractDiagramElementContainerEditPart self) {
        EditPart parent = self.getParent();
        if (parent instanceof AbstractDNodeContainerCompartmentEditPart) {
            Iterable regionParts = Iterables.filter((Iterable)parent.getChildren(), AbstractDiagramElementContainerEditPart.class);
            return !Iterables.isEmpty((Iterable)regionParts) && Iterables.getLast((Iterable)regionParts) == self;
        }
        return false;
    }

    private static boolean isPrimaryShapeChanging(AbstractDiagramElementContainerEditPart self, Style style) {
        boolean result = false;
        boolean bl = result = self.getPrimaryShape() instanceof ViewNodeContainerParallelogram && (style instanceof FlatContainerStyle || style instanceof WorkspaceImage);
        if (!result) {
            boolean bl2 = result = self.getPrimaryShape() instanceof GradientRoundedRectangle && (style instanceof ShapeContainerStyle || style instanceof WorkspaceImage);
        }
        if (!result) {
            boolean bl3 = result = self.getPrimaryShape() instanceof ViewNodeContainerRectangleFigureDesc && (style instanceof FlatContainerStyle || style instanceof ShapeContainerStyle);
        }
        if (!result) {
            result = style instanceof WorkspaceImage && self.getBackgroundFigure() == null ^ StringUtil.isEmpty((String)((WorkspaceImage)style).getWorkspacePath());
        }
        return result;
    }

    public static IFigure createBackgroundFigure(IGraphicalEditPart self) {
        DDiagramElementContainer container;
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DDiagramElementContainer && (container = (DDiagramElementContainer)eObj).getOwnedStyle() instanceof WorkspaceImage) {
            WorkspaceImage img = (WorkspaceImage)container.getOwnedStyle();
            return DiagramContainerEditPartOperation.createWkpImageFigure(img);
        }
        return null;
    }

    private static IFigure createWkpImageFigure(WorkspaceImage img) {
        IWorkspaceImageFigure imageFigure = null;
        if (img != null && !StringUtil.isEmpty((String)img.getWorkspacePath())) {
            String workspacePath = img.getWorkspacePath();
            imageFigure = WorkspaceImageFigure.isSvgImage(workspacePath) ? SVGWorkspaceImageFigure.createImageFigure(img) : WorkspaceImageFigure.createImageFigure(workspacePath);
        }
        return imageFigure;
    }

    public static Dimension getCornerDimension(IGraphicalEditPart self) {
        EObject eObj = self.resolveSemanticElement();
        return DiagramContainerEditPartOperation.getCornerDimension(eObj);
    }

    private static Dimension getCornerDimension(EObject eObj) {
        ContainerStyleDescription description;
        Style style;
        Dimension corner = new Dimension(0, 0);
        if (eObj instanceof DStylizable && (style = ((DStylizable)eObj).getStyle()) != null && style.getDescription() instanceof ContainerStyleDescription && (description = (ContainerStyleDescription)style.getDescription()).isRoundedCorner()) {
            corner.height = description.getArcHeight();
            corner.width = description.getArcWidth();
        }
        return corner;
    }

    public static BackgroundStyle getBackgroundStyle(IGraphicalEditPart self) {
        Style style;
        BackgroundStyle bgStyle = BackgroundStyle.GRADIENT_LEFT_TO_RIGHT_LITERAL;
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DStylizable && (style = ((DStylizable)eObj).getStyle()) instanceof FlatContainerStyle) {
            bgStyle = ((FlatContainerStyle)style).getBackgroundStyle();
        }
        return bgStyle;
    }

    public static void configureBorder(AbstractDiagramElementContainerEditPart self, IFigure shapeFigure) {
        DDiagramElementContainer ddec;
        ContainerStyle style;
        boolean border = true;
        DDiagramElement diagElement = self.resolveDiagramElement();
        if (diagElement instanceof DDiagramElementContainer && (style = (ddec = (DDiagramElementContainer)diagElement).getOwnedStyle()) != null && style.getBorderSize() != null) {
            border = style.getBorderSize() != 0;
        }
        DiagramContainerEditPartOperation.configureBorder(self, shapeFigure, border);
    }

    private static void configureBorder(AbstractDiagramElementContainerEditPart self, IFigure shapeFigure, boolean border) {
        if (self.isRegion() && shapeFigure != null) {
            Object newBorder = null;
            if (DiagramContainerEditPartOperation.isFirstRegionPart(self) || !border) {
                if (!(shapeFigure.getBorder() instanceof MarginBorder)) {
                    newBorder = new MarginBorder(5, 0, 0, 0);
                }
            } else if (!(shapeFigure.getBorder() instanceof RoundedCornerMarginBorder)) {
                int position = 8;
                if (self.getParentStackDirection() == 24) {
                    position = 1;
                }
                RoundedCornerMarginBorder oneLineBorder = new RoundedCornerMarginBorder(position);
                oneLineBorder.setCornerDimensions(DiagramContainerEditPartOperation.getCornerDimension(self));
                oneLineBorder.setMargin(5, 0, 0, 0);
                newBorder = oneLineBorder;
            }
            if (newBorder != null) {
                shapeFigure.setBorder(newBorder);
            }
        }
    }
}

