/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManagerForSemanticElementsFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.AbstractCopyPasteLayoutAction;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.data.extension.LayoutDataManagerRegistry;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PasteLayoutAction
extends AbstractCopyPasteLayoutAction {
    public PasteLayoutAction(IWorkbenchPage workbenchPage, IWorkbenchPart actionWorkbenchPart) {
        super(workbenchPage, actionWorkbenchPart);
        this.setText(Messages.PasteLayoutAction_text);
        this.setAccelerator(458838);
        this.setId("pasteLayoutAction");
        this.setToolTipText(Messages.PasteLayoutAction_toolTipText);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteLayout.gif"));
        this.setDisabledImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteLayoutDisabled.gif"));
        this.setHoverImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteLayout.gif"));
    }

    public PasteLayoutAction(IWorkbenchPage workbenchPage) {
        this(workbenchPage, null);
    }

    protected String getCommandLabel() {
        return Messages.PasteLayoutAction_commandLabel;
    }

    protected Command getCommand() {
        UnexecutableCommand pasteLayoutCommand = UnexecutableCommand.INSTANCE;
        if (SiriusLayoutDataManagerForSemanticElementsFactory.getInstance().getSiriusLayoutDataManager().containsData()) {
            Option<DDiagram> diagram;
            CompoundCommand doStoreLayoutsCmd = new CompoundCommand(Messages.PasteLayoutAction_restoreLayoutCommandLabel);
            Iterator iter = this.getSelectedObjects().iterator();
            DiagramEditPart diagramEditPart = this.getDiagramEditPart();
            if (diagramEditPart instanceof IDDiagramEditPart && (diagram = ((IDDiagramEditPart)diagramEditPart).resolveDDiagram()).some() && PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)diagram.get()).canEditInstance((EObject)diagram.get())) {
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (!(next instanceof IGraphicalEditPart)) continue;
                    IGraphicalEditPart torestore = (IGraphicalEditPart)next;
                    doStoreLayoutsCmd.add((Command)new ICommandProxy((ICommand)new PasteLayoutDataCommand(torestore.getEditingDomain(), (DDiagram)diagram.get(), torestore)));
                }
            }
            pasteLayoutCommand = doStoreLayoutsCmd.unwrap();
        }
        return pasteLayoutCommand;
    }

    private final class PasteLayoutDataCommand
    extends AbstractTransactionalCommand {
        private IGraphicalEditPart editPartToRestore;
        private DDiagram dDiagram;

        public PasteLayoutDataCommand(TransactionalEditingDomain domain, DDiagram dDiagram, IGraphicalEditPart editPartToRestore) {
            super(domain, Messages.PasteLayoutDataCommand_label, null);
            this.dDiagram = dDiagram;
            this.editPartToRestore = editPartToRestore;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            List<SiriusLayoutDataManager> layoutDataManagers = LayoutDataManagerRegistry.getSiriusLayoutDataManagers(this.dDiagram);
            if (!layoutDataManagers.isEmpty()) {
                layoutDataManagers.get(0).applyLayout(this.editPartToRestore);
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

