/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractMenuContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.ChangeFilterActivation;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.Image;

public class FiltersContributionItem
extends AbstractMenuContributionItem {
    private static final ImageDescriptor DESC_FILTER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/filters.gif");

    @Override
    protected Image getMenuImage() {
        return this.getImage();
    }

    private Image getImage() {
        EObject diagram;
        Diagram gmfDiagram = this.part.getDiagram();
        if (gmfDiagram != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram) {
            super.setDiagram((DDiagram)diagram);
            if (!((DDiagram)diagram).getActivatedFilters().isEmpty()) {
                return DiagramUIPlugin.Implementation.getDecoratedCheckedImage(DESC_FILTER);
            }
        }
        return DiagramUIPlugin.getPlugin().getImage(DESC_FILTER);
    }

    @Override
    protected String getLabel() {
        return Messages.FiltersContributionItem_label;
    }

    @Override
    protected void menuShow(IMenuManager manager) {
        for (FilterDescription filter : this.getFilters()) {
            this.addFilterMenuItem(manager, filter);
        }
    }

    private Collection<FilterDescription> getFilters() {
        DiagramDescription diagramDesc = this.diagram.getDescription();
        return diagramDesc.getFilters();
    }

    private void addFilterMenuItem(IMenuManager manager, final FilterDescription filter) {
        final boolean isActive = this.isActive(filter);
        Action action = new Action(new IdentifiedElementQuery((IdentifiedElement)filter).getLabel(), 2){

            public void run() {
                ChangeFilterActivation change = new ChangeFilterActivation(FiltersContributionItem.this.part, FiltersContributionItem.this.diagram, filter, !isActive);
                change.run();
            }
        };
        action.setChecked(isActive);
        manager.add((IAction)action);
    }

    private boolean isActive(FilterDescription filter) {
        EList activatedFilters = this.diagram.getActivatedFilters();
        return activatedFilters.contains(filter);
    }
}

