/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gef.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gef.EditPart;

public class EditPartQuery {
    private final EditPart part;

    public EditPartQuery(EditPart part) {
        this.part = (EditPart)Preconditions.checkNotNull((Object)part);
    }

    public Set<EditPart> getAllChildren(boolean includeSelf) {
        return this.getAllChildren(includeSelf, null);
    }

    public Set<EditPart> getAllChildren(boolean includeSelf, List<Class<?>> includedKind) {
        HashSet result = Sets.newHashSet();
        if (includeSelf && (includedKind == null || this.isAssignable(this.part.getClass(), includedKind))) {
            result.add(this.part);
        }
        result.addAll(this.getAllChildren(this.part, includedKind));
        return result;
    }

    private Set<EditPart> getAllChildren(EditPart editPart, List<Class<?>> includedKind) {
        HashSet result = Sets.newHashSet();
        for (EditPart child : Iterables.filter((Iterable)editPart.getChildren(), EditPart.class)) {
            if (includedKind == null || this.isAssignable(child.getClass(), includedKind)) {
                result.add(child);
            }
            result.addAll(this.getAllChildren(child, includedKind));
        }
        return result;
    }

    private boolean isAssignable(Class<?> aClass, List<Class<?>> assignementTypes) {
        for (Class<?> class1 : assignementTypes) {
            if (!class1.isAssignableFrom(aClass)) continue;
            return true;
        }
        return false;
    }
}

