/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactoryProvider;
import org.eclipse.sirius.tree.business.api.command.TreeCommandFactoryService;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.commands.EMFCommandFactoryUI;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeActionBarContributor;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.tree.ui.tools.internal.editor.RefreshAtOpeningActivator;
import org.eclipse.sirius.ui.business.api.descriptor.ComposedImageDescriptor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.marker.TraceabilityMarkerNavigationProvider;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class DTreeEditor
extends AbstractDTreeEditor
implements org.eclipse.sirius.tree.ui.tools.api.editor.DTreeEditor {
    public static final String ID = "org.eclipse.sirius.tree.ui.EditorID";
    private static final String CONTEXT_ID = "org.eclipse.sirius.tree.ui.EditorID.treeContext";
    private static final ImageDescriptor INITIAL_TITLE_IMAGE_DESCRIPTOR = TreeUIPlugin.getBundledImageDescriptor("icons/full/obj16/TreeDescription.gif");
    private DTree treeModel;
    private IPartListener refreshAtOpeningActivator;

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.isDeleted(this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            }
        } else {
            this.performSave(false, progressMonitor);
        }
    }

    private void performSaveAs(IProgressMonitor progressMonitor) {
        IFile original;
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
        } else {
            IEditorReference[] editorRefs;
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
            IEditorReference[] iEditorReferenceArray = editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                if (matchingStrategy.matches(editorRef, (IEditorInput)newInput)) {
                    return;
                }
                ++n2;
            }
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
        }
    }

    public void doSaveAs() {
        if (this.isSaveAsAllowed()) {
            this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (this.getTreeModel() != null) {
            if (DialectUIManager.INSTANCE.isRefreshActivatedOnRepresentationOpening()) {
                this.launchRefresh(true);
            }
            this.initPermissionAuthority((DSemanticDecorator)this.getTreeModel());
        }
    }

    protected void configureCommandFactoryProviders() {
        this.emfCommandFactory = TreeCommandFactoryService.getInstance().getNewProvider().getCommandFactory(this.getEditingDomain());
        this.emfCommandFactory.setUserInterfaceCallBack((UICallBack)new EMFCommandFactoryUI());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getTreeModel() == null) {
            Label errorLabel = new Label(parent, 0x1000000);
            errorLabel.setText(Messages.DTreeEditor_treeModelUnsaved);
            return;
        }
        this.treeViewerManager = new DTreeViewerManager(parent, this.getTreeModel(), this.getEditingDomain(), this.accessor, this.emfCommandFactory, this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewerManager.getTreeViewer());
        if (this.session != null) {
            InterpreterRegistry.prepareImportsFromSession((IInterpreter)this.session.getInterpreter(), (Session)this.session);
        }
        ((DTreeActionBarContributor)this.getEditorSite().getActionBarContributor()).addCreateTreeItemMenu(((DTreeViewerManager)this.getTableViewer()).getCreateTreeItemMenu());
        this.refreshAtOpeningActivator = new RefreshAtOpeningActivator(this);
        this.getSite().getPage().addPartListener(this.refreshAtOpeningActivator);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(CONTEXT_ID);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        Viewer viewer = this.getViewer();
        if (viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            treeViewer.setExpandedElements(TreeHelper.getExpandedItems((DTree)this.getTreeModel()).toArray());
        }
    }

    public Image getFrozenRepresentationImage() {
        if (this.frozenRepresentationImage == null || this.frozenRepresentationImage.isDisposed()) {
            Image refreshImage = TreeUIPlugin.getImage(TreeUIPlugin.getBundledImageDescriptor("icons/tree/refresh.gif"));
            ArrayList<Image> images = new ArrayList<Image>(2);
            images.add(refreshImage);
            Image lockByOtherOverlayImage = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_denied_overlay.gif"));
            images.add(lockByOtherOverlayImage);
            ComposedImageDescriptor composedImageDescriptor = new ComposedImageDescriptor(new ComposedImage(images));
            this.frozenRepresentationImage = SiriusEditPlugin.getPlugin().getImage((ImageDescriptor)composedImageDescriptor);
        }
        return this.frozenRepresentationImage;
    }

    @Override
    public Control getControl() {
        AbstractDTreeViewer treeViewer = this.getTableViewer().getTreeViewer();
        return treeViewer.getTree();
    }

    private void launchRefresh(boolean loading) {
        this.getEditingDomain().getCommandStack().execute((Command)new RefreshRepresentationsCommand(this.getEditingDomain(), (IProgressMonitor)new NullProgressMonitor(), new DRepresentation[]{this.getTreeModel()}));
        if (!loading) {
            this.getViewer().refresh();
        }
    }

    protected void launchRefresh() {
        this.launchRefresh(false);
    }

    public String getContributorId() {
        return ID;
    }

    protected void setRepresentation(URI uri, boolean loadOnDemand) {
        this.setTreeModel(this.getDTree(uri, loadOnDemand));
    }

    private DTree getDTree(URI uri, boolean loadOnDemand) {
        EObject rootElement;
        DTree result = null;
        Resource resource = this.getEditingDomain().getResourceSet().getResource(uri.trimFragment(), loadOnDemand);
        if (resource != null && resource.isLoaded() && uri.fragment() != null && (rootElement = resource.getEObject(uri.fragment())) instanceof DTree) {
            result = (DTree)rootElement;
        }
        return result;
    }

    public DRepresentation getRepresentation() {
        return this.treeModel;
    }

    public DTree getTreeModel() {
        return this.treeModel;
    }

    private void setTreeModel(DTree rootElement) {
        this.treeModel = rootElement;
    }

    public void validateRepresentation() {
    }

    protected void setAccessor(ModelAccessor accessor) {
        super.setAccessor(accessor);
        ((ITreeCommandFactory)this.emfCommandFactory).setModelAccessor(this.accessor);
    }

    public void gotoMarker(IMarker marker) {
        if (TraceabilityMarkerNavigationProvider.isTraceabilityMarker((IMarker)marker)) {
            new TraceabilityMarkerNavigationProvider((DialectEditor)this).gotoMarker(marker);
        } else {
            this.doGoToMarker(marker);
        }
    }

    protected void doGoToMarker(IMarker marker) {
        String treeURI = marker.getAttribute("REPRESENTATION_URI", null);
        String elementId = marker.getAttribute("REPRESENTATION_ELEMENT_ID", null);
        if (treeURI == null || elementId == null) {
            return;
        }
        URI markerTreeURI = URI.createURI((String)treeURI);
        DTree markerTree = (DTree)this.getTreeModel().eResource().getEObject(markerTreeURI.fragment());
        if (markerTree != null) {
            EObject searchedElement = markerTree.eResource().getEObject(elementId);
            AbstractDTreeViewer viewer = this.treeViewerManager.getTreeViewer();
            Object[] expandedElements = viewer.getExpandedElements();
            ((TreeViewer)this.getViewer()).expandAll();
            TreeItem contains = this.contains(viewer.getTree().getItems(), searchedElement);
            ((TreeViewer)this.getViewer()).setExpandedElements(expandedElements);
            if (contains != null) {
                TreeSelection selection = new TreeSelection(this.getTreePathFromItem(contains));
                ((TreeViewer)this.getViewer()).setSelection((ISelection)selection, true);
            }
        }
    }

    protected TreePath getTreePathFromItem(TreeItem item) {
        LinkedList<Object> segments = new LinkedList<Object>();
        TreeItem myItem = item;
        while (myItem != null) {
            Object segment = item.getData();
            Assert.isNotNull((Object)segment);
            segments.addFirst(segment);
            myItem = myItem.getParentItem();
        }
        return new TreePath(segments.toArray());
    }

    public Object getAdapter(Class type) {
        Object result = super.getAdapter(type);
        if (result == null && type == ITreeCommandFactoryProvider.class) {
            result = this.emfCommandFactory;
        }
        return result;
    }

    @Override
    public AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = TreeUIPlugin.getPlugin().createAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void dispose() {
        if (this.refreshAtOpeningActivator != null) {
            this.getSite().getPage().removePartListener(this.refreshAtOpeningActivator);
        }
        this.refreshAtOpeningActivator = null;
        super.dispose();
        if (this.getAdapterFactory() instanceof IDisposable) {
            ((IDisposable)this.getAdapterFactory()).dispose();
        }
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DTreeEditor.this.treeViewerManager != null) {
                    DTreeEditor.this.getSite().getPage().closeEditor((IEditorPart)DTreeEditor.this, save);
                }
            }
        });
    }

    public Image getInitialImage() {
        if (this.initialTitleImage == null || this.initialTitleImage.isDisposed()) {
            this.initialTitleImage = SiriusEditPlugin.getPlugin().getImage(INITIAL_TITLE_IMAGE_DESCRIPTOR);
        }
        return this.initialTitleImage;
    }
}

