/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.OpenRepresentationsFileJob;
import org.eclipse.ui.actions.SelectionListenerAction;

public class OpenSessionAction
extends SelectionListenerAction {
    private Collection<IFile> selectedFiles;

    public OpenSessionAction(String text) {
        super(text);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection != null) {
            this.selectedFiles = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)selection.toList(), IFile.class));
        }
        return super.updateSelection(selection) && this.selectedFiles != null && !this.selectedFiles.isEmpty();
    }

    public void run() {
        try {
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.OPEN_SESSION_ACTION_KEY);
            for (IFile selectedFile : this.selectedFiles) {
                if (!"aird".equals(selectedFile.getFileExtension())) continue;
                OpenRepresentationsFileJob.scheduleNewWhenPossible(URI.createPlatformResourceURI((String)selectedFile.getFullPath().toOSString(), (boolean)true), true);
            }
        }
        finally {
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.OPEN_SESSION_ACTION_KEY);
        }
    }
}

