/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;

public final class EqualityHelper {
    private EqualityHelper() {
    }

    public static boolean contains(Collection<? extends EObject> collection, EObject eObj) {
        for (EObject eObject : collection) {
            if (!EqualityHelper.areEquals(eObject, eObj)) continue;
            return true;
        }
        return false;
    }

    public static void remove(Collection<? extends EObject> collection, EObject eObj) {
        Iterator<? extends EObject> iterator = collection.iterator();
        while (iterator.hasNext()) {
            EObject next = iterator.next();
            if (!EqualityHelper.areEquals(next, eObj)) continue;
            iterator.remove();
        }
    }

    public static boolean areEquals(EObject eObj1, EObject eObj2) {
        if (Objects.equal((Object)eObj1, (Object)eObj2)) {
            return true;
        }
        return EqualityHelper.haveSameURIFragment(eObj1, eObj2);
    }

    private static boolean haveSameURIFragment(EObject eObj1, EObject eObj2) {
        boolean result = false;
        if (EqualityHelper.sameType(eObj1, eObj2)) {
            EObject container1 = eObj1.eContainer();
            EObject container2 = eObj2.eContainer();
            if (container1 instanceof InternalEObject && container2 instanceof InternalEObject) {
                String eObj1Frag = ((InternalEObject)container1).eURIFragmentSegment(eObj1.eContainingFeature(), eObj1);
                String eObj2Frag = ((InternalEObject)container2).eURIFragmentSegment(eObj2.eContainingFeature(), eObj2);
                if (eObj1Frag != null && eObj2Frag != null && eObj1Frag.equals(eObj2Frag)) {
                    result = EqualityHelper.haveSameURIFragment(container1, container2);
                }
            } else if (container1 == null && container2 == null) {
                Resource res1 = eObj1.eResource();
                Resource res2 = eObj2.eResource();
                if (res1 != null && res2 != null) {
                    URI uriRes1 = res1.getURI();
                    URI uriRes2 = res2.getURI();
                    if (uriRes1.isPlatformPlugin() && uriRes2.isPlatformPlugin() || uriRes1.isPlatformResource() && uriRes2.isPlatformResource()) {
                        result = uriRes1.equals((Object)uriRes2);
                    }
                }
            }
        }
        return result;
    }

    private static boolean sameType(EObject eObj1, EObject eObj2) {
        return eObj1 != null && eObj2 != null && eObj1.getClass() == eObj2.getClass();
    }
}

