/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.CreateDEdgeTask;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.ui.resource.ISiriusMessages;
import org.eclipse.sirius.tools.internal.command.builders.ElementsToSelectTask;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.tool.AcceleoVariable;
import org.eclipse.sirius.viewpoint.description.tool.VariableContainer;

public class EdgeCreationCommandBuilder
extends AbstractDiagramCommandBuilder {
    protected final EdgeCreationDescription tool;
    protected final EdgeTarget source;
    protected final EdgeTarget target;

    public EdgeCreationCommandBuilder(EdgeCreationDescription tool, EdgeTarget source, EdgeTarget target) {
        this.tool = tool;
        this.source = source;
        this.target = target;
    }

    public Command buildCommand() {
        if (this.canCreateEdge()) {
            EObject sourceTarget = ((DSemanticDecorator)this.source).getTarget();
            EObject targetTarget = ((DSemanticDecorator)this.target).getTarget();
            DCommand result = this.buildCreateEdgeCommandFromTool(sourceTarget, targetTarget);
            result.getTasks().add(this.buildCreateEdgeTask(result));
            this.addRefreshTask((DDiagramElement)((Object)this.source), result, (AbstractToolDescription)this.tool);
            Option<DDiagram> parentDiagram = new EObjectQuery(this.source).getParentDiagram();
            result.getTasks().add(new ElementsToSelectTask((AbstractToolDescription)this.tool, InterpreterUtil.getInterpreter((EObject)sourceTarget), sourceTarget, (DRepresentation)parentDiagram.get()));
            return result;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private boolean canCreateEdge() {
        boolean valid = this.permissionAuthority.canEditInstance((EObject)this.source);
        valid = valid && this.permissionAuthority.canEditInstance((EObject)this.target);
        valid = valid && this.source instanceof DSemanticDecorator;
        valid = valid && this.target instanceof DSemanticDecorator;
        valid = valid && this.checkPrecondition();
        return valid;
    }

    protected boolean checkPrecondition() {
        boolean valid = true;
        if (this.tool.getPrecondition() != null && !StringUtil.isEmpty((String)this.tool.getPrecondition().trim())) {
            EObject sourceTarget = ((DSemanticDecorator)this.source).getTarget();
            EObject targetTarget = ((DSemanticDecorator)this.target).getTarget();
            Option<DDiagram> diagram = this.getDDiagram();
            EObject container = null;
            if (diagram.some() && diagram.get() instanceof DSemanticDecorator) {
                container = ((DSemanticDecorator)diagram.get()).getTarget();
            } else {
                SiriusPlugin.getDefault().warning(ISiriusMessages.IS_NOT_A_DECORATE_SEMANTIC_ELEMENT, null);
            }
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)sourceTarget);
            interpreter.setVariable("preSource", (Object)sourceTarget);
            interpreter.setVariable("preTarget", (Object)targetTarget);
            interpreter.setVariable("preSourceView", (Object)this.source);
            interpreter.setVariable("preTargetView", (Object)this.target);
            interpreter.setVariable("container", (Object)container);
            interpreter.setVariable("diagram", diagram.get());
            valid = this.evaluatePrecondition(interpreter, sourceTarget, this.tool.getPrecondition());
            interpreter.unSetVariable("preSource");
            interpreter.unSetVariable("preTarget");
            interpreter.unSetVariable("preSourceView");
            interpreter.unSetVariable("preTargetView");
            interpreter.unSetVariable("container");
            interpreter.unSetVariable("diagram");
        }
        return valid;
    }

    public boolean checkStartPrecondition() {
        boolean valid = true;
        if (this.tool.getConnectionStartPrecondition() != null && !StringUtil.isEmpty((String)this.tool.getConnectionStartPrecondition().trim())) {
            EObject sourceTarget = ((DSemanticDecorator)this.source).getTarget();
            Option<DDiagram> diagram = new EObjectQuery(this.source).getParentDiagram();
            EObject container = null;
            if (diagram.some() && diagram.get() instanceof DSemanticDecorator) {
                container = ((DSemanticDecorator)diagram.get()).getTarget();
            } else {
                SiriusPlugin.getDefault().warning(ISiriusMessages.IS_NOT_A_DECORATE_SEMANTIC_ELEMENT, null);
            }
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)sourceTarget);
            interpreter.setVariable("preSource", (Object)sourceTarget);
            interpreter.setVariable("preSourceView", (Object)this.source);
            interpreter.setVariable("container", (Object)container);
            interpreter.setVariable("diagram", diagram.get());
            valid = this.evaluatePrecondition(interpreter, sourceTarget, this.tool.getConnectionStartPrecondition());
            interpreter.unSetVariable("preSource");
            interpreter.unSetVariable("preSourceView");
            interpreter.unSetVariable("container");
            interpreter.unSetVariable("diagram");
        }
        return valid;
    }

    protected DCommand buildCreateEdgeCommandFromTool(EObject semanticSource, EObject semanticTarget) {
        DCommand result = this.createEnclosingCommand();
        HashMap<AbstractVariable, Object> variables = new HashMap<AbstractVariable, Object>();
        variables.put(this.tool.getSourceVariable(), semanticSource);
        variables.put(this.tool.getSourceViewVariable(), this.source);
        variables.put(this.tool.getTargetVariable(), semanticTarget);
        variables.put(this.tool.getTargetViewVariable(), this.target);
        this.initSubvariables(this.tool.getSourceVariable(), variables, semanticSource);
        this.initSubvariables(this.tool.getTargetVariable(), variables, semanticTarget);
        Option<DDiagram> parentDiagram = new EObjectQuery(this.source).getParentDiagram();
        result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)this.source), this.uiCallback));
        result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), semanticSource, this.tool.getInitialOperation().getFirstModelOperations()));
        return result;
    }

    protected void initSubvariables(VariableContainer var, Map<AbstractVariable, Object> variables, EObject modelElement) {
        for (AbstractVariable curVar : var.getSubVariables()) {
            if (!variables.containsKey(curVar)) {
                variables.put(curVar, modelElement);
                boolean cfr_ignored_0 = curVar instanceof AcceleoVariable;
            }
            if (!(curVar instanceof VariableContainer)) continue;
            this.initSubvariables((VariableContainer)curVar, variables, modelElement);
        }
    }

    private ICommandTask buildCreateEdgeTask(DCommand createdObjects) {
        CreateDEdgeTask result = new CreateDEdgeTask(this.tool, createdObjects, this.modelAccessor, this.source, this.target);
        return result;
    }

    protected String getEnclosingCommandLabel() {
        return new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel();
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        Option<DDiagram> diagram = new EObjectQuery(this.source).getParentDiagram();
        if (!diagram.some()) {
            diagram = new EObjectQuery(this.target).getParentDiagram();
        }
        return diagram;
    }
}

