/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.interpreter.CompilationResult;
import org.eclipse.acceleo.common.interpreter.EvaluationResult;
import org.eclipse.acceleo.common.utils.AcceleoCollections;
import org.eclipse.acceleo.engine.service.EvaluationContext;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.EMtlBinaryResourceFactoryImpl;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.acceleo.parser.interpreter.CompilationContext;
import org.eclipse.acceleo.parser.interpreter.ModuleDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.util.Bag;
import org.eclipse.sirius.common.acceleo.mtl.AcceleoMTLInterpreterPlugin;
import org.eclipse.sirius.common.acceleo.mtl.Messages;
import org.eclipse.sirius.common.acceleo.mtl.business.api.ResourceFinder;
import org.eclipse.sirius.common.acceleo.mtl.business.api.extension.AbstractImportHandler;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.extension.ImportHandlerRegistry;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter.CrossReferencerProviderAdapterFactory;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter.DynamicAcceleoModule;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.IVariableStatusListener;
import org.eclipse.sirius.common.tools.api.interpreter.InterpreterStatusFactory;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.TypedValidation;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.osgi.framework.Bundle;

public class AcceleoMTLInterpreter
implements IInterpreter,
TypedValidation {
    private static final String ACCELEO_EXPRESSION_PREFIX = "[";
    private static final String ACCELEO_EXPRESSION_SUFFIX = "/]";
    private static final String FILE_SEPARATOR_REGEX = "/|\\\\";
    protected final Set<ModuleDescriptor> extendedDependencies = Sets.newLinkedHashSet();
    protected final Multimap<String, URI> mtlDependencies = LinkedHashMultimap.create();
    private final Map<String, URI> javaFiles = Maps.newHashMap();
    private final DynamicAcceleoModule module = new DynamicAcceleoModule();
    private final ListMultimap<String, Object> variables = AcceleoCollections.newCircularArrayDequeMultimap();
    private final Map<String, String> compilationVariables = Maps.newLinkedHashMap();
    private final Set<String> variableNsURIs = Sets.newLinkedHashSet();
    private final Set<IVariableStatusListener> variableStatusListeners = Sets.newHashSet();
    private final Set<String> viewpointPlugins = Sets.newLinkedHashSet();
    private final Set<String> viewpointProjects = Sets.newLinkedHashSet();
    private CrossReferencerProviderAdapterFactory adapterFactory;

    private static <T> T coerceValue(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        Object result = null;
        if (clazz.isInstance(object)) {
            result = object;
        } else if (object instanceof IAdaptable) {
            result = ((IAdaptable)object).getAdapter(clazz);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(object, clazz);
        }
        return (T)result;
    }

    private static boolean existsInPlugins(String path) {
        try {
            URL url = new URL(path);
            return FileLocator.find((URL)url) != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private static boolean existsInWorkspace(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        return ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(path));
    }

    private static String extractNsURI(EObject object) {
        String uri;
        EPackage pack = object.eClass().getEPackage();
        if (pack != null && (uri = pack.getNsURI()) != null && uri.length() > 0) {
            return uri;
        }
        return null;
    }

    private static Set<String> extractNsURIs(Object object) {
        Set<Object> uris = Sets.newLinkedHashSet();
        if (object instanceof EObject) {
            String uri = AcceleoMTLInterpreter.extractNsURI((EObject)object);
            if (uri != null) {
                uris = Collections.singleton(uri);
            }
        } else if (object instanceof Collection) {
            for (Object child : (Collection)object) {
                Set<String> childURIs = AcceleoMTLInterpreter.extractNsURIs(child);
                if (childURIs.isEmpty()) continue;
                uris = Sets.union((Set)uris, childURIs);
            }
        }
        return uris;
    }

    private static <V> V getLast(List<V> values) {
        ListIterator<V> iterator = values.listIterator(values.size());
        return iterator.previous();
    }

    private static String getQualifiedType(EObject eObject) {
        return AcceleoMTLInterpreter.getQualifiedName((EClassifier)eObject.eClass());
    }

    private static String getQualifiedName(EClassifier classifier) {
        ArrayList ancestors = Lists.newArrayList();
        EClassifier current = classifier;
        boolean rootEncountered = false;
        while (current instanceof ENamedElement && !rootEncountered) {
            ancestors.add(((ENamedElement)current).getName());
            if (current instanceof EPackage && ((EPackage)current).getNsURI() != null) {
                rootEncountered = true;
            }
            current = current.eContainer();
        }
        List reversed = Lists.reverse((List)ancestors);
        return Joiner.on((String)"::").join((Iterable)reversed);
    }

    private static String inferOCLType(Object obj) {
        String oclType = "OCLAny";
        EcoreEnvironment env = (EcoreEnvironment)new EcoreEnvironmentFactory().createEnvironment();
        if (obj instanceof Collection) {
            EClassifier elementType = DynamicAcceleoModule.inferCollectionContentOCLType(env, (Collection)obj);
            oclType = "Sequence(";
            if (obj instanceof LinkedHashSet) {
                oclType = "OrderedSet(";
            } else if (obj instanceof Set) {
                oclType = "Set(";
            } else if (obj instanceof Bag) {
                oclType = "Bag(";
            }
            oclType = String.valueOf(oclType) + AcceleoMTLInterpreter.getQualifiedName(elementType) + ')';
        } else {
            oclType = AcceleoMTLInterpreter.getQualifiedName(DynamicAcceleoModule.getOCLType(env, obj));
        }
        return oclType;
    }

    private static boolean pathEndsWith(String candidatePath, String suffix) {
        int candidateIndex;
        String[] candidateSegments = candidatePath.split(FILE_SEPARATOR_REGEX);
        String[] suffixSegments = suffix.split(FILE_SEPARATOR_REGEX);
        int suffixIndex = suffixSegments.length - 1;
        boolean match = suffixIndex <= (candidateIndex = candidateSegments.length - 1);
        while (candidateIndex >= 0 && suffixIndex >= 0 && match) {
            match = suffixSegments[suffixIndex].equals(candidateSegments[candidateIndex]);
            --candidateIndex;
            --suffixIndex;
        }
        return match;
    }

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
        LinkedHashSet additionalEPackages = Sets.newLinkedHashSet();
        for (MetamodelDescriptor descriptor : metamodels) {
            EPackage pkg;
            if (!(descriptor instanceof EcoreMetamodelDescriptor) || (pkg = ((EcoreMetamodelDescriptor)descriptor).resolve()) == null) continue;
            additionalEPackages.add(pkg);
        }
        this.module.registerAdditionalEPackages(additionalEPackages);
    }

    public void addImport(String dependency) {
        if (dependency != null && dependency.length() > 0) {
            boolean added = this.addExtendedImport(dependency);
            if (!added) {
                added = this.addMTLImport(dependency);
            }
            if (added) {
                this.invalidateModule();
            }
        }
    }

    public void addVariableStatusListener(IVariableStatusListener newListener) {
        this.variableStatusListeners.add(newListener);
    }

    public void clearImports() {
        this.mtlDependencies.clear();
        this.extendedDependencies.clear();
        this.javaFiles.clear();
        this.invalidateModule();
    }

    public void clearVariables() {
        this.variables.clear();
        this.variableNsURIs.clear();
        this.compilationVariables.clear();
        this.notifyVariableListeners();
    }

    public CompilationContext createCompilationContext(EObject context, String expression) {
        String targetType = AcceleoMTLInterpreter.getQualifiedType(context);
        String targetNsURI = null;
        EObject root = EcoreUtil.getRootContainer((EObject)context);
        if (root != null) {
            targetNsURI = AcceleoMTLInterpreter.extractNsURI(root);
        }
        if (this.compilationVariables.isEmpty() && !this.variables.isEmpty()) {
            for (Map.Entry entry : this.variables.asMap().entrySet()) {
                List values;
                char[] chars = ((String)entry.getKey()).toCharArray();
                boolean isDigit = chars.length > 0;
                int i = 0;
                while (i < chars.length && isDigit) {
                    isDigit = Character.isDigit(chars[i]);
                    ++i;
                }
                if (isDigit || (values = (List)entry.getValue()).isEmpty()) continue;
                Object actualValue = AcceleoMTLInterpreter.getLast(values);
                this.compilationVariables.put((String)entry.getKey(), AcceleoMTLInterpreter.inferOCLType(actualValue));
                this.variableNsURIs.addAll(AcceleoMTLInterpreter.extractNsURIs(actualValue));
            }
        }
        Sets.SetView nsURIs = targetNsURI != null ? Sets.union(Collections.singleton(targetNsURI), this.variableNsURIs) : this.variableNsURIs;
        return new CompilationContext(expression, targetType, this.compilationVariables, (Set)nsURIs, this.mtlDependencies, Collections.unmodifiableSet(this.extendedDependencies));
    }

    public CompilationContext createCompilationContext(IInterpreterContext context, String expression, String targetType, Map<String, String> variableTypes) {
        this.addContextImports(context);
        LinkedHashSet nsURIs = Sets.newLinkedHashSet();
        for (EPackage pack : context.getAvailableEPackages()) {
            nsURIs.add(pack.getNsURI());
        }
        return new CompilationContext(expression, targetType, variableTypes, (Set)nsURIs, this.mtlDependencies, (Set)Sets.newLinkedHashSet(this.extendedDependencies));
    }

    public void dispose() {
        this.mtlDependencies.clear();
        this.extendedDependencies.clear();
        this.javaFiles.clear();
        this.module.invalidate();
        this.variables.clear();
        this.variableNsURIs.clear();
        this.compilationVariables.clear();
        this.variableStatusListeners.clear();
        this.viewpointPlugins.clear();
        this.viewpointProjects.clear();
        if (this.adapterFactory != null) {
            Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.adapterFactory);
            this.adapterFactory = null;
        }
    }

    public Object evaluate(EObject target, String expression) throws EvaluationException {
        EvaluationResult evaluationResult = this.internalEvaluate(target, expression);
        return evaluationResult.getEvaluationResult();
    }

    public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        EvaluationResult evaluationResult = this.internalEvaluate(context, expression);
        Object result = evaluationResult.getEvaluationResult();
        Boolean coerced = result instanceof Boolean ? (Boolean)result : AcceleoMTLInterpreter.coerceValue(result, Boolean.class);
        if (coerced != null) {
            return coerced;
        }
        return false;
    }

    public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
        EvaluationResult evaluationResult = this.internalEvaluate(context, expression);
        Object result = evaluationResult.getEvaluationResult();
        ArrayList coercedResult = Lists.newArrayList();
        if (result instanceof Collection) {
            Iterables.addAll((Collection)coercedResult, (Iterable)Iterables.filter((Iterable)((Collection)result), EObject.class));
        } else if (result != null && result.getClass().isArray()) {
            Iterables.addAll((Collection)coercedResult, (Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])((Object[])result)), EObject.class));
        } else {
            EObject coerced = AcceleoMTLInterpreter.coerceValue(result, EObject.class);
            if (coerced != null) {
                coercedResult.add(coerced);
            }
        }
        return coercedResult;
    }

    public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
        EvaluationResult evaluationResult = this.internalEvaluate(context, expression);
        Object result = evaluationResult.getEvaluationResult();
        EObject coerced = AcceleoMTLInterpreter.coerceValue(result, EObject.class);
        return coerced;
    }

    public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
        EvaluationResult evaluationResult = this.internalEvaluate(context, expression);
        Object result = evaluationResult.getEvaluationResult();
        Integer coerced = AcceleoMTLInterpreter.coerceValue(result, Integer.class);
        return coerced;
    }

    public String evaluateString(EObject context, String expression) throws EvaluationException {
        EvaluationResult evaluationResult = this.internalEvaluate(context, expression);
        Object result = evaluationResult.getEvaluationResult();
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public Collection<String> getImports() {
        LinkedHashSet extendedImports = Sets.newLinkedHashSet();
        for (ModuleDescriptor moduleDescriptor : this.extendedDependencies) {
            extendedImports.add(moduleDescriptor.getQualifiedName().replace("::", "."));
        }
        return Sets.union((Set)this.mtlDependencies.keySet(), (Set)extendedImports);
    }

    public DynamicAcceleoModule getModule() {
        return this.module;
    }

    public String getPrefix() {
        return ACCELEO_EXPRESSION_PREFIX;
    }

    public Object getVariable(String name) {
        List values;
        if (this.variables.containsKey((Object)name) && !(values = this.variables.get((Object)name)).isEmpty()) {
            return AcceleoMTLInterpreter.getLast(values);
        }
        return null;
    }

    public String getVariablePrefix() {
        return null;
    }

    public Map<String, ?> getVariables() {
        return this.variables.asMap();
    }

    public boolean provides(String expression) {
        if (expression != null) {
            return expression.startsWith(ACCELEO_EXPRESSION_PREFIX) && expression.endsWith(ACCELEO_EXPRESSION_SUFFIX);
        }
        return false;
    }

    public void removeImport(String dependency) {
        boolean removed = false;
        if (this.mtlDependencies.containsKey((Object)dependency)) {
            this.mtlDependencies.removeAll((Object)dependency);
            removed = true;
        } else if (this.javaFiles.containsKey(dependency)) {
            this.javaFiles.remove(dependency);
            this.extendedDependencies.remove(dependency);
            removed = true;
        }
        if (removed) {
            this.invalidateModule();
        }
    }

    public void removeVariableStatusListener(IVariableStatusListener listener) {
        this.variableStatusListeners.remove(listener);
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
        if (this.adapterFactory == null) {
            this.adapterFactory = new CrossReferencerProviderAdapterFactory(crossReferencer);
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.adapterFactory, EObject.class);
        }
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    public void setProperty(Object key, Object value) {
        if ("files".equals(key)) {
            if (value == null) {
                this.viewpointProjects.clear();
                this.viewpointPlugins.clear();
            } else if (value instanceof Collection) {
                for (String odesignPath : Iterables.filter((Iterable)((Collection)value), String.class)) {
                    URI workspaceCandidate = URI.createPlatformResourceURI((String)odesignPath, (boolean)true);
                    URI pluginCandidate = URI.createPlatformPluginURI((String)odesignPath, (boolean)true);
                    if (AcceleoMTLInterpreter.existsInWorkspace(workspaceCandidate.toPlatformString(true))) {
                        this.viewpointProjects.add(workspaceCandidate.segment(1));
                        continue;
                    }
                    if (!AcceleoMTLInterpreter.existsInPlugins(URI.decode((String)pluginCandidate.toString()))) continue;
                    this.viewpointPlugins.add(pluginCandidate.segment(1));
                }
            }
        }
    }

    public void setVariable(String name, Object value) {
        this.variables.put((Object)name, value);
        this.variableNsURIs.clear();
        this.compilationVariables.clear();
    }

    public boolean supportsValidation() {
        return true;
    }

    public void unSetVariable(String name) {
        if (this.variables.containsKey((Object)name)) {
            List values = this.variables.get((Object)name);
            if (!values.isEmpty()) {
                ListIterator iterator = values.listIterator(values.size());
                iterator.previous();
                iterator.remove();
                this.notifyVariableListeners();
            }
            this.variableNsURIs.clear();
            this.compilationVariables.clear();
        }
    }

    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return this.analyzeExpression(context, expression).getStatuses();
    }

    protected void invalidateModule() {
        this.module.invalidate();
    }

    private void addContextImports(IInterpreterContext context) {
        Resource resource;
        EObject element = context.getElement();
        if (element != null && (resource = element.eResource()) != null) {
            URI uri = resource.getURI();
            if (AcceleoMTLInterpreter.existsInWorkspace(uri.toPlatformString(true))) {
                this.viewpointProjects.add(uri.segment(1));
            } else if (AcceleoMTLInterpreter.existsInPlugins(uri.toPlatformString(true))) {
                this.viewpointPlugins.add(uri.segment(1));
            }
        }
        for (String dependency : context.getDependencies()) {
            this.addImport(dependency);
        }
    }

    private boolean addExtendedImport(String dependency) {
        boolean changedDependencies = false;
        Iterator<ModuleDescriptor> currentDescriptors = this.extendedDependencies.iterator();
        while (currentDescriptors.hasNext() && !changedDependencies) {
            if (!currentDescriptors.next().getQualifiedName().equals(dependency)) continue;
            changedDependencies = true;
            currentDescriptors.remove();
        }
        List<AbstractImportHandler> handlers = ImportHandlerRegistry.getRegisteredHandlers();
        boolean foundHandler = false;
        int i = 0;
        while (i < handlers.size() && !foundHandler) {
            ModuleDescriptor extendedModule;
            AbstractImportHandler importHandler = handlers.get(i);
            if (importHandler.canImport(this.viewpointPlugins, this.viewpointProjects, dependency) && (extendedModule = importHandler.createImport(this.viewpointPlugins, this.viewpointProjects, dependency)) != null) {
                this.extendedDependencies.add(extendedModule);
                foundHandler = true;
            }
            ++i;
        }
        return changedDependencies || foundHandler;
    }

    private boolean addMTLImport(String dependency) {
        String actualDependency = dependency;
        int dotIndex = actualDependency.lastIndexOf(46);
        if (dotIndex >= 0 && !actualDependency.substring(dotIndex).contains("::")) {
            actualDependency = actualDependency.substring(0, dotIndex);
        }
        String emtlPath = actualDependency.replaceAll("::", "/");
        Sets.SetView candidates = Sets.union(this.findProjectCandidates(emtlPath = String.valueOf(emtlPath) + ".emtl"), this.findPluginCandidates(emtlPath));
        if (!candidates.isEmpty()) {
            return this.mtlDependencies.putAll((Object)actualDependency, (Iterable)candidates);
        }
        return false;
    }

    private Collection<IInterpreterStatus> doValidateExpression(IInterpreterContext context, CompilationContext compilationContext) {
        DynamicAcceleoModule.QueryIdentifier query = this.module.ensureQueryExists(compilationContext);
        CompilationResult compilationResult = this.module.compile(compilationContext, query);
        LinkedHashSet validationStatus = Sets.newLinkedHashSet();
        if (compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() != 0 && compilationResult.getStatus() instanceof MultiStatus) {
            IStatus[] iStatusArray = ((MultiStatus)compilationResult.getStatus()).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                VariableType type = VariableType.fromString((String)compilationContext.getTargetType());
                String severity = child.getSeverity() == 4 ? "error" : "warning";
                validationStatus.add(InterpreterStatusFactory.createInterpreterStatus((VariableType)type, (EStructuralFeature)context.getField(), (String)severity, (String)child.getMessage(), (int)0, (int)0, (int)0));
                ++n2;
            }
        }
        return validationStatus;
    }

    private Set<URI> findPluginCandidates(String emtlPath) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (String viewpointPluginSymbolicName : this.viewpointPlugins) {
            String fileName;
            Enumeration emtlEntries;
            Bundle viewpointPlugin = Platform.getBundle((String)viewpointPluginSymbolicName);
            if (viewpointPlugin == null || (emtlEntries = viewpointPlugin.findEntries("/", fileName = emtlPath.substring(emtlPath.lastIndexOf("/") + 1), true)) == null) continue;
            while (emtlEntries.hasMoreElements()) {
                String candidatePath = ((URL)emtlEntries.nextElement()).getPath();
                if (!AcceleoMTLInterpreter.pathEndsWith(candidatePath, emtlPath)) continue;
                StringBuilder fullPath = new StringBuilder(viewpointPluginSymbolicName);
                fullPath.append('/').append(candidatePath);
                result.add(URI.createPlatformPluginURI((String)fullPath.toString(), (boolean)true));
            }
        }
        return result;
    }

    private Set<URI> findProjectCandidates(String emtlPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (String viewpointProjectPath : this.viewpointProjects) {
            if (!workspace.getRoot().exists((IPath)new Path(viewpointProjectPath))) continue;
            IProject viewpointProject = workspace.getRoot().getProject(viewpointProjectPath);
            try {
                ResourceFinder emtlFinder = new ResourceFinder(emtlPath);
                viewpointProject.accept((IResourceVisitor)emtlFinder);
                for (IResource candidate : emtlFinder.getMatches()) {
                    result.add(URI.createPlatformResourceURI((String)candidate.getFullPath().toString(), (boolean)true));
                }
            }
            catch (CoreException e) {
                AcceleoMTLInterpreterPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.common.acceleo.mtl", e.getMessage(), (Throwable)e));
            }
        }
        return result;
    }

    private EvaluationResult internalEvaluate(EObject context, String expression) {
        DynamicAcceleoModule.QueryIdentifier identifier;
        CompilationContext compilationContext = this.createCompilationContext(context, expression);
        CompilationResult compilationResult = this.module.compile(compilationContext, identifier = this.module.ensureQueryExists(compilationContext));
        if (compilationResult.getStatus() == null || compilationResult.getStatus().getSeverity() == 0) {
            EvaluationContext evaluationContext = new EvaluationContext(context, this.variables, compilationResult);
            return this.module.evaluate(evaluationContext);
        }
        return new EvaluationResult(null, compilationResult.getStatus());
    }

    private void notifyVariableListeners() {
        for (IVariableStatusListener variableStatusListener : this.variableStatusListeners) {
            variableStatusListener.notifyChanged(this.getVariables());
        }
    }

    public static AcceleoMTLInterpreter createStandaloneInterpreter() {
        AcceleoMTLInterpreter.registerPackages(EPackage.Registry.INSTANCE);
        AcceleoMTLInterpreter.registerResourceFactories(Resource.Factory.Registry.INSTANCE);
        AcceleoMTLInterpreter.registerLibraries();
        return new AcceleoMTLInterpreter();
    }

    private static void registerPackages(EPackage.Registry registry) {
        registry.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        registry.put((Object)org.eclipse.ocl.ecore.EcorePackage.eINSTANCE.getNsURI(), (Object)org.eclipse.ocl.ecore.EcorePackage.eINSTANCE);
        registry.put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        registry.put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        registry.put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)AcceleoMTLInterpreter.getOCLStdLibPackage());
    }

    private static void registerResourceFactories(Resource.Factory.Registry registry) {
        registry.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        registry.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.binary", new EMtlBinaryResourceFactoryImpl());
        registry.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.xmi", new EMtlResourceFactoryImpl());
        registry.getExtensionToFactoryMap().put("emtl", new EMtlResourceFactoryImpl());
    }

    private static EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        EPackage oclStdLibPackage = (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
        environment.dispose();
        return oclStdLibPackage;
    }

    private static void registerLibraries() {
        String libraryLocation;
        CodeSource acceleoModel = MtlPackage.class.getProtectionDomain().getCodeSource();
        if (acceleoModel != null) {
            libraryLocation = acceleoModel.getLocation().toString();
            if (libraryLocation.endsWith(".jar")) {
                libraryLocation = "jar:" + libraryLocation + '!';
            }
        } else {
            throw new RuntimeException(Messages.AcceleoMTLInterpreter_acceleoModelPluginNotFound);
        }
        URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlstdlib.ecore"), URI.createURI((String)(String.valueOf(libraryLocation) + "/model/mtlstdlib.ecore")));
        URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlnonstdlib.ecore"), URI.createURI((String)(String.valueOf(libraryLocation) + "/model/mtlnonstdlib.ecore")));
    }

    public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
        this.invalidateModule();
        ValidationResult result = new ValidationResult();
        LinkedHashMap validationVariables = Maps.newLinkedHashMap();
        for (Map.Entry contextVariable : context.getVariables().entrySet()) {
            String varName = (String)contextVariable.getKey();
            VariableType varType = (VariableType)contextVariable.getValue();
            boolean isVarNameValid = varName != null && varName.length() > 0 && !varName.matches("[0-9]+");
            boolean isVarTypeValid = varType.hasDefinition();
            if (!isVarNameValid || !isVarTypeValid) continue;
            validationVariables.put(varName, varType.getCommonType(context.getAvailableEPackages()).getCompleteName("::"));
        }
        if (!context.requiresTargetType()) {
            CompilationContext compilationContext = this.createCompilationContext(context, expression, "ecore::EObject", validationVariables);
            result.addAllStatus(this.doValidateExpression(context, compilationContext));
        } else {
            VariableType candidateType = context.getTargetType();
            if (!candidateType.hasDefinition()) {
                String message = MessageFormat.format(Messages.AcceleoMTLInterpreter_domainClassNotFound, context.getField().getName());
                result.addStatus(InterpreterStatusFactory.createInterpreterStatus((VariableType)context.getTargetType(), (EStructuralFeature)context.getField(), (String)"warning", (String)message));
            } else {
                for (TypeName candidateTargetType : candidateType.getPossibleTypes()) {
                    String expressionType = candidateTargetType.getCompleteName("::");
                    CompilationContext compilationContext = this.createCompilationContext(context, expression, expressionType, validationVariables);
                    result.addAllStatus(this.doValidateExpression(context, compilationContext));
                }
            }
        }
        return result;
    }
}

