/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.palette;

import java.io.File;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.swt.graphics.Image;

public class PaletteImageProvider {
    private static final String ICON_PATH = "iconPath";

    public ImageDescriptor getImageDescriptor(AbstractToolDescription abstractToolDescription) {
        Image res;
        String path = null;
        if (abstractToolDescription.eClass().getEStructuralFeature(ICON_PATH) != null) {
            path = (String)abstractToolDescription.eGet(abstractToolDescription.eClass().getEStructuralFeature(ICON_PATH));
        }
        if (path == null || StringUtil.isEmpty((String)path.trim())) {
            String domainClassToUse = PaletteImageProvider.getDomainClass(PaletteImageProvider.mappings(abstractToolDescription));
            if (domainClassToUse != null) {
                try {
                    EObject anInstance = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)abstractToolDescription).createInstance(domainClassToUse);
                    return DiagramUIPlugin.getPlugin().getItemImageDescriptor(anInstance);
                }
                catch (MetaClassNotFoundException metaClassNotFoundException) {
                    SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.PaletteImageProvider_noIconFor, abstractToolDescription.getName()), null);
                }
            }
            path = abstractToolDescription instanceof EdgeCreationDescription ? "/org.eclipse.sirius.diagram.ui/icons/full/obj16/DEdge.gif" : "/org.eclipse.sirius.ui/icons/full/obj16/ToolDescription.gif";
        }
        ImageDescriptor desc = (res = this.getImageFromPath(path)) == null ? DiagramUIPlugin.Implementation.getBundledImageDescriptor("/org.eclipse.sirius.ui/icons/full/obj16/Error.gif") : ImageDescriptor.createFromImage((Image)res);
        return desc;
    }

    private Image getImageFromPath(String path) {
        File imageFile = FileProvider.getDefault().getFile((IPath)new Path(path));
        ImageDescriptor desc = null;
        if (imageFile != null && imageFile.exists() && imageFile.canRead()) {
            try {
                desc = DiagramUIPlugin.Implementation.findImageDescriptor(imageFile.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.flyWeightImage(desc);
    }

    private Image flyWeightImage(ImageDescriptor desc) {
        if (desc != null) {
            return DiagramUIPlugin.getPlugin().getImage(desc);
        }
        return null;
    }

    private static List<? extends DiagramElementMapping> mappings(AbstractToolDescription tool) {
        Object result = tool instanceof NodeCreationDescription ? ((NodeCreationDescription)tool).getNodeMappings() : (tool instanceof EdgeCreationDescription ? ((EdgeCreationDescription)tool).getEdgeMappings() : (tool instanceof ContainerCreationDescription ? ((ContainerCreationDescription)tool).getContainerMappings() : Collections.emptyList()));
        return result;
    }

    private static String getDomainClass(List<? extends DiagramElementMapping> mappings) {
        String domainClassToUse = null;
        boolean again = true;
        Iterator<? extends DiagramElementMapping> itMappings = mappings.iterator();
        while (itMappings.hasNext() && again) {
            DiagramElementMapping currentMapping = itMappings.next();
            String domainClass = PaletteImageProvider.getDomainClass(currentMapping);
            if (domainClass != null && !StringUtil.isEmpty((String)domainClass.trim())) {
                if (domainClassToUse == null || domainClassToUse.equals(domainClass)) {
                    domainClassToUse = domainClass;
                    continue;
                }
                domainClassToUse = null;
                again = false;
                continue;
            }
            domainClass = null;
            again = false;
        }
        return domainClassToUse;
    }

    private static String getDomainClass(DiagramElementMapping mapping) {
        String domainClass = null;
        if (mapping instanceof NodeMapping) {
            domainClass = ((NodeMapping)mapping).getDomainClass();
        } else if (mapping instanceof EdgeMapping) {
            EdgeMapping edgeMapping = (EdgeMapping)mapping;
            if (edgeMapping.isUseDomainElement()) {
                domainClass = edgeMapping.getDomainClass();
            }
        } else if (mapping instanceof ContainerMapping) {
            domainClass = ((ContainerMapping)mapping).getDomainClass();
        }
        return domainClass;
    }
}

