/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.SemanticPropertySection;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.IPropertySource;

public class StylePropertySection
extends SemanticPropertySection {
    private Map<DStylizable, View> map = new HashMap<DStylizable, View>();

    @Override
    public IPropertySource getPropertySource(Object object) {
        IPropertySource propSrc = null;
        if (object instanceof IPropertySource) {
            propSrc = (IPropertySource)object;
        } else if (!(object instanceof EObject) || this.getPermissionAuthority((EObject)object).canEditInstance((EObject)object)) {
            propSrc = this.getStylePropertySource(object);
        }
        return propSrc;
    }

    private IPropertySource getStylePropertySource(Object object) {
        Object propSrc = null;
        if (object instanceof DStylizable) {
            IItemPropertySource ips;
            AdapterFactory af;
            DStylizable stylizable = (DStylizable)object;
            View view = this.map.get(stylizable);
            Style style = stylizable.getStyle();
            if (style != null && (af = this.getAdapterFactory(style)) != null && (ips = (IItemPropertySource)af.adapt((Notifier)style, IItemPropertySource.class)) != null) {
                propSrc = new StylePropertySource(style, view, ips);
            }
        }
        if (propSrc == null) {
            IItemPropertySource ips;
            AdapterFactory af = this.getAdapterFactory(object);
            if (af != null && (ips = (IItemPropertySource)af.adapt(object, IItemPropertySource.class)) != null) {
                propSrc = new StylePropertySource(object, ips);
            }
            if (propSrc == null && object instanceof IAdaptable) {
                propSrc = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
            }
        }
        return propSrc;
    }

    private IPermissionAuthority getPermissionAuthority(EObject instance) {
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(instance);
        return accessor.getPermissionAuthority();
    }

    @Override
    protected Object transformSelection(Object selection) {
        EObject target;
        Object object = selection;
        View view = null;
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        } else if (object instanceof IAdaptable) {
            object = ((IAdaptable)object).getAdapter(View.class);
        }
        if (object instanceof View) {
            view = (View)object;
            object = view.getElement();
        }
        if (view != null && object instanceof DStylizable) {
            this.map.put((DStylizable)object, view);
        }
        if (object instanceof DSemanticDecorator && ((target = ((DSemanticDecorator)object).getTarget()) == null || target.eResource() == null)) {
            object = null;
        }
        return object;
    }

    private static class StylePropertySource
    extends PropertySource {
        private View view;

        public StylePropertySource(Object object, IItemPropertySource itemPropertySource) {
            super(object, itemPropertySource);
            this.view = null;
        }

        public StylePropertySource(Object object, View view, IItemPropertySource itemPropertySource) {
            super(object, itemPropertySource);
            this.view = view;
        }

        public void setPropertyValue(Object propertyId, Object value) {
            if (this.object instanceof Style && propertyId instanceof String) {
                Style style = (Style)this.object;
                String featureName = (String)propertyId;
                EStructuralFeature feature = style.eClass().getEStructuralFeature(featureName);
                if (feature != null && !style.getCustomFeatures().contains((Object)feature.getName())) {
                    style.getCustomFeatures().add((Object)feature.getName());
                }
            } else if (this.object instanceof EObject && ((EObject)this.object).eContainer() instanceof Style && propertyId instanceof String) {
                EObject containedValue = (EObject)this.object;
                Style style = (Style)containedValue.eContainer();
                EStructuralFeature feature = containedValue.eContainingFeature();
                if (feature != null && !style.getCustomFeatures().contains((Object)feature.getName())) {
                    style.getCustomFeatures().add((Object)feature.getName());
                }
            }
            super.setPropertyValue(propertyId, value);
            if (this.object instanceof LabelStyle) {
                this.updateNotationView(propertyId, value);
            } else if (this.object instanceof EdgeStyle) {
                this.updateNotationView(propertyId, value);
            } else if (this.object instanceof RGBValues) {
                this.updateNotationView(propertyId, value);
            }
        }

        private void updateNotationView(Object propertyId, Object value) {
            if (this.view == null || this.view.getStyles() == null) {
                return;
            }
            for (Object notationStyle : this.view.getStyles()) {
                if (notationStyle instanceof FontStyle) {
                    FontStyle fontStyle = (FontStyle)notationStyle;
                    if (propertyId.equals(ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName())) {
                        if (value instanceof List) {
                            if (fontStyle.isBold() != ((List)value).contains(FontFormat.BOLD_LITERAL)) {
                                fontStyle.setBold(((List)value).contains(FontFormat.BOLD_LITERAL));
                            }
                            if (fontStyle.isItalic() != ((List)value).contains(FontFormat.ITALIC_LITERAL)) {
                                fontStyle.setItalic(((List)value).contains(FontFormat.ITALIC_LITERAL));
                            }
                            if (fontStyle.isUnderline() != ((List)value).contains(FontFormat.UNDERLINE_LITERAL)) {
                                fontStyle.setUnderline(((List)value).contains(FontFormat.UNDERLINE_LITERAL));
                            }
                            if (fontStyle.isStrikeThrough() == ((List)value).contains(FontFormat.STRIKE_THROUGH_LITERAL)) continue;
                            fontStyle.setStrikeThrough(((List)value).contains(FontFormat.STRIKE_THROUGH_LITERAL));
                            continue;
                        }
                        fontStyle.setBold(false);
                        fontStyle.setItalic(false);
                        fontStyle.setUnderline(false);
                        fontStyle.setStrikeThrough(false);
                        continue;
                    }
                    if (value instanceof Integer && ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE.getName().equals(propertyId)) {
                        fontStyle.setFontHeight(Math.max((Integer)value, 1));
                        continue;
                    }
                    if (!(value instanceof RGBValues) || !ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_COLOR.getName().equals(propertyId)) continue;
                    RGBValues rgbValues = (RGBValues)value;
                    fontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)new RGB(rgbValues.getRed(), rgbValues.getGreen(), rgbValues.getBlue())).intValue());
                    continue;
                }
                if (!(notationStyle instanceof ConnectorStyle)) continue;
                ConnectorStyle connectorStyle = (ConnectorStyle)notationStyle;
                if (!(value instanceof EdgeRouting) || !propertyId.equals(DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName())) continue;
                if (EdgeRouting.MANHATTAN_LITERAL == value) {
                    connectorStyle.setRouting(Routing.RECTILINEAR_LITERAL);
                    continue;
                }
                if (EdgeRouting.STRAIGHT_LITERAL == value) {
                    connectorStyle.setRouting(Routing.MANUAL_LITERAL);
                    continue;
                }
                if (EdgeRouting.TREE_LITERAL != value) continue;
                connectorStyle.setRouting(Routing.TREE_LITERAL);
            }
        }
    }
}

