/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.wizards.page;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.osgi.framework.Bundle;

public class ViewpointsSelectionWizardPage
extends WizardPage {
    private TableViewer tableViewer;
    private Browser browser;
    private Composite pageComposite;
    private List<Viewpoint> viewpoints;
    private Collection<String> fileExtensions;
    private ArrayList<String> viewpointsNamesToActivateByDefault;

    public ViewpointsSelectionWizardPage(Session session) {
        super(Messages.ViewpointsSelectionWizardPage_title);
        this.setTitle(Messages.ViewpointsSelectionWizardPage_title);
        this.setMessage(Messages.ViewpointsSelectionWizardPage_message);
        this.fileExtensions = this.computeSemanticFileExtensions(session);
        this.viewpoints = Lists.newArrayList();
        this.viewpointsNamesToActivateByDefault = Lists.newArrayList();
    }

    public ViewpointsSelectionWizardPage(Session session, List<String> viewpointsNamesToActivateByDefault) {
        super(Messages.ViewpointsSelectionWizardPage_title);
        this.setTitle(Messages.ViewpointsSelectionWizardPage_title);
        this.setMessage(Messages.ViewpointsSelectionWizardPage_message);
        this.fileExtensions = this.computeSemanticFileExtensions(session);
        this.viewpoints = Lists.newArrayList();
        this.viewpointsNamesToActivateByDefault = Lists.newArrayList(viewpointsNamesToActivateByDefault);
    }

    protected Collection<String> computeSemanticFileExtensions(Session session) {
        HashSet<String> extensions = new HashSet<String>();
        for (Resource resource : session.getSemanticResources()) {
            String currentFileExtension;
            if (resource == null || resource.getURI() == null || (currentFileExtension = resource.getURI().fileExtension()) == null) continue;
            extensions.add(currentFileExtension);
        }
        return extensions;
    }

    public boolean isPageComplete() {
        String errorMessage = null;
        boolean complete = false;
        if (!this.viewpoints.isEmpty()) {
            Map<String, Collection<String>> missingDependencies = ViewpointSelection.getMissingDependencies(Sets.newHashSet(this.viewpoints));
            if (missingDependencies.isEmpty()) {
                complete = true;
            } else {
                errorMessage = ViewpointSelection.getMissingDependenciesErrorMessage(missingDependencies);
            }
        }
        this.setErrorMessage(errorMessage);
        return complete;
    }

    public List<Viewpoint> getViewpoints() {
        return this.viewpoints;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).create());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.tableViewer = this.createTableViewer(this.pageComposite);
        this.tableViewer.setInput(this.getAvailableViewpoints());
        this.browser = this.createBrowser(this.pageComposite);
        this.setBrowserInput(null);
        if (!this.viewpointsNamesToActivateByDefault.isEmpty()) {
            int i = 0;
            while (i < this.tableViewer.getTable().getItemCount()) {
                Object object = this.tableViewer.getElementAt(i);
                if (object instanceof Viewpoint && this.viewpointsNamesToActivateByDefault.contains(((Viewpoint)object).getName())) {
                    this.viewpoints.add((Viewpoint)object);
                }
                ++i;
            }
            if (!this.viewpoints.isEmpty() && this.tableViewer instanceof CheckboxTableViewer) {
                ((CheckboxTableViewer)this.tableViewer).setCheckedElements(this.viewpoints.toArray(new Object[0]));
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.viewpoints.get(0)));
            }
        }
        this.setControl((Control)this.pageComposite);
    }

    private Browser createBrowser(Composite parent) {
        try {
            Browser aBrowser = new Browser(parent, 0);
            GridData gridData = new GridData(4, 4, true, true);
            aBrowser.setLayoutData((Object)gridData);
            return aBrowser;
        }
        catch (SWTError sWTError) {
            return null;
        }
    }

    private Collection<Viewpoint> getAvailableViewpoints() {
        ViewpointRegistry registry = ViewpointRegistry.getInstance();
        return Collections2.filter((Collection)registry.getViewpoints(), (Predicate)new Predicate<Viewpoint>(){

            public boolean apply(Viewpoint viewpoint) {
                for (String ext : ViewpointsSelectionWizardPage.this.fileExtensions) {
                    if (!new ViewpointQuery(viewpoint).handlesSemanticModelExtension(ext)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private TableViewer createTableViewer(Composite parent) {
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2820);
        Table table = viewer.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn objectColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 60, true));
        objectColumn.setResizable(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewpointsTableLabelProvider());
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ViewpointsSelectionWizardPage.this.viewpoints.add((Viewpoint)event.getElement());
                } else {
                    ViewpointsSelectionWizardPage.this.viewpoints.remove(event.getElement());
                }
                ViewpointsSelectionWizardPage.this.setPageComplete(ViewpointsSelectionWizardPage.this.isPageComplete());
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Viewpoint) {
                    ViewpointsSelectionWizardPage.this.setBrowserInput((Viewpoint)firstElement);
                }
            }
        });
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String e1label = new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)e1)).getLabel();
                String e2label = new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)e2)).getLabel();
                return e1label.compareTo(e2label);
            }
        });
        return viewer;
    }

    protected void setBrowserInput(Viewpoint viewpoint) {
        if (this.browser != null) {
            String content = null;
            content = this.containsHTMLDocumentation(viewpoint) ? this.getContentWhenHtml(viewpoint) : this.getContentWhenNoHtml(viewpoint);
            this.browser.setText(content);
        }
    }

    private boolean containsHTMLDocumentation(Viewpoint viewpoint) {
        String doc;
        if (viewpoint != null && !StringUtil.isEmpty((String)(doc = viewpoint.getEndUserDocumentation()))) {
            return doc.startsWith("<html>");
        }
        return false;
    }

    private String getContentWhenHtml(Viewpoint viewpoint) {
        String document = viewpoint.getEndUserDocumentation();
        LinkedHashSet urlToRewrite = Sets.newLinkedHashSet();
        this.extractUrlToRewrite(document, urlToRewrite);
        return this.rewriteURLs(viewpoint, document, urlToRewrite);
    }

    private void extractUrlToRewrite(String document, Set<String> urlToRewrite) {
        int imgSrcStartIndex;
        int imgSrcStopIndex;
        String imgSrcPattern = "img src=\"";
        int patternStartIndex = document.indexOf(imgSrcPattern);
        if (patternStartIndex != -1 && (imgSrcStopIndex = document.indexOf("\"", imgSrcStartIndex = patternStartIndex + imgSrcPattern.length())) != -1) {
            String newToRewrite = document.substring(imgSrcStartIndex, imgSrcStopIndex);
            urlToRewrite.add(newToRewrite);
            this.extractUrlToRewrite(document.substring(imgSrcStopIndex), urlToRewrite);
        }
    }

    private String rewriteURLs(Viewpoint viewpoint, String document, Set<String> urls) {
        String newDocument = document;
        for (String url : urls) {
            newDocument = newDocument.replace(url, this.rewriteURL(viewpoint, url));
        }
        StringBuilder css = new StringBuilder();
        this.appendCss(css);
        String headClose = "</head>";
        newDocument = newDocument.replace(headClose, css.append(headClose));
        return newDocument;
    }

    private String rewriteURL(Viewpoint viewpoint, String url) {
        URI uri = viewpoint.eResource().getURI();
        String pluginId = uri.segment(1);
        String rewrittenURL = "";
        if (uri.isPlatformPlugin()) {
            Bundle bundle = Platform.getBundle((String)pluginId);
            URL imageURL = bundle.getEntry(url);
            String string = rewrittenURL = imageURL != null ? imageURL.toString() : rewrittenURL;
            if (imageURL != null) {
                try {
                    URL fileURL = FileLocator.toFileURL((URL)imageURL);
                    rewrittenURL = fileURL.toString();
                }
                catch (IOException iOException) {}
            }
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path("/" + pluginId + url);
            if (workspace.getRoot().exists((IPath)path)) {
                IResource resource = workspace.getRoot().findMember((IPath)path);
                rewrittenURL = resource.getLocation().toFile().toURI().toString();
            }
        }
        return rewrittenURL;
    }

    private String getContentWhenNoHtml(Viewpoint viewpoint) {
        StringBuilder content = new StringBuilder();
        return this.begin(content).head(content).body(content, viewpoint).end(content);
    }

    private ViewpointsSelectionWizardPage begin(StringBuilder content) {
        content.append("<html>");
        return this;
    }

    private ViewpointsSelectionWizardPage head(StringBuilder content) {
        content.append("<head>");
        this.appendCss(content);
        content.append("</head>");
        return this;
    }

    private ViewpointsSelectionWizardPage body(StringBuilder content, Viewpoint viewpoint) {
        content.append("<body>");
        if (viewpoint == null) {
            content.append("<br><br><center><b>").append(Messages.ViewpointsSelectionWizardPage_documentation_title).append("</b></center>");
        } else {
            String endUserDocumentation = viewpoint.getEndUserDocumentation();
            if (!StringUtil.isEmpty((String)endUserDocumentation)) {
                content.append(viewpoint.getEndUserDocumentation());
            } else {
                content.append(Messages.ViewpointsSelectionWizardPage_documentation_none);
            }
        }
        content.append("</body>");
        return this;
    }

    private StringBuilder appendCss(StringBuilder content) {
        Font currentFont = JFaceResources.getDialogFont();
        FontData data = currentFont.getFontData()[0];
        String fontName = data.getName();
        int fontHeight = data.getHeight() + 3;
        content.append("<style type=\"text/css\">");
        content.append("body{font-family:" + fontName + ",Arial, sans-serif;}");
        content.append("body{font-size:" + fontHeight + "px;}");
        content.append("</style>");
        return content;
    }

    private String end(StringBuilder content) {
        content.append("</html>");
        return content.toString();
    }

    public boolean isCurrentPageOnWizard() {
        return super.isCurrentPage();
    }

    private class ViewpointsTableLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider {
        public ViewpointsTableLabelProvider() {
            super(ViewHelper.INSTANCE.createAdapterFactory());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            if (columnIndex == 0) {
                if (element instanceof Viewpoint) {
                    ImageDescriptor desc;
                    Viewpoint vp = (Viewpoint)element;
                    if (vp.getIcon() != null && vp.getIcon().length() > 0 && (desc = SiriusEditPlugin.Implementation.findImageDescriptor(vp.getIcon())) != null) {
                        image = SiriusEditPlugin.getPlugin().getImage(desc);
                        image = this.getEnhancedImage(image, vp);
                    }
                    if (image == null) {
                        image = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.getPlugin().getItemImageDescriptor(vp));
                        image = this.getEnhancedImage(image, vp);
                    }
                } else {
                    image = super.getImage(element);
                }
            }
            return image;
        }

        private ImageDescriptor getOverlayedDescriptor(Image baseImage, String decoratorPath) {
            ImageDescriptor decoratorDescriptor = SiriusEditPlugin.Implementation.getBundledImageDescriptor(decoratorPath);
            return new DecorationOverlayIcon(baseImage, decoratorDescriptor, 2);
        }

        private Image getEnhancedImage(Image image, Viewpoint viewpoint) {
            if (!ViewpointRegistry.getInstance().isFromPlugin(viewpoint) && image != null) {
                return SiriusEditPlugin.getPlugin().getImage(this.getOverlayedDescriptor(image, "icons/full/decorator/folder_close.gif"));
            }
            return image;
        }
    }
}

