/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.OpenRepresentationsFileJob;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.progress.UIJob;

public class OpenSessionOnExpandListener
implements ITreeViewerListener {
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        if (event.getElement() instanceof IProject) {
            Option optionalMainSessionFileURI;
            IProject projectExpanded = (IProject)event.getElement();
            Option optionalModelingProject = ModelingProject.asModelingProject((IProject)projectExpanded);
            if (optionalModelingProject.some() && (optionalMainSessionFileURI = ((ModelingProject)optionalModelingProject.get()).getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor(), false, false)).some()) {
                ModelingProjectManager.INSTANCE.loadAndOpenRepresentationsFile((URI)optionalMainSessionFileURI.get());
            }
        } else if (event.getElement() instanceof IFile) {
            this.reactToFileExpanded((IFile)event.getElement(), event);
        }
    }

    private void reactToFileExpanded(IFile expandedFile, TreeExpansionEvent event) {
        Option optionalModelingProject = ModelingProject.asModelingProject((IProject)expandedFile.getProject());
        if ((optionalModelingProject.some() || "aird".equals(expandedFile.getFileExtension())) && OpenRepresentationsFileJob.shouldWaitOtherJobs()) {
            OpenRepresentationsFileJob.waitOtherJobs();
            ExpandAgainJob expandAgain = new ExpandAgainJob(event.getTreeViewer(), expandedFile);
            expandAgain.schedule();
        }
    }

    private class ExpandAgainJob
    extends UIJob {
        private final AbstractTreeViewer viewer;
        private final Object itemToExpand;

        public ExpandAgainJob(AbstractTreeViewer viewer, IFile itemToExpand) {
            super(MessageFormat.format(Messages.OpenSessionOnExpandListener_expandJob, itemToExpand.getName()));
            this.viewer = viewer;
            this.itemToExpand = itemToExpand;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.viewer != null) {
                if (this.isViewerBusy()) {
                    this.schedule();
                } else {
                    this.viewer.expandToLevel(this.itemToExpand, 1);
                }
            }
            return Status.OK_STATUS;
        }

        private boolean isViewerBusy() {
            boolean viewerIsBusy = false;
            if (this.viewer != null) {
                AccessibleObject method = null;
                try {
                    method = this.viewer.getClass().getMethod("isBusy", new Class[0]);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method != null) {
                    if (!method.isAccessible()) {
                        ((Method)method).setAccessible(true);
                    }
                    try {
                        Object data = ((Method)method).invoke(this.viewer, new Object[0]);
                        if (data instanceof Boolean) {
                            viewerIsBusy = (Boolean)data;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            }
            return viewerIsBusy;
        }
    }
}

