/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session.danalysis;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DAnalysisQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.internal.movida.ViewpointSelection;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class DAnalysisSessionHelper {
    private DAnalysisSessionHelper() {
    }

    public static void addNewAnalysisResource(DAnalysisSession session, Resource loadedResource) {
        boolean newAird = true;
        Iterator<Resource> iterator = session.getAllSessionResources().iterator();
        while (newAird && iterator.hasNext()) {
            Resource resource = iterator.next();
            boolean bl = newAird = !resource.getURI().equals(loadedResource.getURI());
        }
        if (newAird) {
            session.addAnalysis(loadedResource);
        }
    }

    public static DAnalysis selectAnalysis(Viewpoint viewpoint, Collection<DAnalysis> candidates, DAnalysisSelector analysisSelector, DRepresentation addedRepresentation) {
        if (candidates.size() > 1 && analysisSelector != null) {
            return analysisSelector.selectSmartlyAnalysisForAddedRepresentation(addedRepresentation, candidates);
        }
        return (DAnalysis)candidates.toArray()[0];
    }

    public DAnalysis selectAnalysis(Resource resource, Collection<DAnalysis> candidates, DAnalysisSelector analysisSelector) {
        if (candidates.size() > 1 && analysisSelector != null) {
            return analysisSelector.selectSmartlyAnalysisForAddedResource(resource, candidates);
        }
        return (DAnalysis)candidates.toArray()[0];
    }

    public static DRepresentationContainer findContainer(EObject semanticRoot, Viewpoint viewpoint, Collection<DAnalysis> all, DAnalysisSelector analysisSelector) {
        Collection<DRepresentationContainer> containers = DAnalysisSessionHelper.getContainers(all, viewpoint);
        if (containers.isEmpty()) {
            return null;
        }
        ArrayList<DAnalysis> candidates = new ArrayList<DAnalysis>();
        for (DRepresentationContainer container : containers) {
            if (!(container.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)container.eContainer());
        }
        DAnalysis analysis = (DAnalysis)candidates.iterator().next();
        DRepresentationContainer freeContainer = null;
        for (DRepresentationContainer container : containers) {
            if (container.eContainer() != analysis) continue;
            freeContainer = container;
            break;
        }
        return freeContainer;
    }

    public static DRepresentationContainer findContainerForAddedRepresentation(EObject semanticRoot, Viewpoint viewpoint, Collection<DAnalysis> all, DAnalysisSelector analysisSelector, DRepresentation representation) {
        Collection<DRepresentationContainer> containers = DAnalysisSessionHelper.getContainers(all, viewpoint);
        if (containers.isEmpty()) {
            return null;
        }
        LinkedHashSet candidates = Sets.newLinkedHashSet();
        for (DRepresentationContainer container : containers) {
            if (!(container.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)container.eContainer());
        }
        DAnalysis analysis = DAnalysisSessionHelper.selectAnalysis(viewpoint, candidates, analysisSelector, representation);
        DRepresentationContainer freeContainer = null;
        for (DRepresentationContainer container : containers) {
            if (container.eContainer() != analysis) continue;
            freeContainer = container;
            break;
        }
        if (freeContainer == null && "cdo".equals(analysis.eResource().getURI().scheme())) {
            freeContainer = DAnalysisSessionHelper.createContainer(analysis, viewpoint);
        }
        return freeContainer;
    }

    public static DRepresentationContainer findContainerForAddedRepresentation(DAnalysis analysis, DRepresentation representation) {
        Viewpoint viewpoint = new RepresentationDescriptionQuery(DialectManager.INSTANCE.getDescription(representation)).getParentViewpoint();
        return DAnalysisSessionHelper.getContainer(analysis, viewpoint);
    }

    public static DRepresentationContainer findFreeContainer(Viewpoint viewpoint, Collection<DAnalysis> analyses, DAnalysisSelector analysisSelector) {
        Collection<DRepresentationContainer> views = DAnalysisSessionHelper.getContainers(analyses, null);
        if (views.isEmpty()) {
            return null;
        }
        ArrayList<DAnalysis> candidates = new ArrayList<DAnalysis>();
        for (DRepresentationContainer view : views) {
            if (!(view.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)view.eContainer());
        }
        DAnalysis analysis = (DAnalysis)candidates.iterator().next();
        DRepresentationContainer freeView = null;
        for (DRepresentationContainer view : views) {
            if (view.eContainer() != analysis) continue;
            freeView = view;
            break;
        }
        return freeView;
    }

    public static DRepresentationContainer findFreeContainerForAddedRepresentation(Viewpoint viewpoint, EObject semantic, Collection<DAnalysis> analyses, DAnalysisSelector analysisSelector, DRepresentation representation) {
        Collection<DRepresentationContainer> views = DAnalysisSessionHelper.getContainers(analyses, null);
        if (views.isEmpty()) {
            return null;
        }
        ArrayList<DAnalysis> candidates = new ArrayList<DAnalysis>();
        for (DRepresentationContainer view : views) {
            if (!(view.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)view.eContainer());
        }
        DAnalysis analysis = DAnalysisSessionHelper.selectAnalysis(viewpoint, candidates, analysisSelector, representation);
        DRepresentationContainer freeView = null;
        for (DRepresentationContainer view : views) {
            if (view.eContainer() != analysis) continue;
            freeView = view;
            break;
        }
        return freeView;
    }

    public static Collection<Resource> getSemanticResource(Resource diagramResource) {
        EObject root;
        HashSet<Resource> semanticResources = new HashSet<Resource>();
        if (diagramResource.getContents().size() > 0 && (root = (EObject)diagramResource.getContents().get(0)) instanceof DAnalysis) {
            for (EObject model : ((DAnalysis)root).getModels()) {
                Resource modelResource = model.eResource();
                if (modelResource == null) continue;
                semanticResources.add(modelResource);
            }
        }
        return semanticResources;
    }

    public static ViewpointSelection getViewpointSelection(ViewpointRegistry registry, DAnalysisSession session) {
        ViewpointSelection selection = new ViewpointSelection(registry);
        HashSet selectedBefore = Sets.newHashSet((Iterable)Iterables.transform(session.getSelectedViewpoints(false), (Function)new Function<Viewpoint, URI>(){

            public URI apply(Viewpoint from) {
                return (URI)new ViewpointQuery(from).getViewpointURI().get();
            }
        }));
        selection.setSelected(selectedBefore);
        return selection;
    }

    public static void updateModelsReferences(DAnalysis analysis, Iterator<DSemanticDecorator> iterator) {
        while (iterator.hasNext()) {
            EObject rootContainerInSameResource;
            EObject semanticTarget = iterator.next().getTarget();
            if (semanticTarget == null || (rootContainerInSameResource = new EObjectQuery(semanticTarget).getResourceContainer()) == null) continue;
            boolean isMainModelOfReferencedAnalysis = false;
            for (DAnalysis referencedAnalysis : new DAnalysisQuery(analysis).getAllReferencedAnalyses()) {
                Option<EObject> optionalMainModel = new DAnalysisQuery(referencedAnalysis).getMainModel();
                if (!optionalMainModel.some() || !((EObject)optionalMainModel.get()).equals(rootContainerInSameResource)) continue;
                isMainModelOfReferencedAnalysis = true;
            }
            if (isMainModelOfReferencedAnalysis) continue;
            analysis.getSemanticResources().add((Object)new ResourceDescriptor(rootContainerInSameResource.eResource().getURI()));
        }
    }

    private static Collection<DRepresentationContainer> getContainers(Iterable<DAnalysis> allAnalysis, Viewpoint viewpoint) {
        ArrayList<DRepresentationContainer> containers = new ArrayList<DRepresentationContainer>();
        for (DAnalysis analysis : allAnalysis) {
            DRepresentationContainer container = DAnalysisSessionHelper.getContainer(analysis, viewpoint);
            if (container == null) continue;
            containers.add(container);
        }
        return containers;
    }

    private static DRepresentationContainer getContainer(DAnalysis analysis, Viewpoint viewpoint) {
        DRepresentationContainer result = null;
        for (DView view : analysis.getOwnedViews()) {
            if (!(view instanceof DRepresentationContainer) || viewpoint != view.getViewpoint()) continue;
            result = (DRepresentationContainer)view;
            break;
        }
        return result;
    }

    private static DRepresentationContainer createContainer(DAnalysis analysis, Viewpoint viewpoint) {
        DRepresentationContainer newContainer = ViewpointFactory.eINSTANCE.createDRepresentationContainer();
        newContainer.setViewpoint(viewpoint);
        analysis.getOwnedViews().add((Object)newContainer);
        analysis.getSelectedViews().add((Object)newContainer);
        return newContainer;
    }
}

