/**
 * Copyright (c) 2007, 2013 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *
 */
package org.eclipse.sirius.diagram.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.sirius.diagram.util.DiagramAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support
 * Viewers. The adapters generated by this factory convert EMF adapter
 * notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The
 * adapters also support Eclipse property sheets. Note that most of the adapters
 * are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class DiagramItemProviderAdapterFactory extends DiagramAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this
     * adapter factory. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement
     * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by
     * {@link #isFactoryForType isFactoryForType}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     *
     * @generated
     */
    public DiagramItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DDiagram} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DDiagramItemProvider dDiagramItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.DDiagram}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDDiagramAdapter() {
        if (dDiagramItemProvider == null) {
            dDiagramItemProvider = new DDiagramItemProvider(this);
        }

        return dDiagramItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DSemanticDiagram} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DSemanticDiagramItemProvider dSemanticDiagramItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.DSemanticDiagram}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDSemanticDiagramAdapter() {
        if (dSemanticDiagramItemProvider == null) {
            dSemanticDiagramItemProvider = new DSemanticDiagramItemProvider(this);
        }

        return dSemanticDiagramItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.HideFilter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected HideFilterItemProvider hideFilterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.HideFilter}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createHideFilterAdapter() {
        if (hideFilterItemProvider == null) {
            hideFilterItemProvider = new HideFilterItemProvider(this);
        }

        return hideFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.HideLabelFilter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected HideLabelFilterItemProvider hideLabelFilterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.HideLabelFilter}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createHideLabelFilterAdapter() {
        if (hideLabelFilterItemProvider == null) {
            hideLabelFilterItemProvider = new HideLabelFilterItemProvider(this);
        }

        return hideLabelFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.FoldingPointFilter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FoldingPointFilterItemProvider foldingPointFilterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.FoldingPointFilter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFoldingPointFilterAdapter() {
        if (foldingPointFilterItemProvider == null) {
            foldingPointFilterItemProvider = new FoldingPointFilterItemProvider(this);
        }

        return foldingPointFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.FoldingFilter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FoldingFilterItemProvider foldingFilterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.FoldingFilter}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createFoldingFilterAdapter() {
        if (foldingFilterItemProvider == null) {
            foldingFilterItemProvider = new FoldingFilterItemProvider(this);
        }

        return foldingFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.AppliedCompositeFilters} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected AppliedCompositeFiltersItemProvider appliedCompositeFiltersItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.AppliedCompositeFilters}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAppliedCompositeFiltersAdapter() {
        if (appliedCompositeFiltersItemProvider == null) {
            appliedCompositeFiltersItemProvider = new AppliedCompositeFiltersItemProvider(this);
        }

        return appliedCompositeFiltersItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.AbsoluteBoundsFilter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AbsoluteBoundsFilterItemProvider absoluteBoundsFilterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.AbsoluteBoundsFilter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAbsoluteBoundsFilterAdapter() {
        if (absoluteBoundsFilterItemProvider == null) {
            absoluteBoundsFilterItemProvider = new AbsoluteBoundsFilterItemProvider(this);
        }

        return absoluteBoundsFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DNode} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DNodeItemProvider dNodeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.DNode}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDNodeAdapter() {
        if (dNodeItemProvider == null) {
            dNodeItemProvider = new DNodeItemProvider(this);
        }

        return dNodeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DNodeContainer} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DNodeContainerItemProvider dNodeContainerItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.DNodeContainer}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDNodeContainerAdapter() {
        if (dNodeContainerItemProvider == null) {
            dNodeContainerItemProvider = new DNodeContainerItemProvider(this);
        }

        return dNodeContainerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DNodeList} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DNodeListItemProvider dNodeListItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.DNodeList}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDNodeListAdapter() {
        if (dNodeListItemProvider == null) {
            dNodeListItemProvider = new DNodeListItemProvider(this);
        }

        return dNodeListItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DNodeListElement} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DNodeListElementItemProvider dNodeListElementItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.DNodeListElement}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDNodeListElementAdapter() {
        if (dNodeListElementItemProvider == null) {
            dNodeListElementItemProvider = new DNodeListElementItemProvider(this);
        }

        return dNodeListElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DEdge} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DEdgeItemProvider dEdgeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.DEdge}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDEdgeAdapter() {
        if (dEdgeItemProvider == null) {
            dEdgeItemProvider = new DEdgeItemProvider(this);
        }

        return dEdgeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.Dot} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DotItemProvider dotItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.Dot}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDotAdapter() {
        if (dotItemProvider == null) {
            dotItemProvider = new DotItemProvider(this);
        }

        return dotItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.GaugeSection} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected GaugeSectionItemProvider gaugeSectionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.GaugeSection}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createGaugeSectionAdapter() {
        if (gaugeSectionItemProvider == null) {
            gaugeSectionItemProvider = new GaugeSectionItemProvider(this);
        }

        return gaugeSectionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.FlatContainerStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FlatContainerStyleItemProvider flatContainerStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.FlatContainerStyle}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFlatContainerStyleAdapter() {
        if (flatContainerStyleItemProvider == null) {
            flatContainerStyleItemProvider = new FlatContainerStyleItemProvider(this);
        }

        return flatContainerStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.ShapeContainerStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ShapeContainerStyleItemProvider shapeContainerStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.ShapeContainerStyle}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createShapeContainerStyleAdapter() {
        if (shapeContainerStyleItemProvider == null) {
            shapeContainerStyleItemProvider = new ShapeContainerStyleItemProvider(this);
        }

        return shapeContainerStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.Square} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected SquareItemProvider squareItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.Square}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createSquareAdapter() {
        if (squareItemProvider == null) {
            squareItemProvider = new SquareItemProvider(this);
        }

        return squareItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.Ellipse} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected EllipseItemProvider ellipseItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.Ellipse}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createEllipseAdapter() {
        if (ellipseItemProvider == null) {
            ellipseItemProvider = new EllipseItemProvider(this);
        }

        return ellipseItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.Lozenge} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected LozengeItemProvider lozengeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.Lozenge}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createLozengeAdapter() {
        if (lozengeItemProvider == null) {
            lozengeItemProvider = new LozengeItemProvider(this);
        }

        return lozengeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.BundledImage} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BundledImageItemProvider bundledImageItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.BundledImage}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createBundledImageAdapter() {
        if (bundledImageItemProvider == null) {
            bundledImageItemProvider = new BundledImageItemProvider(this);
        }

        return bundledImageItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.WorkspaceImage} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected WorkspaceImageItemProvider workspaceImageItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.WorkspaceImage}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createWorkspaceImageAdapter() {
        if (workspaceImageItemProvider == null) {
            workspaceImageItemProvider = new WorkspaceImageItemProvider(this);
        }

        return workspaceImageItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.CustomStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CustomStyleItemProvider customStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.CustomStyle}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createCustomStyleAdapter() {
        if (customStyleItemProvider == null) {
            customStyleItemProvider = new CustomStyleItemProvider(this);
        }

        return customStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.EdgeStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected EdgeStyleItemProvider edgeStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.EdgeStyle}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createEdgeStyleAdapter() {
        if (edgeStyleItemProvider == null) {
            edgeStyleItemProvider = new EdgeStyleItemProvider(this);
        }

        return edgeStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.GaugeCompositeStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected GaugeCompositeStyleItemProvider gaugeCompositeStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.GaugeCompositeStyle}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createGaugeCompositeStyleAdapter() {
        if (gaugeCompositeStyleItemProvider == null) {
            gaugeCompositeStyleItemProvider = new GaugeCompositeStyleItemProvider(this);
        }

        return gaugeCompositeStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.BorderedStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BorderedStyleItemProvider borderedStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.BorderedStyle}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createBorderedStyleAdapter() {
        if (borderedStyleItemProvider == null) {
            borderedStyleItemProvider = new BorderedStyleItemProvider(this);
        }

        return borderedStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.Note} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected NoteItemProvider noteItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.diagram.Note}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createNoteAdapter() {
        if (noteItemProvider == null) {
            noteItemProvider = new NoteItemProvider(this);
        }

        return noteItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.FilterVariableHistory} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FilterVariableHistoryItemProvider filterVariableHistoryItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.FilterVariableHistory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFilterVariableHistoryAdapter() {
        if (filterVariableHistoryItemProvider == null) {
            filterVariableHistoryItemProvider = new FilterVariableHistoryItemProvider(this);
        }

        return filterVariableHistoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.FilterVariableValue} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FilterVariableValueItemProvider filterVariableValueItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.FilterVariableValue}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFilterVariableValueAdapter() {
        if (filterVariableValueItemProvider == null) {
            filterVariableValueItemProvider = new FilterVariableValueItemProvider(this);
        }

        return filterVariableValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.CollapseFilter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CollapseFilterItemProvider collapseFilterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.CollapseFilter}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createCollapseFilterAdapter() {
        if (collapseFilterItemProvider == null) {
            collapseFilterItemProvider = new CollapseFilterItemProvider(this);
        }

        return collapseFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.IndirectlyCollapseFilter} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected IndirectlyCollapseFilterItemProvider indirectlyCollapseFilterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.IndirectlyCollapseFilter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createIndirectlyCollapseFilterAdapter() {
        if (indirectlyCollapseFilterItemProvider == null) {
            indirectlyCollapseFilterItemProvider = new IndirectlyCollapseFilterItemProvider(this);
        }

        return indirectlyCollapseFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.BeginLabelStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BeginLabelStyleItemProvider beginLabelStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.BeginLabelStyle}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createBeginLabelStyleAdapter() {
        if (beginLabelStyleItemProvider == null) {
            beginLabelStyleItemProvider = new BeginLabelStyleItemProvider(this);
        }

        return beginLabelStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.CenterLabelStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CenterLabelStyleItemProvider centerLabelStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.CenterLabelStyle}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createCenterLabelStyleAdapter() {
        if (centerLabelStyleItemProvider == null) {
            centerLabelStyleItemProvider = new CenterLabelStyleItemProvider(this);
        }

        return centerLabelStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.EndLabelStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected EndLabelStyleItemProvider endLabelStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.EndLabelStyle}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createEndLabelStyleAdapter() {
        if (endLabelStyleItemProvider == null) {
            endLabelStyleItemProvider = new EndLabelStyleItemProvider(this);
        }

        return endLabelStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.BracketEdgeStyle} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BracketEdgeStyleItemProvider bracketEdgeStyleItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.BracketEdgeStyle}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createBracketEdgeStyleAdapter() {
        if (bracketEdgeStyleItemProvider == null) {
            bracketEdgeStyleItemProvider = new BracketEdgeStyleItemProvider(this);
        }

        return bracketEdgeStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ComputedStyleDescriptionRegistryItemProvider computedStyleDescriptionRegistryItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createComputedStyleDescriptionRegistryAdapter() {
        if (computedStyleDescriptionRegistryItemProvider == null) {
            computedStyleDescriptionRegistryItemProvider = new ComputedStyleDescriptionRegistryItemProvider(this);
        }

        return computedStyleDescriptionRegistryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.DragAndDropTarget} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DragAndDropTargetItemProvider dragAndDropTargetItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.DragAndDropTarget}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDragAndDropTargetAdapter() {
        if (dragAndDropTargetItemProvider == null) {
            dragAndDropTargetItemProvider = new DragAndDropTargetItemProvider(this);
        }

        return dragAndDropTargetItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the
     * adapter. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to
     * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (dDiagramItemProvider != null) {
            dDiagramItemProvider.dispose();
        }
        if (dSemanticDiagramItemProvider != null) {
            dSemanticDiagramItemProvider.dispose();
        }
        if (hideFilterItemProvider != null) {
            hideFilterItemProvider.dispose();
        }
        if (hideLabelFilterItemProvider != null) {
            hideLabelFilterItemProvider.dispose();
        }
        if (foldingPointFilterItemProvider != null) {
            foldingPointFilterItemProvider.dispose();
        }
        if (foldingFilterItemProvider != null) {
            foldingFilterItemProvider.dispose();
        }
        if (appliedCompositeFiltersItemProvider != null) {
            appliedCompositeFiltersItemProvider.dispose();
        }
        if (absoluteBoundsFilterItemProvider != null) {
            absoluteBoundsFilterItemProvider.dispose();
        }
        if (dNodeItemProvider != null) {
            dNodeItemProvider.dispose();
        }
        if (dNodeContainerItemProvider != null) {
            dNodeContainerItemProvider.dispose();
        }
        if (dNodeListItemProvider != null) {
            dNodeListItemProvider.dispose();
        }
        if (dNodeListElementItemProvider != null) {
            dNodeListElementItemProvider.dispose();
        }
        if (dEdgeItemProvider != null) {
            dEdgeItemProvider.dispose();
        }
        if (dotItemProvider != null) {
            dotItemProvider.dispose();
        }
        if (gaugeSectionItemProvider != null) {
            gaugeSectionItemProvider.dispose();
        }
        if (flatContainerStyleItemProvider != null) {
            flatContainerStyleItemProvider.dispose();
        }
        if (shapeContainerStyleItemProvider != null) {
            shapeContainerStyleItemProvider.dispose();
        }
        if (squareItemProvider != null) {
            squareItemProvider.dispose();
        }
        if (ellipseItemProvider != null) {
            ellipseItemProvider.dispose();
        }
        if (lozengeItemProvider != null) {
            lozengeItemProvider.dispose();
        }
        if (bundledImageItemProvider != null) {
            bundledImageItemProvider.dispose();
        }
        if (workspaceImageItemProvider != null) {
            workspaceImageItemProvider.dispose();
        }
        if (customStyleItemProvider != null) {
            customStyleItemProvider.dispose();
        }
        if (edgeStyleItemProvider != null) {
            edgeStyleItemProvider.dispose();
        }
        if (gaugeCompositeStyleItemProvider != null) {
            gaugeCompositeStyleItemProvider.dispose();
        }
        if (borderedStyleItemProvider != null) {
            borderedStyleItemProvider.dispose();
        }
        if (noteItemProvider != null) {
            noteItemProvider.dispose();
        }
        if (filterVariableHistoryItemProvider != null) {
            filterVariableHistoryItemProvider.dispose();
        }
        if (filterVariableValueItemProvider != null) {
            filterVariableValueItemProvider.dispose();
        }
        if (collapseFilterItemProvider != null) {
            collapseFilterItemProvider.dispose();
        }
        if (indirectlyCollapseFilterItemProvider != null) {
            indirectlyCollapseFilterItemProvider.dispose();
        }
        if (beginLabelStyleItemProvider != null) {
            beginLabelStyleItemProvider.dispose();
        }
        if (centerLabelStyleItemProvider != null) {
            centerLabelStyleItemProvider.dispose();
        }
        if (endLabelStyleItemProvider != null) {
            endLabelStyleItemProvider.dispose();
        }
        if (bracketEdgeStyleItemProvider != null) {
            bracketEdgeStyleItemProvider.dispose();
        }
        if (computedStyleDescriptionRegistryItemProvider != null) {
            computedStyleDescriptionRegistryItemProvider.dispose();
        }
        if (dragAndDropTargetItemProvider != null) {
            dragAndDropTargetItemProvider.dispose();
        }
    }

}
