/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.component.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.sirius.tests.sample.component.Component;

public class ComponentServices {
    public Collection<Component> getAllChildren(Component component) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        this.appendChildren(component, allChildren);
        return allChildren;
    }

    public Collection<Component> getIntersectionColumms(Component line) {
        Component ref2;
        HashSet<Component> validColumns = new HashSet<Component>();
        for (Component ref2 : line.getReferences()) {
            if (ref2.isPayload()) continue;
            validColumns.add(ref2);
        }
        for (Component ref2 : line.getReferences2()) {
            if (ref2.isPayload()) continue;
            validColumns.add(ref2);
        }
        for (Component opposite : line.getOpposites()) {
            if (opposite.isPayload()) continue;
            validColumns.add(opposite);
        }
        ref2 = line.getReference();
        if (ref2 != null && !ref2.isPayload()) {
            validColumns.add(ref2);
        }
        return validColumns;
    }

    public String getIntersectionLabel(Component line, Component column) {
        StringBuilder result = new StringBuilder();
        boolean empty = true;
        if (line.getReferences().contains((Object)column)) {
            result.append("R");
            empty = false;
        }
        if (line.getReferences2().contains((Object)column)) {
            if (empty) {
                result.append("R2");
            } else {
                result.append(", R2");
            }
            empty = false;
        }
        if (line.getOpposites().contains((Object)column)) {
            if (empty) {
                result.append("O");
            } else {
                result.append(", O");
            }
            empty = false;
        }
        if (line.getReference() == column) {
            if (empty) {
                result.append("r");
            } else {
                result.append(", r");
            }
        }
        return result.toString();
    }

    private void appendChildren(Component component, Collection<Component> allChildren) {
        for (Component child : component.getChildren()) {
            if (child.isPayload()) continue;
            allChildren.add(child);
            this.appendChildren(child, allChildren);
        }
    }
}

