/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.contribution.directeobjectreference;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.tools.api.selection.EObjectSelectionWizard;
import org.eclipse.sirius.description.contribution.ContributionPackage;
import org.eclipse.sirius.description.contribution.DirectEObjectReference;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractComboPropertySection;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DirectEObjectReferenceValuePropertySection
extends AbstractComboPropertySection {
    @Override
    protected String getDefaultLabelText() {
        return "Value";
    }

    @Override
    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + "*:";
        return labelText;
    }

    protected EReference getFeature() {
        return ContributionPackage.eINSTANCE.getDirectEObjectReference_Value();
    }

    @Override
    protected Object getFeatureValue(int index) {
        return this.getFeatureValueAt(index);
    }

    @Override
    protected boolean isEqual(int index) {
        boolean isEqual = false;
        isEqual = this.getFeatureValueAt(index) == null ? this.eObject.eGet((EStructuralFeature)this.getFeature()) == null : this.getFeatureValueAt(index).equals(this.eObject.eGet((EStructuralFeature)this.getFeature()));
        return isEqual;
    }

    protected Object getFeatureValueAt(int index) {
        List<?> values = this.getChoiceOfValues();
        if (values.size() < index || values.size() == 0 || index == -1) {
            return null;
        }
        return values.get(index);
    }

    @Override
    protected List<?> getChoiceOfValues() {
        ArrayList values = Collections.emptyList();
        List<IItemPropertyDescriptor> propertyDescriptors = this.getDescriptors();
        for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if ((EStructuralFeature)propertyDescriptor.getFeature((Object)this.eObject) != this.getFeature()) continue;
            values = new ArrayList(propertyDescriptor.getChoiceOfValues((Object)this.eObject));
        }
        if (Movida.isEnabled()) {
            ArrayList elementsInScope = Lists.newArrayList();
            ViewpointResourceHandler vrh = ((ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance()).getSiriusResourceHandler();
            ResourceSet rs = this.eObject.eResource().getResourceSet();
            for (Resource res : rs.getResources()) {
                if (!vrh.handles(res.getURI())) continue;
                for (Viewpoint vp : vrh.collectViewpointDefinitions(res)) {
                    Iterables.addAll((Collection)elementsInScope, (Iterable)AllContents.of((EObject)vp, (boolean)true));
                }
            }
            values = elementsInScope;
        }
        return values;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.nameLabel.setFont(SiriusEditor.getFontRegistry().get("required"));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(90, 0);
        data.top = new FormAttachment(0, 4);
        this.combo.setLayoutData((Object)data);
        this.combo.setEnabled(false);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.combo, -25);
        data.top = new FormAttachment((Control)this.combo, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        Button selectionButton = this.getWidgetFactory().createButton(this.composite, "Select", 8);
        data = new FormData();
        data.left = new FormAttachment(90, 5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.combo, 0, 0x1000000);
        selectionButton.setLayoutData((Object)data);
        selectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DirectEObjectReferenceValuePropertySection.this.eObject instanceof DirectEObjectReference) {
                    ArrayList roots = Lists.newArrayList();
                    roots.addAll(new EObjectQuery(DirectEObjectReferenceValuePropertySection.this.eObject).getAvailableViewpointsInResourceSet());
                    AdapterFactory af = SiriusEditPlugin.getPlugin().getItemProvidersAdapterFactory();
                    TreeItemWrapper wrapper = this.buildWrapper(roots);
                    EObjectSelectionWizard wizard = new EObjectSelectionWizard("Selection", "Please select an object to reference", null, wrapper, af);
                    wizard.setMany(Boolean.FALSE.booleanValue());
                    WizardDialog dlg = new WizardDialog(DirectEObjectReferenceValuePropertySection.this.composite.getShell(), (IWizard)wizard);
                    if (dlg.open() == 0) {
                        EObject value = wizard.getSelectedEObject();
                        EditingDomain editingDomain = ((IEditingDomainProvider)DirectEObjectReferenceValuePropertySection.this.getPart()).getEditingDomain();
                        editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)DirectEObjectReferenceValuePropertySection.this.eObject, (Object)DirectEObjectReferenceValuePropertySection.this.getFeature(), (Object)value));
                    }
                }
            }

            private TreeItemWrapper buildWrapper(List<EObject> roots) {
                TreeItemWrapper result = new TreeItemWrapper(null, null);
                for (EObject root : roots) {
                    this.addElementsAndChildren(result, root);
                }
                return result;
            }

            private void addElementsAndChildren(TreeItemWrapper parent, EObject element) {
                TreeItemWrapper elementWrapper = new TreeItemWrapper((Object)element, parent);
                parent.getChildren().add(elementWrapper);
                for (EObject child : element.eContents()) {
                    this.addElementsAndChildren(elementWrapper, child);
                }
            }
        });
    }
}

