/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.EditingDomainUndoContext;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.PlatformUI;

public class RestoreToLastSavePointListener
implements ResourceSyncClient,
IOperationHistoryListener {
    private IUndoableOperation marker;
    private Session session;

    public RestoreToLastSavePointListener(Session session) {
        this.session = session;
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)session.getTransactionalEditingDomain()).registerClient((ResourceSyncClient)this);
    }

    public void returnToSyncState() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (this.isAllowedToReturnToSyncState()) {
            if (this.canPerformTheRevertFromOperationHistory()) {
                this.returnToSyncStateFromOperationHistory();
            } else {
                this.reloadTheResources();
            }
        }
    }

    private void reloadTheResources() {
        ArrayList<ResourceSyncClient.ResourceStatusChange> changes = new ArrayList<ResourceSyncClient.ResourceStatusChange>();
        for (Resource currentResource : this.getModifiedResources()) {
            changes.add(new ResourceSyncClient.ResourceStatusChange(currentResource, ResourceSetSync.ResourceStatus.CHANGES_CANCELED, ResourceSetSync.ResourceStatus.CHANGED));
        }
        if (this.session instanceof ResourceSyncClient) {
            ((ResourceSyncClient)this.session).statusesChanged(changes);
        }
    }

    private Collection<Resource> getModifiedResources() {
        ArrayList<Resource> changed = new ArrayList<Resource>();
        for (Resource currentResource : this.session.getAllSessionResources()) {
            if (!currentResource.isModified()) continue;
            changed.add(currentResource);
        }
        for (Resource currentResource : this.session.getSemanticResources()) {
            if (!currentResource.isModified()) continue;
            changed.add(currentResource);
        }
        if (this.session instanceof DAnalysisSessionEObject) {
            for (Resource currentResource : ((DAnalysisSessionEObject)this.session).getControlledResources()) {
                if (!currentResource.isModified()) continue;
                changed.add(currentResource);
            }
        }
        return changed;
    }

    private void returnToSyncStateFromOperationHistory() {
        try {
            IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
            IUndoContext undoCtx = this.getUndoContext();
            while (operationHistory != null && operationHistory.canUndo(undoCtx) && this.session.getStatus() != SessionStatus.SYNC) {
                IUndoableOperation toUndo = operationHistory.getUndoOperation(undoCtx);
                operationHistory.undoOperation(toUndo, (IProgressMonitor)new NullProgressMonitor(), null);
                if (this.marker == toUndo) break;
            }
            this.setResourcesBackToSync();
        }
        catch (ExecutionException e) {
            this.reloadTheResources();
            String sessionLabel = SiriusEditPlugin.getPlugin().getUiCallback().getSessionNameToDisplayWhileSaving(this.session);
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.RestoreToLastSavePointListener_errorModifiedResourcesReloaded, sessionLabel), (Exception)((Object)e));
        }
    }

    private void setResourcesBackToSync() {
        if (this.session instanceof ResourceSyncClient) {
            for (Resource currentResource : this.getModifiedResources()) {
                currentResource.setModified(false);
            }
        }
    }

    private IUndoContext getUndoContext() {
        Object undoCtx = this.session.getTransactionalEditingDomain() != null ? (this.session.getTransactionalEditingDomain().getCommandStack() instanceof IWorkspaceCommandStack ? ((IWorkspaceCommandStack)this.session.getTransactionalEditingDomain().getCommandStack()).getDefaultUndoContext() : new EditingDomainUndoContext((EditingDomain)this.session.getTransactionalEditingDomain())) : new ObjectUndoContext((Object)this);
        return undoCtx;
    }

    public void dispose() {
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
        Option resourceSetSync = ResourceSetSync.getResourceSetSync((TransactionalEditingDomain)this.session.getTransactionalEditingDomain());
        if (resourceSetSync.some()) {
            ((ResourceSetSync)resourceSetSync.get()).unregisterClient((ResourceSyncClient)this);
        }
        this.session = null;
        this.marker = null;
    }

    public void statusChanged(Resource resource, ResourceSetSync.ResourceStatus oldStatus, ResourceSetSync.ResourceStatus newStatus) {
    }

    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.session != null && SessionStatus.SYNC == this.session.getStatus()) {
            this.marker = null;
        }
    }

    public void historyNotification(OperationHistoryEvent event) {
        if (this.session != null && SessionStatus.DIRTY == this.session.getStatus() && this.marker == null) {
            this.marker = event.getOperation();
        }
    }

    private boolean canPerformTheRevertFromOperationHistory() {
        IUndoContext undoContext = this.getUndoContext();
        IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
        IUndoableOperation[] iUndoableOperations = operationHistory.getUndoHistory(undoContext);
        return iUndoableOperations.length < operationHistory.getLimit(undoContext);
    }

    public boolean isAllowedToReturnToSyncState() {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        return preferenceStore != null && preferenceStore.getBoolean(SiriusUIPreferencesKeys.PREF_RELOAD_ON_LAST_EDITOR_CLOSE.name());
    }
}

