/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.internal.session.SaveSessionRunnable;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.progress.IJobRunnable;

public class SessionSaveable
extends Saveable {
    private Session session;

    public SessionSaveable(Session session) {
        this.session = session;
    }

    public void doSave(IProgressMonitor monitor) {
        new SaveSessionRunnable(this.session).run(monitor);
    }

    public IJobRunnable doSave(IProgressMonitor monitor, IShellProvider shellProvider) throws CoreException {
        return new SaveSessionRunnable(this.session);
    }

    public String getName() {
        return SiriusEditPlugin.getPlugin().getUiCallback().getSessionNameToDisplayWhileSaving(this.session);
    }

    public ImageDescriptor getImageDescriptor() {
        return SiriusEditPlugin.Implementation.getBundledImageDescriptor("icons/obj16/SessionResourceFile.gif");
    }

    public String getToolTipText() {
        String tooltip = null;
        if (this.session != null && this.session.getSessionResource() != null) {
            URI uri = this.session.getSessionResource().getURI();
            tooltip = uri.isPlatform() ? uri.toPlatformString(true) : (uri.isFile() ? uri.toFileString() : uri.toString());
        }
        return tooltip;
    }

    public boolean isDirty() {
        if (this.session != null) {
            return SessionStatus.DIRTY == this.session.getStatus();
        }
        return false;
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SessionSaveable other = (SessionSaveable)((Object)obj);
        return !(this.session == null ? other.session != null : !this.session.equals(other.session));
    }

    public boolean show(IWorkbenchPage page) {
        IEditingSession uiSession;
        if (this.session != null && page != null && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) != null && !uiSession.getEditors().isEmpty()) {
            DialectEditor dialectEditor = uiSession.getEditors().iterator().next();
            IWorkbenchPartReference reference = page.getReference((IWorkbenchPart)dialectEditor);
            if (reference != null) {
                page.activate((IWorkbenchPart)dialectEditor);
                return true;
            }
            if (dialectEditor instanceof IViewPart) {
                IViewPart viewPart = (IViewPart)dialectEditor;
                try {
                    page.showView(viewPart.getViewSite().getId(), viewPart.getViewSite().getSecondaryId(), 1);
                }
                catch (PartInitException partInitException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Session getSession() {
        return this.session;
    }
}

