/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.viewpoint;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ViewpointSelectionDialog
extends TitleAreaDialog {
    private static final String VIEWPOINT_SELECTION_SHELL_TITLE = Messages.ViewpointSelectionDialog_title;
    private static final String VIEWPOINT_SELECTION_TITLE = Messages.ViewpointSelectionDialog_dialogTitle;
    private static final String VIEWPOINT_SELECTION_MESSAGE = Messages.ViewpointSelectionDialog_selectionMessage;
    private CheckboxTableViewer table;
    private final Map<Viewpoint, Boolean> selection;
    private final List<Item> input;

    public ViewpointSelectionDialog(Shell parentShell, Map<Viewpoint, Boolean> selection) {
        super(parentShell);
        this.setShellStyle(68720);
        TreeMap newSelection = Maps.newTreeMap((Comparator)new ViewpointRegistry.ViewpointComparator());
        newSelection.putAll((Map)Preconditions.checkNotNull(selection));
        this.selection = newSelection;
        this.input = this.computeItemList();
        this.setBlockOnOpen(true);
    }

    public Map<Viewpoint, Boolean> getSelection() {
        return this.selection;
    }

    private List<Item> computeItemList() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.selection.keySet(), (Function)new Function<Viewpoint, Item>(){

            public Item apply(Viewpoint from) {
                return new Item(from);
            }
        }));
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(VIEWPOINT_SELECTION_TITLE);
        this.setMessage(VIEWPOINT_SELECTION_MESSAGE);
        Shell shell = parent.getShell();
        shell.setText(VIEWPOINT_SELECTION_SHELL_TITLE);
        shell.pack();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.table = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.table, (int)2);
        this.table.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setContentProvider((IContentProvider)new TableContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.table.addCheckStateListener((ICheckStateListener)new TableCheckStateListener());
        this.table.setInput(this.input);
        for (Item item : this.input) {
            item.computeState();
        }
        return composite;
    }

    private Map<String, Collection<String>> getMissingDependencies() {
        Set selected = Maps.filterValues(this.selection, (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).keySet();
        HashMultimap result = HashMultimap.create();
        for (Viewpoint viewpoint : selected) {
            for (RepresentationExtensionDescription extension : new ViewpointQuery(viewpoint).getAllRepresentationExtensionDescriptions()) {
                String extended = extension.getViewpointURI();
                final Pattern pattern = Pattern.compile(extended);
                if (Iterables.any(selected, (Predicate)new Predicate<Viewpoint>(){

                    public boolean apply(Viewpoint vp) {
                        Option uri = new ViewpointQuery(vp).getViewpointURI();
                        if (uri.some()) {
                            Matcher matcher = pattern.matcher(((URI)uri.get()).toString());
                            return matcher.matches();
                        }
                        return false;
                    }
                })) continue;
                result.put((Object)viewpoint.getName(), (Object)extended.trim().replaceFirst("^viewpoint:/[^/]+/", ""));
            }
        }
        return result.asMap();
    }

    private static String getMissingDependenciesErrorMessage(Map<String, Collection<String>> missingDependencies) {
        Function<Collection<String>, String> toStringList = new Function<Collection<String>, String>(){

            public String apply(Collection<String> from) {
                return Joiner.on((String)", ").join(from);
            }
        };
        return Joiner.on((String)"\n").join(Iterables.transform(missingDependencies.entrySet(), (Function)new Function<Map.Entry<String, Collection<String>>, String>((Function)toStringList){
            private final /* synthetic */ Function val$toStringList;
            {
                this.val$toStringList = function;
            }

            public String apply(Map.Entry<String, Collection<String>> entry) {
                return MessageFormat.format(Messages.ViewpointSelection_missingDependencies_requirements, entry.getKey(), this.val$toStringList.apply(entry.getValue()));
            }
        }));
    }

    private final class Item {
        private final Viewpoint viewpoint;

        public Item(Viewpoint vp) {
            this.viewpoint = vp;
        }

        public String getLabel() {
            return new IdentifiedElementQuery((IdentifiedElement)this.viewpoint).getLabel();
        }

        public void onChecked() {
            ViewpointSelectionDialog.this.selection.put(this.viewpoint, true);
        }

        public void onUnchecked() {
            ViewpointSelectionDialog.this.selection.put(this.viewpoint, false);
        }

        public String toString() {
            return this.getLabel();
        }

        public Viewpoint getViewpoint() {
            return this.viewpoint;
        }

        public void computeState() {
            ViewpointSelectionDialog.this.table.setChecked((Object)this, this.isSelected());
        }

        private boolean isSelected() {
            return Boolean.TRUE.equals(ViewpointSelectionDialog.this.selection.get(this.viewpoint));
        }
    }

    private final class TableCheckStateListener
    implements ICheckStateListener {
        private TableCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getElement() instanceof Item) {
                Item item = (Item)event.getElement();
                if (event.getChecked()) {
                    item.onChecked();
                } else {
                    item.onUnchecked();
                }
                Map missingDependencies = ViewpointSelectionDialog.this.getMissingDependencies();
                if (!missingDependencies.isEmpty()) {
                    String message = ViewpointSelectionDialog.getMissingDependenciesErrorMessage(missingDependencies);
                    ViewpointSelectionDialog.this.setErrorMessage(message);
                } else {
                    ViewpointSelectionDialog.this.setErrorMessage(null);
                }
                ViewpointSelectionDialog.this.getButton(0).setEnabled(missingDependencies.isEmpty());
            }
        }
    }

    private final class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List && Iterables.all((Iterable)((List)inputElement), (Predicate)Predicates.instanceOf(Item.class))) {
                List topItems = (List)inputElement;
                return topItems.toArray();
            }
            return null;
        }
    }

    private final class TableLabelProvider
    extends ColumnLabelProvider {
        private TableLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptor desc;
            Item item = (Item)element;
            Image viewpointImage = null;
            Viewpoint vp = item.getViewpoint();
            if (vp.getIcon() != null && vp.getIcon().length() > 0 && (desc = SiriusEditPlugin.Implementation.findImageDescriptor(vp.getIcon())) != null) {
                viewpointImage = SiriusEditPlugin.getPlugin().getImage(desc);
            }
            if (viewpointImage == null) {
                viewpointImage = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.getPlugin().getItemImageDescriptor(vp));
            }
            if (!ViewpointRegistry.getInstance().isFromPlugin(vp)) {
                ImageDescriptor decoratorDescriptor = SiriusEditPlugin.Implementation.getBundledImageDescriptor("icons/full/decorator/folder_close.gif");
                viewpointImage = SiriusEditPlugin.getPlugin().getImage((ImageDescriptor)new DecorationOverlayIcon(viewpointImage, decoratorDescriptor, 2));
            }
            return viewpointImage;
        }

        public String getText(Object element) {
            Item item = (Item)element;
            return item.getLabel();
        }

        public String getToolTipText(Object element) {
            String doc;
            Item item = (Item)element;
            String toolTip = "";
            Viewpoint viewpoint = item.getViewpoint();
            Resource resource = viewpoint.eResource();
            if (resource != null) {
                toolTip = resource.getURI().toString();
            }
            if (viewpoint.getEndUserDocumentation() != null && !(doc = viewpoint.getEndUserDocumentation().trim()).isEmpty()) {
                if (!toolTip.isEmpty()) {
                    toolTip = String.valueOf(toolTip) + "\n\n";
                }
                toolTip = String.valueOf(toolTip) + doc;
            }
            return toolTip;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 200;
        }

        public int getToolTipStyle(Object object) {
            return 8;
        }
    }
}

