/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.action;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.command.DeleteRepresentationCommand;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DeleteRepresentationAction
extends Action {
    private Collection<DRepresentation> selectedRepresentations;

    public DeleteRepresentationAction(Collection<DRepresentation> representations) {
        super(Messages.DeleteRepresentationAction_name, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/delete.gif"));
        this.selectedRepresentations = representations;
        if (!this.isValidSelection()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        Map<DRepresentation, Session> dRepresentation2Session = this.getRepresentations();
        final Map<Session, Set<DRepresentation>> session2DRepresentations = this.getSession2DRepresentations(dRepresentation2Session);
        String deleteRepresenationDialogTitle = Messages.DeleteRepresentationAction_title;
        String deletionMessage = Messages.DeleteRepresentationAction_message;
        if (dRepresentation2Session.size() >= 2) {
            deleteRepresenationDialogTitle = Messages.DeleteRepresentationAction_title_plural;
            deletionMessage = Messages.DeleteRepresentationAction_message_plural;
        }
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean deletionConfirmation = MessageDialog.openConfirm((Shell)shell, (String)deleteRepresenationDialogTitle, (String)deletionMessage);
            if (deletionConfirmation) {
                ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
                IRunnableWithProgress editorClosingRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(Messages.DeleteRepresentationAction_closeEditorsTask, 1);
                            for (Map.Entry entry : session2DRepresentations.entrySet()) {
                                Session session = (Session)entry.getKey();
                                Set dRepresentations = (Set)entry.getValue();
                                IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
                                if (editingSession != null) {
                                    for (DRepresentation dRepresentation : dRepresentations) {
                                        DialectEditor editor = editingSession.getEditor(dRepresentation);
                                        if (editor == null) continue;
                                        DialectUIManager.INSTANCE.closeEditor(editor, false);
                                        editingSession.detachEditor(editor);
                                    }
                                }
                                DeleteRepresentationCommand deleteDRepresentationsCmd = new DeleteRepresentationCommand(session, dRepresentations);
                                session.getTransactionalEditingDomain().getCommandStack().execute((Command)deleteDRepresentationsCmd);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, editorClosingRunnable, null);
                IRunnableWithProgress representationsDeletionRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            String taskName = session2DRepresentations.size() > 1 ? Messages.DeleteRepresentationAction_deleteRepresentationTask_plural : Messages.DeleteRepresentationAction_deleteRepresentationTask;
                            monitor.beginTask(taskName, session2DRepresentations.size());
                            for (Map.Entry entry : session2DRepresentations.entrySet()) {
                                Session session = (Session)entry.getKey();
                                Set dRepresentations = (Set)entry.getValue();
                                DeleteRepresentationCommand deleteDRepresentationsCmd = new DeleteRepresentationCommand(session, dRepresentations);
                                session.getTransactionalEditingDomain().getCommandStack().execute((Command)deleteDRepresentationsCmd);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().run(true, false, representationsDeletionRunnable);
            }
        }
        catch (InvocationTargetException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private Map<DRepresentation, Session> getRepresentations() {
        HashMap<DRepresentation, Session> representations = new HashMap<DRepresentation, Session>();
        for (DRepresentation dRepresentation : this.selectedRepresentations) {
            EObjectQuery eObjectQuery = new EObjectQuery((EObject)dRepresentation);
            Session currentSession = eObjectQuery.getSession();
            if (currentSession == null) continue;
            representations.put(dRepresentation, currentSession);
        }
        return representations;
    }

    private Map<Session, Set<DRepresentation>> getSession2DRepresentations(Map<DRepresentation, Session> dRepresentation2Session) {
        HashMap<Session, Set<DRepresentation>> session2DRepresentations = new HashMap<Session, Set<DRepresentation>>();
        for (Map.Entry<DRepresentation, Session> entry : dRepresentation2Session.entrySet()) {
            DRepresentation dRepresentation = entry.getKey();
            Session session = entry.getValue();
            HashSet<DRepresentation> dRepresentations = (HashSet<DRepresentation>)session2DRepresentations.get(session);
            if (dRepresentations == null) {
                dRepresentations = new HashSet<DRepresentation>();
                session2DRepresentations.put(session, dRepresentations);
            }
            dRepresentations.add(dRepresentation);
        }
        return session2DRepresentations;
    }

    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (isEnabled) {
            for (DRepresentation dRepresentation : this.selectedRepresentations) {
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)dRepresentation);
                if (permissionAuthority.canDeleteInstance((EObject)dRepresentation)) continue;
                isEnabled = false;
                break;
            }
        }
        return isEnabled;
    }

    private boolean isValidSelection() {
        boolean anyInvalidDelete = Iterables.any(this.selectedRepresentations, (Predicate)new Predicate<DRepresentation>(){

            public boolean apply(DRepresentation input) {
                IPermissionAuthority permissionAuthority;
                EObject container = input.eContainer();
                return container instanceof DRepresentationContainer && (permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container)) != null && !permissionAuthority.canDeleteInstance((EObject)input);
            }
        });
        return !anyInvalidDelete;
    }
}

