/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator.sorter;

import java.text.Collator;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.api.views.common.item.AnalysisResourceItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ProjectDependenciesItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ResourcesFolderItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointsFolderItem;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class CommonItemSorter
extends ViewerSorter {
    public CommonItemSorter() {
    }

    public CommonItemSorter(Collator collator) {
        super(collator);
    }

    public int category(Object element) {
        int category = 9;
        if (element instanceof ProjectDependenciesItem) {
            category = 1;
        } else if (element instanceof ResourcesFolderItem) {
            category = 2;
        } else if (element instanceof ViewpointsFolderItem) {
            category = 3;
        } else if (element instanceof AnalysisResourceItem) {
            category = 4;
        } else if (element instanceof IResource || element instanceof Resource) {
            Session session;
            category = 5;
            if (element instanceof Resource && (session = SessionManager.INSTANCE.getSession((Resource)element)) instanceof DAnalysisSessionEObject && ((DAnalysisSessionEObject)session).getControlledResources().contains(element)) {
                category = 6;
            }
        } else if (element instanceof DRepresentation) {
            category = 7;
        } else if (element instanceof EObject) {
            category = 8;
        }
        return category;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = super.compare(viewer, e1, e2);
        if (e1 instanceof RepresentationDescriptionItem && e2 instanceof RepresentationDescriptionItem) {
            result = this.compareRepresentationDescriptions(viewer, (RepresentationDescriptionItem)e1, (RepresentationDescriptionItem)e2);
        }
        return result;
    }

    private int compareRepresentationDescriptions(Viewer viewer, RepresentationDescriptionItem e1, RepresentationDescriptionItem e2) {
        int result = super.compare(viewer, (Object)e1, (Object)e2);
        if (e1.getWrappedObject() instanceof RepresentationDescription && e2.getWrappedObject() instanceof RepresentationDescription) {
            RepresentationDescription desc1 = (RepresentationDescription)e1.getWrappedObject();
            RepresentationDescription desc2 = (RepresentationDescription)e2.getWrappedObject();
            result = CommonItemSorter.compareRepresentationDescriptions(desc1, desc2);
        }
        return result;
    }

    public static int compareRepresentationDescriptions(RepresentationDescription e1, RepresentationDescription e2) {
        int result = Collator.getInstance().compare(e1.getName(), e2.getName());
        if (e1 != null && e2 != null && e1.eClass() != null && !e1.eClass().equals(e2.eClass())) {
            result = Collator.getInstance().compare(e1.eClass().getName(), e2.eClass().getName());
            EClass e1TypeToCompare = CommonItemSorter.getRepresentationType(e1);
            EClass e2TypeToCompare = CommonItemSorter.getRepresentationType(e2);
            if (e1TypeToCompare != null && e2TypeToCompare != null && !e1TypeToCompare.equals(e2TypeToCompare)) {
                result = Collator.getInstance().compare(e1TypeToCompare.getName(), e2TypeToCompare.getName());
            }
        }
        return result;
    }

    private static EClass getRepresentationType(RepresentationDescription description) {
        return CommonItemSorter.lookForRepresentationDescriptionType(description.eClass());
    }

    private static EClass lookForRepresentationDescriptionType(EClass eClass) {
        EClass repDescType = null;
        if (eClass.getESuperTypes().contains((Object)DescriptionPackage.eINSTANCE.getRepresentationDescription())) {
            repDescType = eClass;
        } else if (eClass.getEAllSuperTypes().contains((Object)DescriptionPackage.eINSTANCE.getRepresentationDescription())) {
            for (EClass superType : eClass.getESuperTypes()) {
                EClass t = CommonItemSorter.lookForRepresentationDescriptionType(superType);
                if (t == null) continue;
                repDescType = t;
                break;
            }
        }
        return repDescType;
    }
}

