/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.sirius.ui.tools.internal.views.common.action.RenameRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class RenameActionHandler
extends Action {
    private ISelectionProvider selectionProvider;

    public RenameActionHandler(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RenameActionHandler.this.setEnabled(!RenameActionHandler.this.getRepresentations().isEmpty());
            }
        });
    }

    private Collection<DRepresentation> getRepresentations() {
        List selections;
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && (selections = ((IStructuredSelection)selection).toList()) != null && !selections.isEmpty()) {
            LinkedHashSet selectedRepresentations = Sets.newLinkedHashSet();
            Iterables.addAll((Collection)selectedRepresentations, (Iterable)Iterables.filter((Iterable)selections, DRepresentation.class));
            Iterables.addAll((Collection)selectedRepresentations, (Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)selections, RepresentationItemImpl.class), RepresentationItemImpl.REPRESENTATION_ITEM_TO_REPRESENTATION));
            return selectedRepresentations;
        }
        return Collections.emptyList();
    }

    public void run() {
        RenameRepresentationAction renameAction = new RenameRepresentationAction(this.getRepresentations());
        renameAction.run();
    }
}

