/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.business.internal.permission.ReadOnlyPermissionAuthority;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.tests.api.tools.DnDModel;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.api.TreeTestCase;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.api.command.DTreeItemExpansionChangeCommand;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.DTreeItemDropListener;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.junit.Assert;

public class TreeItemDragAndDropToolTest
extends TreeTestCase
implements DnDModel {
    private DTree tree;
    private EObject semanticModel;
    private EStructuralFeature wageFeature;
    private EStructuralFeature nameFeature;
    private CustomDTreeItemDropListener dropListener;
    private DTreeEditor editor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.copyFilesToTestProject("org.eclipse.sirius.tests.junit", "/data/tree/unit/dnd/vp926/", new String[]{"company1.xmi", "vp926.aird", "vp926.ecore", "vp926.odesign"});
        this.genericSetUp("DesignerTestProject/company1.xmi", "DesignerTestProject/vp926.odesign", "DesignerTestProject/vp926.aird");
        Iterator iterator = this.getRepresentations("Tree With DnD").iterator();
        while (iterator.hasNext() && this.tree == null) {
            DRepresentation next = (DRepresentation)iterator.next();
            if (!next.getName().equals("dnd1")) continue;
            this.tree = (DTree)next;
        }
        this.editor = (DTreeEditor)DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.tree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.dropListener = new CustomDTreeItemDropListener(this.editor.getViewer(), this.session.getTransactionalEditingDomain(), this.getCommandFactory(), this.accessor);
        this.semanticModel = this.tree.getTarget();
        this.wageFeature = ((EClass)this.semanticModel.eClass().getEPackage().getEClassifier("Employee")).getEStructuralFeature("wage");
        this.nameFeature = ((EClass)this.semanticModel.eClass().getEPackage().getEClassifier("NamedEntity")).getEStructuralFeature("name");
    }

    public void testDnDWithSingleSelection() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(0);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)itemRichCompany1, true);
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.applyUndo();
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    public void testDnDWithMultipleSelection() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        EObject richEmployee2 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(0);
        EObject richEmployee3 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(1);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(4);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2000, (Object)richEmployee2.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        DTreeItem itemEmploye2 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee2);
        DTreeItem itemEmploye3 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee3);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        itemSources.add(itemEmploye2);
        itemSources.add(itemEmploye3);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)itemRichCompany1, true);
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2500, (Object)richEmployee2.eGet(this.wageFeature));
        this.applyUndo();
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2000, (Object)richEmployee2.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2500, (Object)richEmployee2.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    public void testDnDDirectlyOnTree() {
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(4);
        String oldDepartmentName = (String)richDepartment1.eGet(this.nameFeature);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemRichCompany1);
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)this.tree, true);
        Assert.assertEquals((Object)(String.valueOf(oldDepartmentName) + "_DROPPED"), (Object)richDepartment1.eGet(this.nameFeature));
        this.applyUndo();
        Assert.assertEquals((Object)oldDepartmentName, (Object)richDepartment1.eGet(this.nameFeature));
        this.applyRedo();
        Assert.assertEquals((Object)(String.valueOf(oldDepartmentName) + "_DROPPED"), (Object)richDepartment1.eGet(this.nameFeature));
    }

    public void testDnDWithFalseToolPrecondition() {
        EObject poorEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(3)).eContents().get(0);
        EObject richEmployee2 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        EObject poorDepartment1 = (EObject)this.semanticModel.eContents().get(2);
        Assert.assertEquals((Object)2000, (Object)poorEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2000, (Object)richEmployee2.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, poorEmployee1);
        DTreeItem itemEmploye2 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee2);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        itemSources.add(itemEmploye2);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, poorDepartment1);
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)itemRichCompany1, false);
    }

    public void testDnDWithPermissionAuthority() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(0);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        ((ReadOnlyPermissionAuthority)PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)itemEmploye1)).activate();
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)itemRichCompany1, false);
    }

    public void _testDnDFromOneEditorToAnOther() throws IOException {
        DTree tree2 = null;
        Iterator iterator = this.getRepresentations("Tree With DnD").iterator();
        while (iterator.hasNext() && tree2 == null) {
            DRepresentation next = (DRepresentation)iterator.next();
            if (!next.getName().equals("dnd2")) continue;
            tree2 = (DTree)next;
        }
        DTreeEditor editor2 = (DTreeEditor)DialectUIManager.INSTANCE.openEditor(this.session, tree2, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        ModelUtils.load((URI)URI.createPlatformPluginURI((String)"company2.xmi", (boolean)true), (ResourceSet)this.session.getTransactionalEditingDomain().getResourceSet());
        DTreeItemDropListener dropListener2 = new DTreeItemDropListener(editor2.getViewer(), this.session.getTransactionalEditingDomain(), this.getCommandFactory(), this.accessor);
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getRepresentationElementWithName((DRepresentation)tree2, "Juridiction");
        this.applyDnDTool(dropListener2, itemSources, (DTreeItemContainer)itemRichCompany1, true);
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    public void testDnDFromModelContentViewToTreeEditorWithSingleSelection() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(0);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        LinkedHashSet semanticSources = Sets.newLinkedHashSet();
        semanticSources.add(richEmployee1);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.applyDnDTool(this.dropListener, semanticSources, (DTreeItemContainer)itemRichCompany1, true);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.applyUndo();
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    public void testDnDFromModelContentViewToTreeEditorWithMultipleSelection() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        EObject richEmployee2 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(0);
        EObject richEmployee3 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(1);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(4);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2000, (Object)richEmployee2.eGet(this.wageFeature));
        LinkedHashSet semanticSources = Sets.newLinkedHashSet();
        semanticSources.add(richEmployee1);
        semanticSources.add(richEmployee2);
        semanticSources.add(richEmployee3);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.applyDnDTool(this.dropListener, semanticSources, (DTreeItemContainer)itemRichCompany1, true);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        DTreeItem itemEmploye2 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee2);
        itemSources.add(itemEmploye1);
        itemSources.add(itemEmploye2);
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2500, (Object)richEmployee2.eGet(this.wageFeature));
        this.applyUndo();
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2000, (Object)richEmployee2.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2500, (Object)richEmployee2.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    public void testDnDWithDropAfter() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(0);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(1);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.dropListener.setCurrentLocation(2);
        this.checkPrecedingSiblingsValue(this.dropListener, itemSources, (DTreeItem)itemRichCompany1.getOwnedTreeItems().get(1), (Collection<DTreeItem>)itemRichCompany1.getOwnedTreeItems());
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)itemRichCompany1.getOwnedTreeItems().get(1), true);
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.applyUndo();
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    public void testDnDWithDropBefore() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(0);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(1);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.dropListener.setCurrentLocation(1);
        this.checkPrecedingSiblingsValue(this.dropListener, itemSources, (DTreeItem)itemRichCompany1.getOwnedTreeItems().get(1), itemRichCompany1.getOwnedTreeItems().subList(0, 1));
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)itemRichCompany1.getOwnedTreeItems().get(1), true);
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.applyUndo();
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    public void testPrecedingSiblingsValues() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(0);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(1);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.checkPrecedingSiblingsValue(this.dropListener, itemSources, itemRichCompany1, (Collection<DTreeItem>)itemRichCompany1.getOwnedTreeItems());
    }

    public void testDnDWithTwoElementsSelection() {
        EObject richEmployee1 = (EObject)((EObject)this.semanticModel.eContents().get(1)).eContents().get(1);
        EObject richEmployee2 = (EObject)((EObject)this.semanticModel.eContents().get(0)).eContents().get(0);
        EObject richDepartment1 = (EObject)this.semanticModel.eContents().get(4);
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2000, (Object)richEmployee2.eGet(this.wageFeature));
        DTreeItem itemEmploye1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee1);
        DTreeItem itemEmploye2 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richEmployee2);
        LinkedHashSet itemSources = Sets.newLinkedHashSet();
        itemSources.add(itemEmploye1);
        itemSources.add(itemEmploye2);
        DTreeItem itemRichCompany1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, richDepartment1);
        this.applyDnDTool(this.dropListener, itemSources, (DTreeItemContainer)itemRichCompany1, true);
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2500, (Object)richEmployee2.eGet(this.wageFeature));
        this.applyUndo();
        this.applyUndo();
        Assert.assertEquals((Object)2000, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2000, (Object)richEmployee2.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, false);
        this.applyRedo();
        this.applyRedo();
        Assert.assertEquals((Object)2500, (Object)richEmployee1.eGet(this.wageFeature));
        Assert.assertEquals((Object)2500, (Object)richEmployee2.eGet(this.wageFeature));
        this.checkDTreeItemContainment(itemSources, (DTreeItemContainer)itemRichCompany1, true);
    }

    private void applyDnDTool(DTreeItemDropListener dndListener, Set<EObject> itemSources, DTreeItemContainer targetContainer, boolean shouldBeValidDrop) {
        StructuredSelection selection = new StructuredSelection(itemSources.toArray());
        LocalSelectionTransfer.getInstance().setSelection((ISelection)selection);
        boolean isValidDrop = dndListener.validateDrop((Object)targetContainer, 0, null);
        Assert.assertEquals((String)"The validation of the DnD operation did not occur as expected ", (Object)shouldBeValidDrop, (Object)isValidDrop);
        InterpreterUtil.getInterpreter((EObject)this.semanticModel).setModelAccessor(this.accessor);
        if (isValidDrop) {
            dndListener.performDrop(null);
        }
        if (targetContainer instanceof DTreeItem) {
            DTreeItem dTreeItem = (DTreeItem)targetContainer;
            TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
            GlobalContext globalContext = new GlobalContext(this.session.getModelAccessor(), this.session.getInterpreter(), this.session.getSemanticResources());
            DTreeItemExpansionChangeCommand cmd = new DTreeItemExpansionChangeCommand(globalContext, domain, dTreeItem, true);
            domain.getCommandStack().execute((Command)cmd);
        }
        TestsUtil.synchronizationWithUIThread();
    }

    private void checkPrecedingSiblingsValue(DTreeItemDropListener dndListener, Set<EObject> itemSources, DTreeItem targetContainer, Collection<DTreeItem> expectedPrecedingSiblings) {
        StructuredSelection selection = new StructuredSelection(itemSources.toArray());
        LocalSelectionTransfer.getInstance().setSelection((ISelection)selection);
        boolean isValidDrop = dndListener.validateDrop((Object)targetContainer, 0, null);
        if (isValidDrop) {
            try {
                Field precedingSiblingsAttribute = DTreeItemDropListener.class.getDeclaredField("precedingSiblings");
                precedingSiblingsAttribute.setAccessible(true);
                Collection actualPrecedingSiblings = (Collection)precedingSiblingsAttribute.get((Object)this.dropListener);
                Assert.assertTrue((String)("Incorrect precedingSiblings value : got " + actualPrecedingSiblings + " expected " + expectedPrecedingSiblings), (boolean)Iterables.elementsEqual(expectedPrecedingSiblings, (Iterable)actualPrecedingSiblings));
            }
            catch (SecurityException e) {
                Assert.assertFalse((String)e.getMessage(), (boolean)true);
            }
            catch (NoSuchFieldException e) {
                Assert.assertFalse((String)e.getMessage(), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                Assert.assertFalse((String)e.getMessage(), (boolean)true);
            }
            catch (IllegalAccessException e) {
                Assert.assertFalse((String)e.getMessage(), (boolean)true);
            }
        }
    }

    private void checkDTreeItemContainment(Set<EObject> itemSources, DTreeItemContainer targetContainer, boolean shouldBeContained) {
        for (EObject item : itemSources) {
            Assert.assertTrue((boolean)(item instanceof DTreeItem));
            String targetContainerName = null;
            targetContainerName = targetContainer instanceof DTreeItem ? ((DTreeItem)targetContainer).getName() : ((DTree)targetContainer).getName();
            DTreeItem oldItem = (DTreeItem)item;
            DTreeItem newItem = (DTreeItem)this.getRepresentationElementWithName((DRepresentation)TreeHelper.getTree((EObject)targetContainer), (String)oldItem.getTarget().eGet(this.nameFeature));
            if (shouldBeContained) {
                Assert.assertNotNull((String)(String.valueOf((String)oldItem.getTarget().eGet(this.nameFeature)) + " should now be part of " + TreeHelper.getTree((EObject)targetContainer).getName() + " tree"), (Object)newItem);
                Assert.assertEquals((String)(String.valueOf(oldItem.getName()) + " should be contained in " + targetContainerName), (Object)targetContainer, (Object)newItem.getContainer());
                continue;
            }
            if (newItem == null) continue;
            Assert.assertNotSame((String)(String.valueOf(oldItem.getName()) + " should not be contained in " + targetContainerName), (Object)targetContainer, (Object)newItem.getContainer());
        }
    }

    @Override
    protected void tearDown() throws Exception {
        TestsUtil.synchronizationWithUIThread();
        DialectUIManager.INSTANCE.closeEditor((IEditorPart)this.editor, false);
        super.tearDown();
    }

    private class CustomDTreeItemDropListener
    extends DTreeItemDropListener {
        public CustomDTreeItemDropListener(Viewer viewer, TransactionalEditingDomain domain, ITreeCommandFactory treeCommandFactory, ModelAccessor accessor) {
            super(viewer, domain, treeCommandFactory, accessor);
        }

        public void setCurrentLocation(int i) {
            try {
                Field declaredField = ViewerDropAdapter.class.getDeclaredField("currentLocation");
                declaredField.setAccessible(true);
                declaredField.set((Object)this, i);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

