/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketEdgeFactory;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusElementTypes;
import org.eclipse.sirius.diagram.ui.internal.view.factories.BundledImageViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.CustomStyleViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DDiagramViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DEdgeBeginNameViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DEdgeEndNameViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DEdgeNameViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DEdgeViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNode2ViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNode3ViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNode4ViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeContainer2ViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeContainerNameViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeContainerViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeContainerViewNodeContainerCompartment2ViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeContainerViewNodeContainerCompartmentViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeList2ViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeListElementViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeListViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeListViewNodeListCompartment2ViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeListViewNodeListCompartmentViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeNameViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DNodeViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.DotViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.EllipseViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.GaugeCompositeViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.LozengeViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.NoteViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.SquareViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.WorkspaceImageViewFactory;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;

public class SiriusViewProvider
extends AbstractViewProvider {
    protected Class<?> getDiagramViewClass(IAdaptable semanticAdapter, String diagramKind) {
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        if ("Sirius".equals(diagramKind) && SiriusVisualIDRegistry.getDiagramVisualID(semanticElement) != -1) {
            return DDiagramViewFactory.class;
        }
        return null;
    }

    protected Class<?> getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        int visualID;
        if (containerView == null) {
            return null;
        }
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        if (semanticHint == null) {
            if (elementType != null || domainElement == null) {
                return null;
            }
            visualID = SiriusVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        } else {
            visualID = SiriusVisualIDRegistry.getVisualID(semanticHint);
            if (elementType != null) {
                if (!SiriusElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return null;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!semanticHint.equals(elementTypeHint)) {
                    return null;
                }
                if (domainElement != null && visualID != SiriusVisualIDRegistry.getNodeVisualID(containerView, domainElement)) {
                    return null;
                }
            } else {
                if (!"Sirius".equals(SiriusVisualIDRegistry.getModelID(containerView))) {
                    return null;
                }
                switch (visualID) {
                    case 2001: 
                    case 2002: 
                    case 2003: 
                    case 3001: 
                    case 3002: 
                    case 3003: 
                    case 3004: 
                    case 3005: 
                    case 3006: 
                    case 3007: 
                    case 3008: 
                    case 3009: 
                    case 3010: 
                    case 3012: 
                    case 3013: 
                    case 3014: 
                    case 3016: 
                    case 3017: {
                        if (domainElement != null && visualID == SiriusVisualIDRegistry.getNodeVisualID(containerView, domainElement)) break;
                        return null;
                    }
                    case 5002: {
                        if (2001 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 5006: 
                    case 7001: {
                        if (2002 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 5007: 
                    case 7004: {
                        if (2003 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 5001: {
                        if (3001 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 5003: {
                        if (3007 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 5005: 
                    case 7002: {
                        if (3008 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 5004: 
                    case 7003: {
                        if (3009 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 5010: {
                        if (3012 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    case 6001: 
                    case 6002: 
                    case 6003: {
                        if (4001 == SiriusVisualIDRegistry.getVisualID(containerView) && containerView.getElement() == domainElement) break;
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        return this.getNodeViewClass(containerView, visualID);
    }

    protected Class<?> getNodeViewClass(View containerView, int visualID) {
        if (containerView == null || !SiriusVisualIDRegistry.canCreateNode(containerView, visualID)) {
            return null;
        }
        switch (visualID) {
            case 2001: {
                return DNodeViewFactory.class;
            }
            case 2002: {
                return DNodeContainerViewFactory.class;
            }
            case 5004: 
            case 5005: 
            case 5006: 
            case 5007: {
                return DNodeContainerNameViewFactory.class;
            }
            case 2003: {
                return DNodeListViewFactory.class;
            }
            case 3001: {
                return DNode2ViewFactory.class;
            }
            case 5001: 
            case 5002: 
            case 5003: 
            case 5010: {
                return DNodeNameViewFactory.class;
            }
            case 3004: {
                return BundledImageViewFactory.class;
            }
            case 3002: {
                return DotViewFactory.class;
            }
            case 3006: {
                return GaugeCompositeViewFactory.class;
            }
            case 3003: {
                return SquareViewFactory.class;
            }
            case 3016: {
                return EllipseViewFactory.class;
            }
            case 3017: {
                return LozengeViewFactory.class;
            }
            case 3005: {
                return WorkspaceImageViewFactory.class;
            }
            case 3013: {
                return NoteViewFactory.class;
            }
            case 3014: {
                return CustomStyleViewFactory.class;
            }
            case 3007: {
                return DNode3ViewFactory.class;
            }
            case 3008: {
                return DNodeContainer2ViewFactory.class;
            }
            case 3009: {
                return DNodeList2ViewFactory.class;
            }
            case 3010: {
                return DNodeListElementViewFactory.class;
            }
            case 3012: {
                return DNode4ViewFactory.class;
            }
            case 7001: {
                return DNodeContainerViewNodeContainerCompartmentViewFactory.class;
            }
            case 7002: {
                return DNodeContainerViewNodeContainerCompartment2ViewFactory.class;
            }
            case 7003: {
                return DNodeListViewNodeListCompartmentViewFactory.class;
            }
            case 7004: {
                return DNodeListViewNodeListCompartment2ViewFactory.class;
            }
            case 6001: {
                return DEdgeNameViewFactory.class;
            }
            case 6002: {
                return DEdgeBeginNameViewFactory.class;
            }
            case 6003: {
                return DEdgeEndNameViewFactory.class;
            }
        }
        return null;
    }

    protected Class<?> getEdgeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        if (!SiriusElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return null;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null) {
            return null;
        }
        if (semanticHint != null && !semanticHint.equals(elementTypeHint)) {
            return null;
        }
        int visualID = SiriusVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        if (domainElement != null && visualID != SiriusVisualIDRegistry.getLinkWithClassVisualID(domainElement)) {
            return null;
        }
        return this.getEdgeViewClass(visualID);
    }

    protected Class<?> getEdgeViewClass(int visualID) {
        switch (visualID) {
            case 4001: {
                return DEdgeViewFactory.class;
            }
            case 4002: {
                return BracketEdgeFactory.class;
            }
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

