/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import com.google.common.collect.Iterables;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class FigureQuery {
    private IFigure figure;

    public FigureQuery(IFigure figure) {
        this.figure = figure;
    }

    public Option<IFigure> getLabelFigure() {
        Option<IFigure> result = Options.newNone();
        if (this.figure instanceof SiriusWrapLabel || this.figure instanceof WrapLabel || this.figure instanceof Label) {
            result = Options.newSome((Object)this.figure);
        } else {
            for (IFigure childFigure : Iterables.filter((Iterable)this.figure.getChildren(), IFigure.class)) {
                Option<IFigure> temp = new FigureQuery(childFigure).getLabelFigure();
                if (!temp.some()) continue;
                result = temp;
                break;
            }
        }
        return result;
    }

    public Option<String> getText() {
        Option result = Options.newNone();
        Option<IFigure> labelFigure = this.getLabelFigure();
        if (labelFigure.some()) {
            if (labelFigure.get() instanceof SiriusWrapLabel) {
                result = Options.newSome((Object)((SiriusWrapLabel)((Object)labelFigure.get())).getText());
            }
            if (labelFigure.get() instanceof WrapLabel) {
                result = Options.newSome((Object)((WrapLabel)labelFigure.get()).getText());
            } else if (labelFigure.get() instanceof Label) {
                result = Options.newSome((Object)((Label)labelFigure.get()).getText());
            }
        }
        return result;
    }
}

