/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OneLineBorder;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class OneLineMarginBorder
extends OneLineBorder {
    private int[] dash;
    private Insets margin = new Insets();

    public OneLineMarginBorder(int position) {
        this.setPosition(position);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        if (this.dash != null && this.getStyle() == 6) {
            graphics.setLineDash(this.dash);
        }
        super.paint(figure, graphics, insets);
        int one = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(1);
        int widthInDP = this.getWidth() / one;
        int halfWidthInLP = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(widthInDP / 2);
        switch (this.getPosition()) {
            case 16: {
                OneLineMarginBorder.tempRect.y += halfWidthInLP;
                OneLineMarginBorder.tempRect.height -= this.getWidth();
                graphics.drawLine(tempRect.getLeft(), tempRect.getRight());
                break;
            }
            case 2: {
                OneLineMarginBorder.tempRect.x += halfWidthInLP;
                OneLineMarginBorder.tempRect.width -= this.getWidth();
                graphics.drawLine(tempRect.getTop(), tempRect.getBottom());
                break;
            }
        }
    }

    public Insets getInsets(IFigure figure) {
        Insets borderInsets;
        switch (this.getPosition()) {
            case 8: {
                borderInsets = new Insets(this.getWidth(), 0, 0, 0);
                break;
            }
            case 1: {
                borderInsets = new Insets(0, this.getWidth(), 0, 0);
                break;
            }
            case 32: {
                borderInsets = new Insets(0, 0, this.getWidth(), 0);
                break;
            }
            case 4: {
                borderInsets = new Insets(0, 0, 0, this.getWidth());
                break;
            }
            case 16: {
                borderInsets = new Insets(this.getWidth() / 2, 0, this.getWidth() / 2, 0);
                break;
            }
            case 2: {
                borderInsets = new Insets(0, this.getWidth() / 2, 0, this.getWidth() / 2);
                break;
            }
            default: {
                borderInsets = IFigure.NO_INSETS;
            }
        }
        Insets globalInsets = new Insets();
        globalInsets.add(borderInsets);
        globalInsets.add(this.margin);
        return globalInsets;
    }

    public void setLineDash(int[] dashPattern) {
        int[] copy = null;
        if (dashPattern != null) {
            copy = new int[dashPattern.length];
            System.arraycopy(dashPattern, 0, copy, 0, dashPattern.length);
        }
        this.dash = copy;
    }

    public void setMargin(Insets insets) {
        this.margin = this.margin != null ? insets : new Insets();
    }

    public void setMargin(int t, int l, int b, int r) {
        this.setMargin(new Insets(t, l, b, r));
    }

    public void setMargin(int allsides) {
        this.setMargin(new Insets(allsides));
    }
}

