/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure.anchor;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class AirSlidableImageAnchor
extends SlidableAnchor {
    private ImageAnchorLocation imageAnchorLocation;
    private ImageFigure imageFig;

    public AirSlidableImageAnchor() {
    }

    public AirSlidableImageAnchor(IFigure f, ImageFigure imageFig, PrecisionPoint p) {
        super(f, p);
        this.imageFig = imageFig;
    }

    public AirSlidableImageAnchor(IFigure container, ImageFigure imageFig) {
        super(container);
        this.imageFig = imageFig;
    }

    public AirSlidableImageAnchor(IFigure f) {
        super(f);
    }

    protected Image getImage() {
        ImageFigure imageFigure = this.getImageFigure();
        if (imageFigure != null) {
            return imageFigure.getImage();
        }
        return null;
    }

    protected ImageFigure getImageFigure() {
        ImageFigure ret = this.imageFig;
        if (ret == null) {
            IFigure root = this.getOwner().getParent() == null ? this.getOwner() : this.getOwner().getParent();
            ret = AirSlidableImageAnchor.getImageFigure(root);
        }
        return ret;
    }

    private static ImageFigure getImageFigure(IFigure root) {
        ImageFigure ret = null;
        if (root instanceof ImageFigure) {
            ret = (ImageFigure)root;
        }
        Iterator iterChilren = root.getChildren().iterator();
        while (iterChilren.hasNext() && ret == null) {
            IFigure next = (IFigure)iterChilren.next();
            ret = AirSlidableImageAnchor.getImageFigure(next);
        }
        return ret;
    }

    protected IFigure getContainer() {
        return this.getOwner();
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        Image image = this.getImage();
        if (image == null) {
            return super.getLocation(ownReference, foreignReference);
        }
        Rectangle bounds = this.getOwner().getBounds();
        ImageFigure imageFigure = this.getImageFigure();
        if (imageFigure != null) {
            bounds = imageFigure.getBounds();
        }
        Rectangle ownerRect = new Rectangle(bounds);
        this.getOwner().translateToAbsolute((Translatable)ownerRect);
        PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
        Point loc = null;
        if (intersections != null && intersections.size() != 0) {
            Point ptRef = PointListUtilities.pickFarestPoint((PointList)intersections, (Point)foreignReference);
            Point ptEdge = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)foreignReference);
            ImageAnchorLocation imgAnchorLocation = this.getImageAnchorLocation();
            loc = imgAnchorLocation.getLocation(ptRef, ptEdge, ownerRect, this.isDefaultAnchor());
            if (loc != null) {
                loc = this.normalizeToStraightlineTolerance(foreignReference, loc, 3);
            }
        }
        return loc;
    }

    private ImageAnchorLocation getImageAnchorLocation() {
        if (this.imageAnchorLocation == null) {
            Image image = this.getImage();
            this.imageAnchorLocation = new ImageAnchorLocation(image);
        }
        return this.imageAnchorLocation;
    }

    private final class ImageAnchorLocation {
        private ImageData imgData;
        private ImageData transMaskData;

        private ImageAnchorLocation(Image img) {
            this.imgData = img.getImageData();
            this.transMaskData = this.imgData.getTransparencyMask();
        }

        protected ImageData getImageData() {
            return this.imgData;
        }

        protected ImageData getTransparencyMaskData() {
            return this.transMaskData;
        }

        protected boolean isTransparentAt(int x, int y, boolean checkAdjacent) {
            if (x < 0 || x >= this.getImageData().width || y < 0 || y >= this.getImageData().height) {
                return true;
            }
            int transValue = 255;
            if (this.getTransparencyMaskData() != null) {
                int n = transValue = this.getTransparencyMaskData().getPixel(x, y) == 0 ? 0 : 255;
            }
            if (transValue != 0 && this.getImageData().alphaData != null) {
                transValue = this.getImageData().getAlpha(x, y);
            }
            boolean trans = false;
            if (transValue < 10) {
                trans = true;
                if (checkAdjacent) {
                    trans = trans && this.isTransparentAt(x + 1, y, false);
                    trans = trans && this.isTransparentAt(x + 1, y + 1, false);
                    trans = trans && this.isTransparentAt(x + 1, y - 1, false);
                    trans = trans && this.isTransparentAt(x - 1, y + 1, false);
                    trans = trans && this.isTransparentAt(x - 1, y, false);
                    trans = trans && this.isTransparentAt(x - 1, y - 1, false);
                    trans = trans && this.isTransparentAt(x, y + 1, false);
                    trans = trans && this.isTransparentAt(x, y - 1, false);
                }
            }
            return trans;
        }

        private Point getLocation(Point start, Point edge, Rectangle containerRect, boolean isDefaultAnchor) {
            Point top = containerRect.getTopLeft();
            AirSlidableImageAnchor.this.getOwner().getParent().translateToRelative((Translatable)top);
            Point ptIntersect = null;
            Rectangle imageBounds = AirSlidableImageAnchor.this.getOwner().getBounds();
            Dimension dim = edge.getDifference(top);
            Point edgeImg = new Point(Math.max(0, Math.min(dim.width, imageBounds.width - 1)), Math.max(0, Math.min(dim.height, imageBounds.height - 1)));
            Dimension startDim = start.getDifference(top);
            Point startImg = new Point(Math.max(0, Math.min(startDim.width, imageBounds.width - 1)), Math.max(0, Math.min(startDim.height, imageBounds.height - 1)));
            ptIntersect = this.calculateIntersection(startImg, edgeImg);
            if (ptIntersect == null) {
                return null;
            }
            return ptIntersect.getTranslated(top.x, top.y);
        }

        private Point calculateIntersection(Point start, Point edge) {
            Point opaque = new Point(edge);
            LineSeg line = new LineSeg(start, edge);
            long distance = Math.round(line.length());
            Rectangle imageBounds = AirSlidableImageAnchor.this.getOwner().getBounds();
            while (opaque.x >= 0 && opaque.x < imageBounds.width && opaque.y >= 0 && opaque.y < imageBounds.height) {
                int imageWidth = this.getImageData().width;
                int x = (int)((double)opaque.x * (double)imageWidth / (double)imageBounds.width);
                int imageHeight = this.getImageData().height;
                int y = (int)((double)opaque.y * (double)imageHeight / (double)imageBounds.height);
                if (!this.isTransparentAt(x, y, true)) {
                    return opaque;
                }
                line.pointOn(distance, LineSeg.KeyPoint.ORIGIN, opaque);
                --distance;
            }
            return null;
        }
    }
}

