/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.AdvancedSubGraph;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.CompositeDirectedGraphLayout;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.VirtualNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.ArrangeAllWithAutoSize;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class AutoSizeAndRegionAwareGraphLayout
extends CompositeDirectedGraphLayout {
    private int specificGraphDirection = 4;

    public void visit(DirectedGraph graph) {
        this.specificGraphDirection = graph.getDirection();
        this.layoutNodes(graph.nodes, false);
    }

    private void layoutNodes(NodeList nodes, boolean virtualPass) {
        EdgeList edges = new EdgeList();
        for (Node element : nodes) {
            if (element instanceof Subgraph && !(element instanceof VirtualNode)) {
                this.layoutNodes(((Subgraph)element).members, virtualPass);
            }
            for (Edge edge : element.outgoing) {
                if (!nodes.contains((Object)edge.target)) continue;
                edges.add((Object)edge);
            }
        }
        if (!virtualPass) {
            VirtualNodesToNodes virtualNodesNodes = new VirtualNodesToNodes();
            this.createVirtualNodes(nodes, edges, virtualNodesNodes);
            NodeList vituralNodes = virtualNodesNodes.getVirtualNodes();
            int size = vituralNodes.size();
            if (size > 0) {
                edges = virtualNodesNodes.getEdges();
                for (Subgraph virtualNode : vituralNodes) {
                    this.layoutNodes(virtualNode.members, true);
                }
                this.adjustVirtualNodesWidthAndHeight(vituralNodes);
            }
        }
        HashMap nodeToOutGoing = new HashMap();
        HashMap nodeToIncomingGoing = new HashMap();
        this.removeDisconnectedEdges(nodes, nodeToOutGoing, nodeToIncomingGoing);
        if (nodes.size() > 0) {
            boolean concernRegions;
            Node parent = this.getParent(nodes.getNode(0));
            DirectedGraph g = new DirectedGraph();
            g.setDirection(this.specificGraphDirection);
            g.nodes = nodes;
            g.edges = edges;
            boolean bl = concernRegions = parent == null && this.areRegions(nodes) || parent != null && this.getRegionContainer(parent).some();
            if (!concernRegions) {
                DirectedGraphLayout layout = new DirectedGraphLayout();
                layout.visit(g);
            }
            Dimension offsets = this.getOffsets(nodes);
            int j = 0;
            while (j < nodes.size()) {
                Node n = nodes.getNode(j);
                n.x += offsets.width;
                n.y += offsets.height;
                ++j;
            }
            if (concernRegions) {
                this.adjustRegionsLayout(nodes, parent);
            }
            if (parent instanceof AdvancedSubGraph) {
                this.adjustAutoSizeNodeWidthAndHeight((AdvancedSubGraph)parent);
            }
        }
        this.restoreDisconnectedEdges(nodeToOutGoing, nodeToIncomingGoing);
    }

    private void adjustRegionsLayout(NodeList nodes, Node parent) {
        if (nodes.isEmpty()) {
            return;
        }
        DNodeContainer regionContainer = this.getRegionContainer(nodes, parent);
        if (regionContainer != null) {
            DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery(regionContainer);
            if (query.isVerticalStackContainer()) {
                this.adjustRegionLayout(nodes, parent, true);
            } else if (query.isHorizontaltackContainer()) {
                this.adjustRegionLayout(nodes, parent, false);
            }
        }
    }

    private void adjustRegionLayout(NodeList nodes, Node parent, boolean vertical) {
        int commonWidth = 0;
        int commonHeight = 0;
        int j = 0;
        while (j < nodes.size()) {
            Node n = nodes.getNode(j);
            commonWidth = Math.max(commonWidth, n.width);
            commonHeight = Math.max(commonHeight, n.height);
            ++j;
        }
        int y = 0;
        int x = 0;
        int j2 = 0;
        while (j2 < nodes.size()) {
            Node n = nodes.getNode(j2);
            n.x = x;
            n.y = y;
            if (vertical) {
                n.width = commonWidth;
                y += n.height;
            } else {
                x += n.width;
                n.height = commonHeight;
            }
            ++j2;
        }
    }

    private DNodeContainer getRegionContainer(NodeList nodes, Node parent) {
        Option<DDiagramElementContainer> region;
        DNodeContainer rc = null;
        rc = parent != null ? (DNodeContainer)this.getRegionContainer(parent).get() : ((region = this.getRegion(nodes.getNode(0))).some() ? (DNodeContainer)((DDiagramElementContainer)region.get()).eContainer() : null);
        return rc;
    }

    private boolean areRegions(NodeList nodes) {
        boolean areRegions = false;
        int j = 0;
        while (j < nodes.size()) {
            Node n = nodes.getNode(j);
            areRegions = areRegions || this.getRegion(n).some();
            ++j;
        }
        return areRegions;
    }

    private Option<DNodeContainer> getRegionContainer(Node node) {
        EObject element;
        DNodeContainer dnc = null;
        if (node != null && (node.data instanceof IDiagramContainerEditPart || node.data instanceof AbstractDNodeContainerCompartmentEditPart) && (element = ((IGraphicalEditPart)node.data).resolveSemanticElement()) instanceof DNodeContainer) {
            dnc = (DNodeContainer)element;
        }
        if (dnc != null && new DNodeContainerExperimentalQuery(dnc).isRegionContainer()) {
            return Options.newSome(dnc);
        }
        return Options.newNone();
    }

    private Option<DDiagramElementContainer> getRegion(Node node) {
        DDiagramElement element;
        if (node.data instanceof IAbstractDiagramNodeEditPart && (element = ((IAbstractDiagramNodeEditPart)node.data).resolveDiagramElement()) instanceof DDiagramElementContainer && new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)element).isRegion()) {
            return Options.newSome((Object)((DDiagramElementContainer)element));
        }
        return Options.newNone();
    }

    private Dimension getOffsets(NodeList nodes) {
        Node node = nodes.getNode(0);
        int left = node.x;
        int top = node.y;
        Rectangle bbox = ArrangeAllWithAutoSize.extendBoundingBoxWithBorderedNodes(node, new Rectangle(node.x, node.y, node.width, node.height));
        int leftBorder = bbox.x;
        int topBorder = bbox.y;
        int i = 1;
        while (i < nodes.size()) {
            node = nodes.getNode(i);
            left = Math.min(left, node.x);
            top = Math.min(top, node.y);
            bbox = ArrangeAllWithAutoSize.extendBoundingBoxWithBorderedNodes(node, new Rectangle(node.x, node.y, node.width, node.height));
            leftBorder = Math.min(leftBorder, bbox.x);
            topBorder = Math.min(topBorder, bbox.y);
            ++i;
        }
        Point diff = new Point();
        if (node.getParent() != null) {
            diff = new Point(node.getParent().x - node.x, node.getParent().y - node.y);
        }
        if (diff.x < 0 && diff.y < 0) {
            return new Dimension(Math.max(0, left - leftBorder), Math.max(0, top - topBorder));
        }
        return new Dimension(Math.max(0, Math.abs(left - leftBorder)), Math.max(0, Math.abs(top - topBorder)));
    }

    private void restoreDisconnectedEdges(Map nodeToOutGoing, Map nodeToIncomingGoing) {
        this.restoreEdges(nodeToOutGoing.entrySet(), true);
        this.restoreEdges(nodeToIncomingGoing.entrySet(), false);
    }

    private void removeDisconnectedEdges(NodeList nodes, Map nodeToOutGoing, Map nodeToIncomingGoing) {
        for (Node element : nodes) {
            this.pushExtraEdges(nodes, nodeToOutGoing, element, (List)element.outgoing, false);
            this.pushExtraEdges(nodes, nodeToIncomingGoing, element, (List)element.incoming, true);
        }
    }

    private void createVirtualNodes(NodeList nodes, EdgeList edges, VirtualNodesToNodes virtualNodesNodes) {
        HashSet handledEdges = new HashSet();
        this.recursiveHandleVirtualNode(nodes, edges, virtualNodesNodes, handledEdges, new HashSet(nodes));
    }

    private void recursiveHandleVirtualNode(NodeList nodes, EdgeList edges, VirtualNodesToNodes virtualNodesNodes, Set handledEdges, Set nodesSnapeShot) {
        for (Edge element : edges) {
            if (handledEdges.contains(element)) continue;
            handledEdges.add(element);
            if (!nodesSnapeShot.contains(element.source) || !nodesSnapeShot.contains(element.target)) continue;
            Node source = element.source;
            Node target = element.target;
            boolean sourceHandled = true;
            boolean targetHandled = true;
            Subgraph sg = virtualNodesNodes.getVirtualContainer(source);
            Subgraph sg1 = virtualNodesNodes.getVirtualContainer(target);
            if (sg == null) {
                sourceHandled = false;
                sg = sg1;
            }
            if (sg1 == null) {
                targetHandled = false;
            }
            if (!sourceHandled && !targetHandled) {
                sg = new VirtualNode(null, source.getParent());
                sg.setPadding(new Insets(source.getPadding()));
                if (source.getParent() == null) {
                    nodes.add((Object)sg);
                }
            }
            if (!sourceHandled) {
                this.addNode(sg, source, nodes);
                virtualNodesNodes.addNode(sg, source);
            }
            if (!targetHandled) {
                this.addNode(sg, target, nodes);
                virtualNodesNodes.addNode(sg, target);
            }
            if (!sourceHandled) {
                this.recursiveHandleVirtualNode(nodes, source.outgoing, virtualNodesNodes, handledEdges, nodesSnapeShot);
                this.recursiveHandleVirtualNode(nodes, source.incoming, virtualNodesNodes, handledEdges, nodesSnapeShot);
            }
            if (targetHandled) continue;
            this.recursiveHandleVirtualNode(nodes, target.outgoing, virtualNodesNodes, handledEdges, nodesSnapeShot);
            this.recursiveHandleVirtualNode(nodes, target.incoming, virtualNodesNodes, handledEdges, nodesSnapeShot);
        }
    }

    private void pushExtraEdges(NodeList nodes, Map nodeToIncomingGoing, Node element, List list, boolean sourceCheck) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node nodeToCheck;
            Edge edge = (Edge)iterator.next();
            Node node = nodeToCheck = sourceCheck ? edge.source : edge.target;
            if (nodes.contains((Object)nodeToCheck)) continue;
            edges.add(edge);
            iterator.remove();
            Node sourceNode = null;
            Node targetNode = null;
            sourceNode = this.getParent(edge.source);
            targetNode = this.getParent(edge.target);
            sourceNode = !sourceCheck || sourceNode != null ? sourceNode : edge.source;
            Node node2 = targetNode = sourceCheck || targetNode != null ? targetNode : edge.target;
            if (sourceCheck || sourceNode == null || targetNode == null || sourceNode == targetNode || edge.source == sourceNode && edge.target == targetNode) continue;
            Edge virtualEdge = new Edge(sourceNode, targetNode, edge.getDelta(), edge.weight);
            virtualEdge.setPadding(edge.getPadding());
        }
        if (!edges.isEmpty()) {
            nodeToIncomingGoing.put(element, edges);
        }
    }

    private Node getParent(Node node) {
        Subgraph parent = node.getParent();
        if (parent instanceof VirtualNode) {
            parent = parent.getParent();
        }
        return parent;
    }

    private void restoreEdges(Set entries, boolean outgoing) {
        for (Map.Entry entry : entries) {
            Node node = (Node)entry.getKey();
            List edgesList = (List)entry.getValue();
            for (Edge edgeToRestore : edgesList) {
                if (outgoing) {
                    node.outgoing.add((Object)edgeToRestore);
                    continue;
                }
                node.incoming.add((Object)edgeToRestore);
            }
        }
    }

    private void adjustVirtualNodesWidthAndHeight(NodeList vituralNodes) {
        for (Subgraph subGraph : vituralNodes) {
            this.adjustVirtualNodeWidthAndHeight(subGraph);
        }
    }

    private void adjustVirtualNodeWidthAndHeight(Subgraph subGraph) {
        NodeList nodes = subGraph.members;
        if (nodes.isEmpty()) {
            return;
        }
        int size = nodes.size();
        Node node = nodes.getNode(0);
        int top = node.y;
        int left = node.x;
        int bottom = top + node.height;
        int right = left + node.width;
        int index = 1;
        while (index < size) {
            node = (Node)nodes.get(index);
            if (top > node.y) {
                top = node.y;
            }
            if (bottom < node.y + node.height) {
                bottom = node.y + node.height;
            }
            if (left > node.x) {
                left = node.x;
            }
            if (right < node.x + node.width) {
                right = node.x + node.width;
            }
            ++index;
        }
        subGraph.width = right - left;
        subGraph.height = bottom - top;
    }

    private void adjustAutoSizeNodeWidthAndHeight(AdvancedSubGraph subGraph) {
        Node leftNode;
        if (!subGraph.isAutoSize()) {
            return;
        }
        NodeList nodes = subGraph.members;
        if (nodes.isEmpty()) {
            return;
        }
        int size = nodes.size();
        Node node = nodes.getNode(0);
        int top = node.y;
        int left = node.x;
        int bottom = top + node.height;
        int right = left + node.width;
        Node topNode = leftNode = node;
        int index = 1;
        while (index < size) {
            node = (Node)nodes.get(index);
            if (top > node.y) {
                top = node.y;
                topNode = node;
            }
            if (bottom < node.y + node.height) {
                bottom = node.y + node.height;
            }
            if (left > node.x) {
                left = node.x;
                leftNode = node;
            }
            if (right < node.x + node.width) {
                right = node.x + node.width;
            }
            ++index;
        }
        int xDiff = 0;
        int yDiff = 0;
        if (subGraph.isHasBufferedZone()) {
            xDiff = leftNode.x;
            yDiff = topNode.y;
        }
        subGraph.width = right - left + xDiff;
        subGraph.height = bottom - top + yDiff;
        if (subGraph.data instanceof IGraphicalEditPart) {
            IGraphicalEditPart gep = (IGraphicalEditPart)subGraph.data;
            IFigure f = gep.getFigure();
            LayoutManager lm = f.getParent().getLayoutManager();
            Point offset = lm instanceof XYLayout ? ((XYLayout)lm).getOrigin(f.getParent()) : new Point();
            Rectangle bounds = f.getBounds().getCopy();
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension _preferredSize = f.getPreferredSize(bounds.width, bounds.height);
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = _preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = _preferredSize.height;
                }
            }
            Dimension min = f.getMinimumSize();
            Dimension max = f.getMaximumSize();
            if (min.width > bounds.width) {
                bounds.width = min.width;
            } else if (max.width < bounds.width) {
                bounds.width = max.width;
            }
            if (min.height > bounds.height) {
                bounds.height = min.height;
            } else if (max.height < bounds.height) {
                bounds.height = max.height;
            }
            bounds = bounds.getTranslated(offset);
            subGraph.width = Math.max(subGraph.width, bounds.width);
            subGraph.height = Math.max(subGraph.height, bounds.height);
        }
    }

    private void addNode(Subgraph parent, Node node, NodeList nodes) {
        if (node.getParent() != null) {
            node.getParent().members.remove((Object)node);
        }
        node.setParent(parent);
        parent.addMember(node);
        nodes.remove((Object)node);
    }

    private static class VirtualNodesToNodes
    extends HashMap {
        Set virtualNodes = new HashSet();

        private VirtualNodesToNodes() {
        }

        public void addNode(Subgraph sg, Node node) {
            this.virtualNodes.add(sg);
            this.put(node, sg);
        }

        public EdgeList getEdges() {
            EdgeList edges = new EdgeList();
            for (Node element : this.virtualNodes) {
                for (Edge edge : element.outgoing) {
                    if (!this.virtualNodes.contains(edge.target)) continue;
                    edges.add((Object)edge);
                }
            }
            return edges;
        }

        public Subgraph getVirtualContainer(Node node) {
            return (Subgraph)this.get(node);
        }

        public NodeList getVirtualNodes() {
            NodeList nodeList = new NodeList();
            nodeList.addAll((Collection)this.virtualNodes);
            return nodeList;
        }
    }
}

