/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.locator.EdgeLabelQuery;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class RemoveBendpointsOperation
extends AbstractModelChangeOperation<Void> {
    private ConnectionNodeEditPart editPart;

    public RemoveBendpointsOperation(ConnectionNodeEditPart editPart) {
        this.editPart = editPart;
    }

    @Override
    public Void execute() {
        Bendpoints bendpoints;
        Object model = this.editPart.getModel();
        if (model instanceof Edge && (bendpoints = ((Edge)model).getBendpoints()) instanceof RelativeBendpoints) {
            ((RelativeBendpoints)bendpoints).setPoints((List)Lists.newArrayList());
            this.computeNewBendpoints();
        }
        return null;
    }

    private void computeNewBendpoints() {
        IFigure figure = this.editPart.getFigure();
        if (figure instanceof Connection) {
            Point absoluteSrcAnchorCoordinates = ((Connection)figure).getSourceAnchor().getReferencePoint();
            Point absoluteTgtAnchorCoordinates = ((Connection)figure).getTargetAnchor().getReferencePoint();
            GraphicalHelper.screen2logical((Point)absoluteSrcAnchorCoordinates, (IGraphicalEditPart)this.editPart);
            GraphicalHelper.screen2logical((Point)absoluteTgtAnchorCoordinates, (IGraphicalEditPart)this.editPart);
            Rectangle srcAbsoluteBounds = this.getFigureBounds(this.editPart.getSource());
            Rectangle tgtAbsoluteBounds = this.getFigureBounds(this.editPart.getTarget());
            if (srcAbsoluteBounds != null && tgtAbsoluteBounds != null) {
                Option srcConnectionBendpoint = GraphicalHelper.getIntersection((Point)absoluteSrcAnchorCoordinates, (Point)absoluteTgtAnchorCoordinates, (Rectangle)srcAbsoluteBounds, (boolean)true);
                Option tgtConnectionBendpoint = GraphicalHelper.getIntersection((Point)absoluteSrcAnchorCoordinates, (Point)absoluteTgtAnchorCoordinates, (Rectangle)tgtAbsoluteBounds, (boolean)false);
                if (srcConnectionBendpoint.some() && tgtConnectionBendpoint.some()) {
                    this.setNewBendpoints((Point)srcConnectionBendpoint.get(), (Point)tgtConnectionBendpoint.get(), absoluteSrcAnchorCoordinates, absoluteTgtAnchorCoordinates);
                }
            }
        }
    }

    private void setNewBendpoints(Point sourceConnection, Point targetConnection, Point absoluteSrcAnchorCoordinates, Point absoluteTgtAnchorCoordinates) {
        Object model = this.editPart.getModel();
        if (model instanceof Edge) {
            PointList pointList = new PointList();
            pointList.addPoint(sourceConnection);
            pointList.addPoint(targetConnection);
            GMFNotationUtilities.setGMFBendpoints((Edge)model, pointList, absoluteSrcAnchorCoordinates, absoluteTgtAnchorCoordinates);
            List children = this.editPart.getChildren();
            for (Object child : children) {
                AbstractDEdgeNameEditPart labelEditPartToUpdate;
                Node labelNodeToUpdate;
                LayoutConstraint layoutConstraint;
                if (!(child instanceof AbstractDEdgeNameEditPart) || !((layoutConstraint = (labelNodeToUpdate = (Node)(labelEditPartToUpdate = (AbstractDEdgeNameEditPart)child).getModel()).getLayoutConstraint()) instanceof Bounds)) continue;
                Bounds bounds = (Bounds)layoutConstraint;
                Point snapBackPosition = EdgeLabelQuery.getSnapBackPosition(labelEditPartToUpdate.getKeyPoint());
                Bounds labelBounds = NotationFactory.eINSTANCE.createBounds();
                labelBounds.setX(snapBackPosition.x);
                labelBounds.setY(snapBackPosition.y);
                labelBounds.setWidth(bounds.getWidth());
                labelBounds.setHeight(bounds.getHeight());
                labelNodeToUpdate.setLayoutConstraint((LayoutConstraint)labelBounds);
            }
        }
    }

    private Rectangle getFigureBounds(EditPart editPart) {
        if (editPart instanceof GraphicalEditPart) {
            return GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((GraphicalEditPart)editPart));
        }
        return null;
    }
}

