/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementSpecOperations;
import org.eclipse.sirius.diagram.ui.internal.refresh.SynchronizeGMFModelCommand;

public class SiriusGMFSynchronizerDispatcher {
    public Command getGMFNotationModelSynchronizationCmd(TransactionalEditingDomain domain, Collection<Notification> notifications) {
        SynchronizeGMFModelCommand gmfNotationModelSynchronizationCmd = null;
        LinkedHashSet gmfDiagramToSynchronizes = Sets.newLinkedHashSet();
        for (Notification notification : notifications) {
            Diagram gmfDiagram = this.getGMFDiagram(notification);
            if (gmfDiagram == null || gmfDiagramToSynchronizes.contains(gmfDiagram)) continue;
            gmfDiagramToSynchronizes.add(gmfDiagram);
            CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiagram);
            if (gmfNotationModelSynchronizationCmd == null) {
                gmfNotationModelSynchronizationCmd = new SynchronizeGMFModelCommand(domain, canonicalSynchronizer);
                continue;
            }
            SynchronizeGMFModelCommand synchronizeCommand = new SynchronizeGMFModelCommand(domain, canonicalSynchronizer);
            gmfNotationModelSynchronizationCmd = gmfNotationModelSynchronizationCmd.chain((Command)synchronizeCommand);
        }
        return gmfNotationModelSynchronizationCmd;
    }

    private Diagram getGMFDiagram(Notification notification) {
        Diagram gmfDiagram = null;
        DDiagram dDiagram = null;
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject && ((EObject)notifier).eContainer() != null) {
            if (notifier instanceof DDiagram) {
                dDiagram = (DDiagram)notifier;
            } else if (notifier instanceof DDiagramElement) {
                dDiagram = ((DDiagramElement)notifier).getParentDiagram();
            }
        } else if (notification.getOldValue() instanceof DDiagramElement) {
            DDiagramElement oldValue = (DDiagramElement)notification.getOldValue();
            dDiagram = DDiagramElementSpecOperations.getParentDiagram((DDiagramElement)oldValue);
        }
        if (dDiagram != null) {
            DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(dDiagram);
            if (diagramCreationUtil.findAssociatedGMFDiagram()) {
                gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
            } else {
                Resource diagramResource = dDiagram.eResource();
                for (EObject object : diagramResource.getContents()) {
                    Diagram diagram;
                    if (!(object instanceof Diagram) || !dDiagram.equals((diagram = (Diagram)object).getElement())) continue;
                    gmfDiagram = diagram;
                    break;
                }
            }
        }
        return gmfDiagram;
    }
}

