/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands.emf;

import java.util.Collection;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.helper.SelectionDescriptionHelper;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.tools.api.selection.EObjectSelectionWizard;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.AbstractSelectionWizardCommand;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.SelectionDescription;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectionWizardCommand
extends AbstractSelectionWizardCommand {
    private final IDiagramCommandFactory factory;
    private final SelectionWizardDescription tool;
    private final TreeItemWrapper input;
    private final DSemanticDecorator containerView;

    public SelectionWizardCommand(IDiagramCommandFactory factory, SelectionWizardDescription tool, TreeItemWrapper input, DSemanticDecorator containerView) {
        super(TransactionUtil.getEditingDomain((EObject)containerView));
        this.factory = factory;
        this.tool = tool;
        this.input = input;
        this.containerView = containerView;
    }

    public void doExecute() {
        this.computeInput();
        Shell shell = null;
        boolean createdShell = false;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (shell == null) {
            shell = new Shell();
            createdShell = true;
        }
        EObjectSelectionWizard wizard = new EObjectSelectionWizard(this.tool.getWindowTitle(), this.tool.getMessage(), this.getImage(), this.input, DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
        wizard.setMany(this.tool.isMultiple());
        WizardDialog dlg = new WizardDialog(shell, (IWizard)wizard);
        int result = dlg.open();
        if (result == 0) {
            Collection selectedElements = wizard.getSelectedEObjects();
            Command command = this.factory.buildSelectionWizardCommandFromTool(this.tool, this.containerView, selectedElements);
            command.execute();
            if (createdShell) {
                shell.dispose();
            }
        } else {
            if (this.containerView instanceof AbstractDNode) {
                SiriusLayoutDataManager.INSTANCE.getData((AbstractDNode)this.containerView);
            }
            if (createdShell) {
                shell.dispose();
            }
            throw new OperationCanceledException(Messages.SelectionWizardCommand_cancelExceptionMsg);
        }
    }

    private void computeInput() {
        EObject container = this.containerView.getTarget();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(container);
        if (AbstractSelectionWizardCommand.checkPrecondition((AbstractToolDescription)this.tool, (EObject)this.containerView, container)) {
            interpreter.setVariable(this.tool.getContainerView().getName(), (Object)this.containerView);
            Option diagram = new EObjectQuery((EObject)this.containerView).getParentDiagram();
            if (diagram.some()) {
                interpreter.setVariable("diagram", diagram.get());
            } else {
                interpreter.setVariable("diagram", null);
            }
            interpreter.setVariable("containerView", (Object)this.containerView);
            interpreter.setVariable("container", (Object)container);
            SelectionDescriptionHelper.computeInput((SelectionDescription)this.tool, (EObject)container, (IInterpreter)interpreter, (TreeItemWrapper)this.input);
            interpreter.unSetVariable(this.tool.getContainerView().getName());
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("container");
        }
    }

    private ImageDescriptor getImage() {
        if (StringUtil.isEmpty((String)this.tool.getWindowImagePath())) {
            return null;
        }
        return DiagramUIPlugin.Implementation.findImageDescriptor(this.tool.getWindowImagePath());
    }

    public String getLabel() {
        return this.tool.getName();
    }
}

