/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.styles;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.BundledImageShape;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.SafeStyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.SimpleStyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.styles.ImageStyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.styles.SimpleSquareStyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.styles.SquareStyleConfiguration;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public final class StyleConfigurationRegistry
extends SessionManagerListener.Stub
implements IStyleConfigurationRegistry {
    private static final SimpleStyleConfiguration DEFAULT_CONFIGURATION = new SimpleStyleConfiguration();
    private static final ProfilerTask GET_CONFIG = new ProfilerTask("Sirius", Messages.StyleConfigurationRegistry_profilerTaskName);
    private static List<IStyleConfigurationProvider> styleConfigurationProviders = new ArrayList<IStyleConfigurationProvider>();
    private static final String STYLE_CONFIGURATION_PROVIDER_EXTENSION_POINT = "org.eclipse.sirius.diagram.ui.styleConfigurationProvider";
    private static final String TAG_ENGINE = "styleConfigurationProvider";
    private static final IStyleConfigurationRegistry INSTANCE;
    private final Map<StyleWrapper, StyleConfiguration> styleToConfig = new WeakHashMap<StyleWrapper, StyleConfiguration>();
    private WeakReference<Invocation> lastInvocation;

    static {
        StyleConfigurationRegistry.parseExtensionMetadata();
        INSTANCE = new StyleConfigurationRegistry();
    }

    private StyleConfigurationRegistry() {
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(STYLE_CONFIGURATION_PROVIDER_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (configElement.getName().equals(TAG_ENGINE)) {
                        try {
                            IStyleConfigurationProvider styleConfigurationProvider = (IStyleConfigurationProvider)configElement.createExecutableExtension("providerClass");
                            styleConfigurationProviders.add(styleConfigurationProvider);
                        }
                        catch (CoreException e) {
                            DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.StyleConfigurationRegistry_styleConfigurationProviderLoadError, configElement.getName()), (Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static IStyleConfigurationRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public StyleConfiguration getStyleConfiguration(DiagramElementMapping vpElementMapping, Style style) {
        StyleConfiguration result = null;
        DslCommonPlugin.PROFILER.startWork(GET_CONFIG);
        if (style != null) {
            Invocation inv;
            StyleDescription styleDescription = style.getDescription();
            if (this.lastInvocation != null && (inv = (Invocation)this.lastInvocation.get()) != null && inv.matches(vpElementMapping, styleDescription)) {
                result = inv.configuration;
            }
            if (result == null) {
                StyleWrapper styleWrapper = new StyleWrapper(vpElementMapping, styleDescription);
                result = this.getStyleConfiguration(styleWrapper, style);
                this.lastInvocation = new WeakReference<Invocation>(new Invocation(vpElementMapping, styleDescription, result));
            }
        } else {
            result = DEFAULT_CONFIGURATION;
        }
        DslCommonPlugin.PROFILER.stopWork(GET_CONFIG);
        return result;
    }

    private StyleConfiguration getStyleConfiguration(StyleWrapper styleWrapper, Style style) {
        StyleConfiguration styleConfiguration = this.styleToConfig.get(styleWrapper);
        if (styleConfiguration == null) {
            styleConfiguration = this.createStyleConfiguration(styleWrapper.vpElementMapping, style);
            this.styleToConfig.put(styleWrapper, styleConfiguration);
        }
        return styleConfiguration;
    }

    private StyleConfiguration createStyleConfiguration(DiagramElementMapping vpElementMapping, Style style) {
        Iterator<IStyleConfigurationProvider> iterProviders = Collections.unmodifiableList(styleConfigurationProviders).iterator();
        while (iterProviders.hasNext()) {
            StyleConfiguration styleConfiguration;
            IStyleConfigurationProvider styleConfigurationProvider = iterProviders.next();
            if (!this.safeProvides(vpElementMapping, style, styleConfigurationProvider, iterProviders) || (styleConfiguration = styleConfigurationProvider.createStyleConfiguration(vpElementMapping, style)) == null) continue;
            return new SafeStyleConfiguration(styleConfiguration);
        }
        SimpleStyleConfiguration styleConfiguration = null;
        if (style instanceof BundledImage) {
            BundledImage bundledImage = (BundledImage)style;
            if (bundledImage.getShape() == BundledImageShape.SQUARE_LITERAL) {
                styleConfiguration = new SquareStyleConfiguration();
            }
        } else if (style instanceof WorkspaceImage) {
            styleConfiguration = new ImageStyleConfiguration();
        } else if (style instanceof Square) {
            styleConfiguration = new SimpleSquareStyleConfiguration();
        }
        if (styleConfiguration == null) {
            styleConfiguration = DEFAULT_CONFIGURATION;
        }
        return styleConfiguration;
    }

    private boolean safeProvides(DiagramElementMapping vpElementMapping, Style style, IStyleConfigurationProvider styleConfigurationProvider, Iterator<IStyleConfigurationProvider> currentIterator) {
        boolean result = false;
        try {
            if (vpElementMapping != null) {
                result = styleConfigurationProvider.provides(vpElementMapping, style);
            }
        }
        catch (Exception e) {
            DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.StyleConfigurationRegistry_disableStyleConfigurationProviderInError, styleConfigurationProvider.getClass().getName()), (Throwable)e);
            currentIterator.remove();
        }
        return result;
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
        HashSet<StyleWrapper> styleWrappersToDelete = new HashSet<StyleWrapper>();
        for (StyleWrapper wrapper : this.styleToConfig.keySet()) {
            if (!EcoreUtil.isAncestor((EObject)deselectedSirius, (EObject)wrapper.vpElementMapping)) continue;
            styleWrappersToDelete.add(wrapper);
        }
        for (StyleWrapper wrapperToDelete : styleWrappersToDelete) {
            this.styleToConfig.remove(wrapperToDelete);
        }
    }

    private static final class Invocation {
        DiagramElementMapping elementMapping;
        StyleDescription styleDescription;
        StyleConfiguration configuration;

        Invocation(DiagramElementMapping mapping, StyleDescription styleDescription, StyleConfiguration configuration) {
            this.elementMapping = mapping;
            this.styleDescription = styleDescription;
            this.configuration = configuration;
        }

        boolean matches(DiagramElementMapping mapping, StyleDescription styleDesc) {
            return this.elementMapping == mapping && this.styleDescription == styleDesc;
        }
    }

    private static class StyleWrapper {
        final DiagramElementMapping vpElementMapping;
        private final StyleDescription style;
        private final int hashCode;

        public StyleWrapper(DiagramElementMapping vpElementMapping, StyleDescription styleDescription) {
            this.vpElementMapping = vpElementMapping;
            this.style = styleDescription;
            this.hashCode = this.computeHashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        protected int computeHashCode() {
            int result = 1;
            result = 31 * result + (this.style == null ? 0 : EcoreUtil.getURI((EObject)this.style).hashCode());
            result = 31 * result + (this.vpElementMapping == null ? 0 : EcoreUtil.getURI((EObject)this.vpElementMapping).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StyleWrapper) {
                StyleWrapper styleWrapper = (StyleWrapper)obj;
                return EqualityHelper.areEquals((EObject)this.style, (EObject)styleWrapper.style) && EqualityHelper.areEquals((EObject)styleWrapper.vpElementMapping, (EObject)this.vpElementMapping);
            }
            return false;
        }
    }
}

